🚀 Thanks for contributing!

Below are templates for various types of issues (Bugs, Security, and Features) separated by horizontal rules. 
Please delete whichever sections of the template you do not need.

# Bugs

If you find a bug, please submit a pull request with a failing test case displaying the bug or just create an issue with as much information as possible.

-------------------------------------------------------------------------------

# Security Issue

If you find a security vulnerability, please contact [tanner@qutheory.io](tanner@qutheory.io) as soon as possible. We take these matters seriously.

-------------------------------------------------------------------------------

# Feature, Enhancement, or Optimization

# Name of Feature

* Author(s): [Developer](https://github.com/<your-username>)

## Introduction

A short description of what the feature is. Try to keep it to a single-paragraph "elevator pitch" so the reader understands what problem this proposal is addressing.

## Motivation

Describe the problems that this proposal seeks to address. If the problem is that some common pattern is currently hard to express, show how one can currently get a similar effect and describe its drawbacks. If it's completely new functionality that cannot be emulated, motivate why this new functionality would help Vapor be a better framework.

## Proposed solution

Describe your solution to the problem. Provide examples and describe how they work. Show how your solution is better than current workarounds: is it cleaner, safer, or more efficient?

## Code snippets

Give us an idea of what this new idea will look like in code. The more code snippets you provide here, the easier it will be for the community to understand what your idea is.

## Impact

Describe the impact that this change will have on existing code. Will some Vapor applications stop compiling due to this change? Will applications still compile but produce different behavior than they used to?

## Alternatives considered

Describe alternative approaches to addressing the same problem, and why you chose this approach instead.