# Projects

People have built some awesome things with Vapor, and we can't wait to see what you add to the list! All projects listed here are live and hosted on the cloud. Please report any links that are no longer active.

* [PDX Cocoaheads Website](#pdx-cocoaheads) - The pdx cocoaheads.com site
* [Vapor Chat](#vapor-chat) - realtime chat site / iOS app
* [Qutheory.io](#qutheoryio) - the official Vapor site
* [Byte Fish](#byte-fish) - url shortener
* [Vapor Dashboard](#vapor-dashboard) - realtime Vapor stats
* [Starred Search](#starred-search) - search the readme files of starred github repos
* [Emergency Numbers](#emergency-numbers-api) - an api providing the emergency number for various locations
* [Slack Bot](#slack-bot) - a basic realtime slackbot
* [Vapor Example](#vapor-example) - an up to date example project
* [SwiftyBeaver](#vapor-example) - the website of SwiftyBeaver
* [Loyalty Backend](#loyalty-backend-sample) - simple loyalty backend system
* [SwiftyBot](#swiftybot) - a simple Telegram bot
* [TinyFaces](#tinyfaces) - an api with random avatars that can be used by designers in their designs
* [Geobot](#geobot) - a simple chat bot built using Wit.ai and Vapor

# PDX Cocoaheads

### GitHub

https://github.com/pdx-cocoaheads/pdxcocoaheads.com

### Site

http://pdxcocoaheads.com

# Vapor Chat

A realtime chat client built with Vapor that feature's an iOS app.

### GitHub

#### Backend

https://github.com/qutheory/vapor-chat

#### iOS Client

https://github.com/qutheory/vapor-chat-ios

### Site

https://vapor-chat.herokuapp.com/

### iOS

https://github.com/qutheory/vapor-chat-ios

# Qutheory.io

Vapor's official site.

### GitHub

https://github.com/qutheory/website

### Site

http://qutheory.io

# Byte Fish

A website that takes shortens long urls for more succinct linking.

### Author

<a href="https://twitter.com/@rosslebeau">@rosslebeau</a>

### GitHub

https://github.com/rosslebeau/bytefish

### Site

https://bytefish.herokuapp.com

# Emergency Numbers API

An API that serves the emergency phone numbers for a given country.

### Author

<a href="https://twitter.com/BalestraPatrick?ref_src=twsrc%5Egoogle%7Ctwcamp%5Eserp%7Ctwgr%5Eauthor">@BalestraPatrick</a>

### GitHub

https://github.com/BalestraPatrick/EmergencyAPI

### Site

https://emergency-phone-numbers.herokuapp.com/

# Starred Search

Search the README files of all of the repos you've starred on GitHub

### Author

<a href="https://twitter.com/mjmsmith">@mjmsmith</a>

### GitHub

https://github.com/mjmsmith/starredsearch

### Site

https://starredsearch.com

# Vapor Dashboard

A live dashboard featuring some Vapor statistics and showing you where other people are visiting in realtime.

### GitHub

https://github.com/qutheory/vapor-dashboard

### Site

https://vapor-dashboard.herokuapp.com

# Slack Bot

A simple starter slack bot built with Vapor. If you join <a href="http://slack.qutheory.io/">our slack</a>, you can talk to myrtle and say hello.

### GitHub

https://github.com/qutheory/slack-bot

### Slack

Myrtle lives <a href="http://slack.qutheory.io/">here.</a>

# Vapor Example

An up to date example repository showing some of Vapor's features

### GitHub

[Vapor Example](https://github.com/qutheory/vapor-example).

# SwiftyBeaver Website

The website of SwiftyBeaver, the logging platform for Swift, is powered by Vapor with Leaf as template engine. Check out the source code on Github for a better understanding how easy it is to create websites with Vapor.

### GitHub

[https://github.com/SwiftyBeaver/SBWebsite](https://github.com/SwiftyBeaver/SBWebsite)

### Site

[swiftybeaver.com](https://swiftybeaver.com)

# Loyalty Backend Sample

Swift Vapor backend solution which won the 1st [appculture](https://github.com/appculture) hackathon (goal was to make a simple Loyalty backend with admin frontend + client mobile app).

### GitHub
[Source](https://github.com/appculture/LoyaltyBackend-SwiftVapor)

### Site
[Demo](https://royalty-loyalty.herokuapp.com)

# SwiftyBot

A simple Telegram & Facebook Messenger bot powered by Vapor.

### GitHub
[Source](https://github.com/FabrizioBrancati/SwiftyBot)

### Site
[Telegram Demo](https://telegram.me/SwiftyBot)

[Facebook Messenger Demo](http://m.me/SwiftyBotMessenger)

# TinyFaces

An api with random avatars that can be used by designers in their designs.

### GitHub
[Source](https://github.com/maximedegreve/TinyFaces)

### Site
[Demo](https://tinyfac.es)

# Geobot

A simple [Wit.ai](https://wit.ai) chat bot powered by Vapor.

### GitHub
[Source](https://github.com/vadymmarkov/geobot)

### Site
[Demo](https://geobot-swift.herokuapp.com)
