org 100h                ; "=)" means "wasting bytes" 
mov bx,0x105            ; safe, compatible, way of setting =)
mov ax,0x4f02           ; 1024x768x256 VESA, shared int10
mov si,z-2              ; pointing to zoom/imag/real
fldz                    ; x (stack)
mov dx,768              ; rows ; 1byte for speed up =)
x: fldz                 ; y x (stack)
mov ch,4                ; number of columns = 1024
y: int 0x10             ; set pixel/ set mode
fld st1                 ; x y x (stack)
fld st1                 ; y x y x (stack)
p: fld st1              ; x y x y x (stack)
fmul st2,st0            ; x y xx y x (stack)
fld st1                 ; y x y xx y x (stack)
fmul st0,st0            ; yy x y xx y x (stack)
fsub dword [si-z+r]     ; yy' x y xx y x (stack)
fsubp st3,st0           ; x y xx-yy' y x (stack)
fmulp st1,st0           ; xy xx-yy' y x (stack)
fadd st0,st0            ; 2xy xx-yy' y x (stack)
fadd dword [si-z+i]     ; 2xy' xx-yy' y x (stack)
ficom word [si]         ; compare for bailout
fnstsw ax               ; status word -> ax
sahf                    ; load compare flag
inc bx                  ; iteration++, zero flag?
ja p                    ; combined flag testing
xchg bx,ax              ; color=iter, reset iteration
mov ah,0x0c             ; int10mode=set pixel
add al,-43              ; beautify, just for 1st frame =)
fcompp                  ; y x (stack)
fadd dword [si]         ; y' x (stack)
loop y                  ; next pixel
fstp st0                ; x (stack)
fadd dword [si]         ; x' (stack)
sub dx,byte 1           ; two bytes more for perfection =)
jnc x                   ; next line
pal: mov cx,258         ; make palette cyclable =)
mov dx,0x3c9            ; port for RGB values
P: imul bx,cx,byte 4    ; * bl = 4 times {0..255}
mov al,bl               ; original palette code by RRROLA*
sar al,1                ; * al = {0..63,-64..0}
je Q                    ; * al==0: cycle RGB->GBR
jns R                   ; i couldnt find better colors
not al                  ; or time to save bytes here
R: out dx,al            ; * = {0..63,63..0}
mul bl                  ; so i took this code
shr ax,7                ; * {0..63,63..0} * {0..255} / 128
Q: out dx,al            ; * = {63..48..0,0..16..63}
mul al                  ; and modified it for cycling
shr ax,6                ; while keeping the original 
out dx,al               ; * = {62..36..0,0..4..62}
loop P                  ; comments, kudos to RRROLA*
out dx,al               ; triple out alignment for cycling
mov al,155              ; set timer to ~30 FPS =)
out 40h,al              ; to smooth & save on VSYNC =)
hlt                     ; wait to next timer event
in al,0x60              ; read keyboard =)
dec ax                  ; ah=0 from shr above! =)
jnz pal                 ; keep cylcing until ESC 
mov al,3                ; set textmode =)
int 0x10                ; before exiting =)
ret                     ; then exit
z:dw 0x38d0             ; zoom value
i:dw 0x3e36             ; imag value
r:dw 0xbf4d             ; real value