/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Matrix3;
import io.lacuna.artifex.Ring2;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.utils.regions.Clip;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.Lists;
import java.util.Arrays;
import java.util.Comparator;

public class Region2 {
    public final Ring2[] rings;
    public final Box2 bounds;

    public Region2(Iterable<Ring2> rings) {
        this((Ring2[])LinearList.from(rings).toArray(Ring2[]::new));
    }

    public Region2(Ring2[] rings) {
        this.rings = (Ring2[])rings.clone();
        Arrays.sort(this.rings, Comparator.comparingDouble(r -> r.area));
        this.bounds = Arrays.stream(this.rings).map(r -> r.bounds).reduce(Box2.EMPTY, Box::union);
    }

    public Ring2[] rings() {
        return this.rings;
    }

    public static Region2 of(Ring2 ... rings) {
        return new Region2(Lists.from(rings));
    }

    public Box2 bounds() {
        return this.bounds;
    }

    public Ring2.Result test(Vec2 p) {
        for (Ring2 r : this.rings) {
            Ring2.Result result2 = r.test(p);
            if (!result2.inside) continue;
            return result2.curve == null && r.isClockwise ? Ring2.Result.OUTSIDE : result2;
        }
        return Ring2.Result.OUTSIDE;
    }

    public boolean contains(Vec2 p) {
        return this.test((Vec2)p).inside;
    }

    public Region2 transform(Matrix3 m) {
        return new Region2((Ring2[])Arrays.stream(this.rings).map(r -> r.transform(m)).toArray(Ring2[]::new));
    }

    public Region2 intersection(Region2 region) {
        return Clip.intersection(this, region);
    }

    public Region2 union(Region2 region) {
        return Clip.union(this, region);
    }

    public Region2 difference(Region2 region) {
        return Clip.difference(this, region);
    }
}

