/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Bezier2;
import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Line2;
import io.lacuna.artifex.Matrix3;
import io.lacuna.artifex.Path2;
import io.lacuna.artifex.Region2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.utils.Intersections;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.Lists;
import java.util.Arrays;
import java.util.Comparator;

public class Ring2 {
    public final Curve2[] curves;
    public final Box2 bounds;
    public final boolean isClockwise;
    public final double area;

    private Ring2(Curve2[] curves, Box2 bounds, boolean isClockwise, double area) {
        this.curves = curves;
        this.bounds = bounds;
        this.isClockwise = isClockwise;
        this.area = area;
    }

    public Ring2(Iterable<Curve2> cs) {
        Box2 bounds = Box2.EMPTY;
        double signedArea = 0.0;
        LinearList list = new LinearList();
        for (Curve2 a2 : cs) {
            for (Curve2 b : a2.split(a2.inflections())) {
                list.addLast(b);
                bounds = (Box2)((Box2)bounds.union(b.start())).union(b.end());
                signedArea += b.signedArea();
            }
        }
        this.isClockwise = signedArea < 0.0;
        this.area = Math.abs(signedArea);
        this.bounds = bounds;
        this.curves = (Curve2[])list.toArray(Curve2[]::new);
        for (int i = 0; i < this.curves.length - 1; ++i) {
            this.curves[i] = this.curves[i].endpoints(this.curves[i].start(), this.curves[i + 1].start());
        }
        int lastIdx = this.curves.length - 1;
        this.curves[lastIdx] = this.curves[lastIdx].endpoints(this.curves[lastIdx].start(), this.curves[0].start());
    }

    public static Ring2 of(Curve2 ... cs) {
        return new Ring2(Lists.from(cs));
    }

    public Region2 region() {
        return new Region2(LinearList.of(this));
    }

    public static Ring2 square() {
        return Box.box(Vec.vec(0.0, 0.0), Vec.vec(1.0, 1.0)).outline();
    }

    public static Ring2 circle() {
        double k = 1.3333333333333333 * (StrictMath.sqrt(2.0) - 1.0);
        return Ring2.of(Bezier2.curve(Vec.vec(1.0, 0.0), Vec.vec(1.0, k), Vec.vec(k, 1.0), Vec.vec(0.0, 1.0)), Bezier2.curve(Vec.vec(0.0, 1.0), Vec.vec(-k, 1.0), Vec.vec(-1.0, k), Vec.vec(-1.0, 0.0)), Bezier2.curve(Vec.vec(-1.0, 0.0), Vec.vec(-1.0, -k), Vec.vec(-k, -1.0), Vec.vec(0.0, -1.0)), Bezier2.curve(Vec.vec(0.0, -1.0), Vec.vec(k, -1.0), Vec.vec(1.0, -k), Vec.vec(1.0, 0.0)));
    }

    public Path2 path() {
        return new Path2(this);
    }

    public Ring2 reverse() {
        return new Ring2((Curve2[])LinearList.from(Lists.reverse(Lists.lazyMap(Lists.from(this.curves), Curve2::reverse))).toArray(Curve2[]::new), this.bounds, !this.isClockwise, this.area);
    }

    public Result test(Vec2 p) {
        if (!((Box2)this.bounds.expand(1.0E-10)).contains(p)) {
            return Result.OUTSIDE;
        }
        Line2 ray = Line2.line(p, Vec.vec(this.bounds.ux + 1.0, p.y));
        int count2 = 0;
        for (Curve2 c2 : this.curves) {
            boolean flat;
            Box2 b = c2.bounds();
            boolean bl = flat = b.height() == 0.0;
            if (p.x < b.lx) {
                if (!(p.y >= b.ly) || !(p.y < b.uy)) continue;
                ++count2;
                continue;
            }
            if (!((Box2)b.expand(Vec.vec(1.0E-10, 0.0))).contains(p)) continue;
            Vec2 i = Arrays.stream(Intersections.lineCurve(ray, c2)).map(v -> v.map(n -> Intersections.round(n, 1.0E-6))).filter(Intersections.PARAMETRIC_BOUNDS::contains).min(Comparator.comparingDouble(v -> v.x)).orElse(null);
            if (i == null) continue;
            if (i.x == 0.0) {
                return new Result(c2);
            }
            if (flat || !(p.y < b.uy)) continue;
            ++count2;
        }
        return count2 % 2 == 1 ? Result.INSIDE : Result.OUTSIDE;
    }

    public Ring2 transform(Matrix3 m) {
        return new Ring2(() -> Arrays.stream(this.curves).map(c2 -> c2.transform(m)).iterator());
    }

    public static class Result {
        public static final Result INSIDE = new Result(true, null);
        public static final Result OUTSIDE = new Result(false, null);
        public final boolean inside;
        public final Curve2 curve;

        private Result(boolean inside, Curve2 curve) {
            this.inside = inside;
            this.curve = curve;
        }

        public Result(Curve2 curve) {
            this(true, curve);
        }

        public String toString() {
            if (this.inside) {
                return this.curve == null ? "INSIDE" : "EDGE: " + this.curve;
            }
            return "OUTSIDE";
        }
    }
}

