/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.nodes;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.nodes.Util;
import io.lacuna.bifurcan.utils.ArrayVector;
import io.lacuna.bifurcan.utils.Bits;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

public class MapNodes {
    private static int hashMask(int hash, int shift2) {
        return 1 << (hash >>> shift2 & 0x1F);
    }

    public static <K, V> boolean contains(Node<K, V> node, int shift2, int hash, K key, BiPredicate<K, K> equals) {
        return MapNodes.get(node, shift2, hash, key, equals, Util.DEFAULT_VALUE) != Util.DEFAULT_VALUE;
    }

    public static <K, V> Object get(Node<K, V> node, int shift2, int hash, K key, BiPredicate<K, K> equals, Object defaultValue) {
        INode<K, V> currNode = node;
        while (!(currNode instanceof Collision)) {
            Node<K, V> n = currNode;
            int mask = MapNodes.hashMask(hash, shift2);
            if (((Node)n).isEntry(mask)) {
                int idx = ((Node)n).entryIndex(mask) << 1;
                return equals.test(key, n.content[idx]) ? n.content[idx + 1] : defaultValue;
            }
            if (((Node)n).isNode(mask)) {
                currNode = ((Node)n).node(mask);
                shift2 += 5;
                continue;
            }
            return defaultValue;
        }
        Collision c2 = (Collision)currNode;
        return c2.get(hash, key, equals, defaultValue);
    }

    public static <K, V> INode<K, V> mergeNodes(int shift2, Object editor, INode<K, V> a2, INode<K, V> b, BiPredicate<K, K> equals, BinaryOperator<V> merge) {
        if (a2 instanceof Node && b instanceof Node) {
            return MapNodes.merge(shift2, editor, (Node)a2, (Node)b, equals, merge);
        }
        if (a2 instanceof Node && b instanceof Collision) {
            INode na = (Node)a2;
            Collision cb = (Collision)b;
            for (IEntry e : cb.entries()) {
                na = na.put(shift2, editor, cb.hash, e.key(), e.value(), (BiPredicate)equals, (BinaryOperator)merge);
            }
            return na;
        }
        if (a2 instanceof Collision && b instanceof Node) {
            BinaryOperator inverted = (x, y) -> merge.apply(y, x);
            Collision ca = (Collision)a2;
            INode nb = (Node)b;
            for (IEntry e : ca.entries()) {
                nb = nb.put(shift2, editor, ca.hash, e.key(), e.value(), (BiPredicate)equals, inverted);
            }
            return nb;
        }
        Collision cb = (Collision)b;
        for (IEntry e : cb.entries()) {
            a2 = a2.put(shift2, editor, cb.hash, e.key(), e.value(), equals, merge);
        }
        return a2;
    }

    public static <K, V> Node<K, V> merge(int shift2, Object editor, Node<K, V> a2, Node<K, V> b, BiPredicate<K, K> equals, BinaryOperator<V> merge) {
        INode<K, V> result2 = new Node<K, V>(editor);
        PrimitiveIterator.OfInt masks = Util.masks(a2.datamap | a2.nodemap | b.datamap | b.nodemap);
        while (masks.hasNext()) {
            int mask = masks.nextInt();
            int state = Util.mergeState(mask, a2.nodemap, a2.datamap, b.nodemap, b.datamap);
            switch (state) {
                case 1: 
                case 4: {
                    result2 = MapNodes.transferNode(mask, state == 1 ? a2 : b, result2);
                    break;
                }
                case 2: 
                case 8: {
                    result2 = MapNodes.transferEntry(mask, state == 2 ? a2 : b, result2);
                    break;
                }
                case 10: {
                    result2 = MapNodes.transferEntry(mask, a2, result2);
                    int idx = ((Node)b).entryIndex(mask);
                    result2 = result2.put(shift2, editor, b.hash(idx), b.content[idx << 1], b.content[(idx << 1) + 1], (BiPredicate)equals, (BinaryOperator)merge);
                    break;
                }
                case 5: {
                    result2 = result2.putNode(mask, MapNodes.mergeNodes(shift2 + 5, editor, ((Node)a2).node(mask), ((Node)b).node(mask), equals, merge));
                    break;
                }
                case 9: {
                    int idx = ((Node)b).entryIndex(mask);
                    result2 = result2.putNode(mask, ((Node)a2).node(mask)).put(shift2, editor, b.hash(idx), b.content[idx << 1], b.content[(idx << 1) + 1], (BiPredicate)equals, (BinaryOperator)merge);
                    break;
                }
                case 6: {
                    int idx = ((Node)a2).entryIndex(mask);
                    result2 = result2.putNode(mask, ((Node)b).node(mask)).put(shift2, editor, a2.hash(idx), a2.content[idx << 1], a2.content[(idx << 1) + 1], (BiPredicate)equals, (x, y) -> merge.apply(y, x));
                    break;
                }
            }
        }
        return result2;
    }

    public static <K, V> INode<K, V> diffNodes(int shift2, Object editor, INode<K, V> a2, INode<K, V> b, BiPredicate<K, K> equals) {
        if (a2 instanceof Node && b instanceof Node) {
            return MapNodes.difference(shift2, editor, (Node)a2, (Node)b, equals);
        }
        if (a2 instanceof Node && b instanceof Collision) {
            Collision cb = (Collision)b;
            for (IEntry e : cb.entries()) {
                a2 = a2.remove(shift2, editor, cb.hash, e.key(), equals);
            }
            return a2.size() > 0L ? a2 : null;
        }
        if (a2 instanceof Collision && b instanceof Node) {
            Collision ca = (Collision)a2;
            Node nb = (Node)b;
            for (IEntry e : ca.entries()) {
                if (MapNodes.get(nb, shift2, ca.hash, e.key(), equals, Util.DEFAULT_VALUE) == Util.DEFAULT_VALUE) continue;
                ca = (Collision)ca.remove(shift2, editor, ca.hash, e.key(), equals);
            }
            return ca.size() > 0L ? ca : null;
        }
        Collision ca = (Collision)a2;
        Collision cb = (Collision)b;
        if (ca.hash == cb.hash) {
            for (IEntry e : cb.entries()) {
                ca = (Collision)ca.remove(shift2, editor, ca.hash, e.key(), equals);
            }
        }
        return ca.size() > 0L ? ca : null;
    }

    public static <K, V> Node<K, V> difference(int shift2, Object editor, Node<K, V> a2, Node<K, V> b, BiPredicate<K, K> equals) {
        Node<Object, V> result2 = new Node<Object, V>(editor);
        PrimitiveIterator.OfInt masks = Util.masks(a2.nodemap | a2.datamap | b.nodemap | b.datamap);
        while (masks.hasNext()) {
            int mask = masks.nextInt();
            int state = Util.mergeState(mask, a2.nodemap, a2.datamap, b.nodemap, b.datamap);
            switch (state) {
                case 1: {
                    result2 = MapNodes.transferNode(mask, a2, result2);
                    break;
                }
                case 2: {
                    result2 = MapNodes.transferEntry(mask, a2, result2);
                    break;
                }
                case 10: {
                    int ia = ((Node)a2).entryIndex(mask);
                    int ib = ((Node)b).entryIndex(mask);
                    if (b.hashes[ib] == a2.hashes[ia] && equals.test(b.content[ib << 1], a2.content[ia << 1])) break;
                    result2 = MapNodes.transferEntry(mask, a2, result2);
                    break;
                }
                case 5: {
                    INode<Object, V> n = MapNodes.diffNodes(shift2 + 5, editor, ((Node)a2).node(mask), ((Node)b).node(mask), equals);
                    if (n == null) break;
                    result2 = result2.putNode(mask, n);
                    break;
                }
                case 9: {
                    int idx = ((Node)b).entryIndex(mask);
                    INode<Object, V> n = ((Node)a2).node(mask).remove(shift2 + 5, editor, b.hashes[idx], b.content[idx << 1], equals);
                    if (n.size() <= 0L) break;
                    result2 = result2.putNode(mask, n);
                    break;
                }
                case 6: {
                    int idx = ((Node)a2).entryIndex(mask);
                    if (MapNodes.get(b, shift2, a2.hashes[idx], a2.content[idx << 1], equals, Util.DEFAULT_VALUE) != Util.DEFAULT_VALUE) break;
                    result2 = MapNodes.transferEntry(mask, a2, result2);
                    break;
                }
            }
        }
        return result2.size() > 0L ? result2 : null;
    }

    public static <K, V> INode<K, V> intersectNodes(int shift2, Object editor, INode<K, V> a2, INode<K, V> b, BiPredicate<K, K> equals) {
        if (a2 instanceof Node && b instanceof Node) {
            return MapNodes.intersection(shift2, editor, (Node)a2, (Node)b, equals);
        }
        if (a2 instanceof Node && b instanceof Collision) {
            Collision cb = (Collision)b;
            Node na = (Node)a2;
            Collision result2 = new Collision(cb.hash, new Object[0]);
            for (IEntry<K, V> e : b.entries()) {
                Object val = MapNodes.get(na, shift2, cb.hash, e.key(), equals, Util.DEFAULT_VALUE);
                if (val == Util.DEFAULT_VALUE) continue;
                result2 = (Collision)result2.put(shift2, editor, cb.hash, e.key(), val, equals, null);
            }
            return result2.size() > 0L ? result2 : null;
        }
        if (a2 instanceof Collision && b instanceof Node) {
            Collision ca = (Collision)a2;
            Node nb = (Node)b;
            for (IEntry e : ca.entries()) {
                if (MapNodes.contains(nb, shift2, ca.hash, e.key(), equals)) continue;
                ca = (Collision)ca.remove(shift2, editor, ca.hash, e.key(), equals);
            }
            return ca.size() > 0L ? ca : null;
        }
        Collision ca = (Collision)a2;
        Collision cb = (Collision)b;
        if (ca.hash != cb.hash) {
            return null;
        }
        for (IEntry e : ca.entries()) {
            if (cb.contains(ca.hash, e.key(), equals)) continue;
            ca = (Collision)ca.remove(shift2, editor, ca.hash, e.key(), equals);
        }
        return ca.size() > 0L ? ca : null;
    }

    public static <K, V> Node<K, V> intersection(int shift2, Object editor, Node<K, V> a2, Node<K, V> b, BiPredicate<K, K> equals) {
        INode<K, V> result2 = new Node<K, V>(editor);
        PrimitiveIterator.OfInt masks = Util.masks(a2.nodemap | a2.datamap | b.nodemap | b.datamap);
        while (masks.hasNext()) {
            int mask = masks.nextInt();
            int state = Util.mergeState(mask, a2.nodemap, a2.datamap, b.nodemap, b.datamap);
            switch (state) {
                case 10: {
                    int ia = ((Node)a2).entryIndex(mask);
                    int ib = ((Node)b).entryIndex(mask);
                    if (b.hashes[ib] != a2.hashes[ia] || !equals.test(b.content[ib << 1], a2.content[ia << 1])) break;
                    result2 = MapNodes.transferEntry(mask, a2, result2);
                    break;
                }
                case 5: {
                    INode<K, V> n = MapNodes.intersectNodes(shift2 + 5, editor, ((Node)a2).node(mask), ((Node)b).node(mask), equals);
                    if (n == null) break;
                    result2 = result2.putNode(mask, n);
                    break;
                }
                case 9: {
                    int idx = ((Node)b).entryIndex(mask);
                    int hash = b.hashes[idx];
                    Object key = b.content[idx << 1];
                    Object val = MapNodes.get(a2, shift2, hash, key, equals, Util.DEFAULT_VALUE);
                    if (val == Util.DEFAULT_VALUE) break;
                    result2 = result2.put(shift2, editor, hash, key, val, (BiPredicate)equals, (BinaryOperator)null);
                    break;
                }
                case 6: {
                    int idx = ((Node)a2).entryIndex(mask);
                    if (MapNodes.get(b, shift2, a2.hashes[idx], a2.content[idx << 1], equals, Util.DEFAULT_VALUE) == Util.DEFAULT_VALUE) break;
                    result2 = MapNodes.transferEntry(mask, a2, result2);
                    break;
                }
            }
        }
        return result2.size() > 0L ? result2 : null;
    }

    public static <K, V> IList<Node<K, V>> split(Object editor, Node<K, V> node, int targetSize) {
        LinearList result2 = new LinearList();
        if (node.size() >> 1 < (long)targetSize) {
            result2.addLast(node);
        } else {
            Node acc = new Node(editor);
            PrimitiveIterator.OfInt masks = Util.masks(node.datamap | node.nodemap);
            while (masks.hasNext()) {
                int mask = masks.nextInt();
                if (acc.size() >= (long)targetSize) {
                    result2.addLast(acc);
                    acc = new Node(editor);
                }
                if (((Node)node).isEntry(mask)) {
                    acc = MapNodes.transferEntry(mask, node, acc);
                    continue;
                }
                if (!((Node)node).isNode(mask)) continue;
                INode child = ((Node)node).node(mask);
                if (child instanceof Node && child.size() >= (long)(targetSize << 1)) {
                    MapNodes.split(editor, (Node)child, targetSize).stream().map(n -> new Node(editor).putNode(mask, n)).forEach(result2::addLast);
                    continue;
                }
                acc = acc.putNode(mask, child);
            }
            if (acc.size() > 0L) {
                result2.addLast(acc);
            }
        }
        return result2;
    }

    private static <K, V> Node<K, V> transferNode(int mask, Node<K, V> src, Node<K, V> dst) {
        return dst.putNode(mask, ((Node)src).node(mask));
    }

    private static <K, V> Node<K, V> transferEntry(int mask, Node<K, V> src, Node<K, V> dst) {
        int idx = ((Node)src).entryIndex(mask);
        return dst.putEntry(mask, src.hashes[idx], src.content[idx << 1], src.content[(idx << 1) + 1]);
    }

    public static class Collision<K, V>
    implements INode<K, V> {
        public final int hash;
        public final Object[] entries;

        public Collision(int hash, K k1, V v1, K k2, V v2) {
            this(hash, new Object[]{k1, v1, k2, v2});
        }

        private Collision(int hash, Object[] entries) {
            this.hash = hash;
            this.entries = entries;
        }

        public boolean contains(int hash, K key, BiPredicate<K, K> equals) {
            return this.get(hash, key, equals, Util.DEFAULT_VALUE) != Util.DEFAULT_VALUE;
        }

        public Object get(int hash, K key, BiPredicate<K, K> equals, Object defaultValue) {
            if (hash != this.hash) {
                return defaultValue;
            }
            int idx = this.indexOf(key, equals);
            if (idx < 0) {
                return defaultValue;
            }
            return this.entries[idx + 1];
        }

        @Override
        public int hash(int idx) {
            return this.hash;
        }

        @Override
        public IEntry<K, V> nth(long idx) {
            int i = (int)idx << 1;
            return new Maps.Entry<Object, Object>(this.entries[i], this.entries[i + 1]);
        }

        @Override
        public long indexOf(int shift2, int hash, K key, BiPredicate<K, K> equals) {
            if (this.hash == hash) {
                for (int i = 0; i < this.entries.length; i += 2) {
                    if (!equals.test(key, this.entries[i])) continue;
                    return i >> 1;
                }
            }
            return -1L;
        }

        @Override
        public INode<K, V> put(int shift2, Object editor, int hash, K key, V value2, BiPredicate<K, K> equals, BinaryOperator<V> merge) {
            if (hash != this.hash) {
                return new Node(editor).putNode(MapNodes.hashMask(this.hash, shift2), this).put(shift2, editor, hash, (Object)key, (Object)value2, (BiPredicate)equals, (BinaryOperator)merge);
            }
            int idx = this.indexOf(key, equals);
            return idx < 0 ? new Collision<K, V>(hash, ArrayVector.append(this.entries, key, value2)) : new Collision<K, V>(hash, ArrayVector.set(this.entries, idx, key, merge.apply(this.entries[idx + 1], value2)));
        }

        @Override
        public INode<K, V> remove(int shift2, Object editor, int hash, K key, BiPredicate<K, K> equals) {
            if (hash != this.hash) {
                return this;
            }
            int idx = this.indexOf(key, equals);
            return idx < 0 ? this : new Collision<K, V>(hash, ArrayVector.remove(this.entries, idx, 2));
        }

        @Override
        public <U> Collision<K, U> mapVals(Object editor, BiFunction<K, V, U> f) {
            Collision<K, V> c2 = new Collision<K, V>(this.hash, (Object[])this.entries.clone());
            for (int i = 0; i < this.entries.length; i += 2) {
                c2.entries[i + 1] = f.apply(c2.entries[i], c2.entries[i + 1]);
            }
            return c2;
        }

        @Override
        public Iterable<IEntry<K, V>> entries() {
            return () -> Iterators.range(this.entries.length >> 1, i -> {
                int idx = (int)(i << 1);
                return new Maps.Entry<Object, Object>(this.entries[idx], this.entries[idx + 1]);
            });
        }

        @Override
        public long size() {
            return this.entries.length >> 1;
        }

        @Override
        public boolean equals(INode<K, V> o, BiPredicate<K, K> keyEquals, BiPredicate<V, V> valEquals) {
            Collision c2;
            if (this == o) {
                return true;
            }
            if (o instanceof Collision && (c2 = (Collision)o).size() == this.size()) {
                for (IEntry<K, V> e : this.entries()) {
                    int idx = c2.indexOf(e.key(), keyEquals);
                    if (idx >= 0 && valEquals.test(e.value(), this.entries[idx + 1])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private int indexOf(K key, BiPredicate<K, K> equals) {
            for (int i = 0; i < this.entries.length; i += 2) {
                if (!equals.test(key, this.entries[i])) continue;
                return i;
            }
            return -1;
        }
    }

    public static class Node<K, V>
    implements INode<K, V> {
        public static final Node EMPTY = new Node(new Object());
        public static final int SHIFT_INCREMENT = 5;
        public int datamap = 0;
        public int nodemap = 0;
        public int[] hashes;
        public Object[] content;
        Object editor;
        long size;

        public Node() {
        }

        private Node(Object editor) {
            this.editor = editor;
            this.hashes = new int[2];
            this.content = new Object[4];
        }

        @Override
        public long indexOf(int shift2, int hash, K key, BiPredicate<K, K> equals) {
            int mask = MapNodes.hashMask(hash, shift2);
            if (this.isEntry(mask)) {
                int idx = this.entryIndex(mask);
                return equals.test(key, this.content[idx << 1]) ? (long)idx : -1L;
            }
            if (this.isNode(mask)) {
                long idx = this.node(mask).indexOf(shift2 + 5, hash, key, equals);
                if (idx == -1L) {
                    return -1L;
                }
                int nodeIdx = this.nodeIndex(mask);
                idx += (long)Integer.bitCount(this.datamap);
                for (int i = 0; i < nodeIdx; ++i) {
                    idx += ((INode)this.content[this.content.length - (i + 1)]).size();
                }
                return idx;
            }
            return -1L;
        }

        @Override
        public IEntry<K, V> nth(long idx) {
            int numEntries = Integer.bitCount(this.datamap);
            if (idx < (long)numEntries) {
                int contentIdx = (int)(idx << 1);
                return new Maps.Entry<Object, Object>(this.content[contentIdx], this.content[contentIdx + 1]);
            }
            if (idx < this.size) {
                idx -= (long)numEntries;
                for (INode<K, V> node : this.nodes()) {
                    if (idx < node.size()) {
                        return node.nth(idx);
                    }
                    idx -= node.size();
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int hash(int idx) {
            return this.hashes[idx];
        }

        private boolean mergeEntry(int shift2, int mask, int hash, K key, V value2, BiPredicate<K, K> equals, BinaryOperator<V> merge) {
            boolean collision;
            int idx = this.entryIndex(mask);
            boolean bl = collision = hash == this.hashes[idx];
            if (collision && equals.test(key, this.content[idx << 1])) {
                idx = (idx << 1) + 1;
                this.content[idx] = merge.apply(this.content[idx], value2);
                return false;
            }
            Object currKey = this.content[idx << 1];
            Object currValue = this.content[(idx << 1) + 1];
            INode<Object, Object> node = collision ? new Collision<Object, Object>(hash, currKey, currValue, key, value2) : ((Node)new Node<K, V>(this.editor).put(shift2 + 5, this.editor, this.hashes[idx], currKey, currValue, (BiPredicate)equals, (BinaryOperator)merge)).put(shift2 + 5, this.editor, hash, (Object)key, (Object)value2, (BiPredicate)equals, (BinaryOperator)merge);
            this.removeEntry(mask).putNode(mask, node);
            return true;
        }

        @Override
        public Node<K, V> put(int shift2, Object editor, int hash, K key, V value2, BiPredicate<K, K> equals, BinaryOperator<V> merge) {
            boolean increment;
            int currShift;
            Node n;
            block5: {
                int mask;
                block6: {
                    INode<K, V> child;
                    if (editor != this.editor) {
                        return this.clone(editor).put(shift2, editor, hash, (Object)key, (Object)value2, (BiPredicate)equals, (BinaryOperator)merge);
                    }
                    n = this;
                    currShift = shift2;
                    while (true) {
                        if (n.isEntry(mask = MapNodes.hashMask(hash, currShift))) {
                            increment = n.mergeEntry(currShift, mask, hash, key, value2, equals, merge);
                            break block5;
                        }
                        if (!n.isNode(mask)) break block6;
                        child = n.node(mask);
                        if (!(child instanceof Node) || ((Node)child).editor != editor) break;
                        n = (Node)child;
                        currShift += 5;
                    }
                    long prevSize = child.size();
                    INode<K, V> nodePrime = child.put(currShift + 5, editor, hash, key, value2, equals, merge);
                    increment = nodePrime.size() != prevSize;
                    n.setNode(mask, nodePrime, increment ? 1L : 0L);
                    break block5;
                }
                n.putEntry(mask, hash, key, value2);
                increment = true;
            }
            if (n != this && increment) {
                Node currNode = this;
                currShift = shift2;
                while (currNode != n) {
                    ++currNode.size;
                    currNode = (Node)currNode.node(MapNodes.hashMask(hash, currShift));
                    currShift += 5;
                }
            }
            return this;
        }

        @Override
        public INode<K, V> remove(int shift2, Object editor, int hash, K key, BiPredicate<K, K> equals) {
            int mask = MapNodes.hashMask(hash, shift2);
            if (this.isEntry(mask)) {
                int idx = this.entryIndex(mask);
                if (this.hashes[idx] == hash && equals.test(key, this.content[idx << 1])) {
                    return super.collapse(shift2);
                }
                return this;
            }
            if (this.isNode(mask)) {
                INode<K, V> node = this.node(mask);
                long prevSize = node.size();
                INode<K, V> nodePrime = node.remove(shift2 + 5, editor, hash, key, equals);
                Node<K, V> n = this.editor == editor ? this : super.clone(editor);
                switch ((int)nodePrime.size()) {
                    case 0: {
                        return super.collapse(shift2);
                    }
                    case 1: {
                        IEntry<K, V> e = nodePrime.nth(0L);
                        return n.removeNode(mask, prevSize).putEntry(mask, nodePrime.hash(0), e.key(), e.value());
                    }
                }
                return super.collapse(shift2);
            }
            return this;
        }

        @Override
        public <U> Node<K, U> mapVals(Object editor, BiFunction<K, V, U> f) {
            int i;
            Node<K, V> n = this.clone(editor);
            for (i = Integer.bitCount(n.datamap) - 1; i >= 0; --i) {
                int idx = i << 1;
                n.content[idx + 1] = f.apply(n.content[idx], n.content[idx + 1]);
            }
            for (i = this.content.length - Integer.bitCount(n.nodemap); i < this.content.length; ++i) {
                n.content[i] = ((INode)n.content[i]).mapVals(editor, f);
            }
            return n;
        }

        public Iterator<IEntry<K, V>> iterator() {
            return new Iterator<IEntry<K, V>>(){
                final Node[] stack = new Node[7];
                final byte[] cursors = new byte[14];
                int depth = 0;
                Object[] content;
                int idx;
                int limit;
                {
                    this.stack[0] = this;
                    this.cursors[1] = (byte)Integer.bitCount(nodemap);
                    this.content = content;
                    this.idx = 0;
                    this.limit = Integer.bitCount(datamap) << 1;
                }

                private boolean nextNode() {
                    while (this.depth >= 0) {
                        int pos = this.depth << 1;
                        byte idx = this.cursors[pos];
                        byte limit = this.cursors[pos + 1];
                        if (idx < limit) {
                            Node curr = this.stack[this.depth];
                            INode next = (INode)curr.content[curr.content.length - 1 - idx];
                            int n = pos;
                            this.cursors[n] = (byte)(this.cursors[n] + 1);
                            if (next instanceof Node) {
                                Node n2 = (Node)next;
                                if (n2.nodemap != 0) {
                                    this.stack[++this.depth] = n2;
                                    this.cursors[pos + 2] = 0;
                                    this.cursors[pos + 3] = (byte)Integer.bitCount(n2.nodemap);
                                }
                                if (n2.datamap == 0) continue;
                                this.content = n2.content;
                                this.idx = 0;
                                this.limit = Integer.bitCount(n2.datamap) << 1;
                                return true;
                            }
                            Collision c2 = (Collision)next;
                            this.content = c2.entries;
                            this.idx = 0;
                            this.limit = c2.entries.length;
                            return true;
                        }
                        --this.depth;
                    }
                    return false;
                }

                @Override
                public boolean hasNext() {
                    return this.idx < this.limit || this.nextNode();
                }

                @Override
                public IEntry<K, V> next() {
                    if (this.idx >= this.limit && !this.nextNode()) {
                        throw new NoSuchElementException();
                    }
                    Maps.Entry<Object, Object> e = new Maps.Entry<Object, Object>(this.content[this.idx], this.content[this.idx + 1]);
                    this.idx += 2;
                    return e;
                }
            };
        }

        @Override
        public Iterable<IEntry<K, V>> entries() {
            return () -> Iterators.range(Integer.bitCount(this.datamap), i -> {
                int idx = (int)(i << 1);
                return new Maps.Entry<Object, Object>(this.content[idx], this.content[idx + 1]);
            });
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public boolean equals(INode<K, V> o, BiPredicate<K, K> keyEquals, BiPredicate<V, V> valEquals) {
            if (this == o) {
                return true;
            }
            if (o instanceof Node) {
                Node n = (Node)o;
                if (n.size == this.size && n.datamap == this.datamap && n.nodemap == this.nodemap) {
                    Iterator<IEntry<K, V>> ea = this.entries().iterator();
                    Iterator<IEntry<K, V>> eb = n.entries().iterator();
                    while (ea.hasNext()) {
                        if (ea.next().equals(eb.next(), keyEquals, valEquals)) continue;
                        return false;
                    }
                    Iterator<INode<K, V>> na = this.nodes().iterator();
                    Iterator<INode<K, V>> nb = n.nodes().iterator();
                    while (na.hasNext()) {
                        if (na.next().equals(nb.next(), keyEquals, valEquals)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        private Node<K, V> clone(Object editor) {
            Node<K, V> node = new Node<K, V>();
            node.datamap = this.datamap;
            node.nodemap = this.nodemap;
            node.hashes = (int[])this.hashes.clone();
            node.content = (Object[])this.content.clone();
            node.editor = editor;
            node.size = this.size;
            return node;
        }

        private Iterable<INode<K, V>> nodes() {
            return () -> Iterators.range(0L, Integer.bitCount(this.nodemap), i -> (INode)this.content[this.content.length - 1 - (int)i]);
        }

        private INode<K, V> collapse(int shift2) {
            return shift2 > 0 && this.datamap == 0 && Bits.isPowerOfTwo(this.nodemap) && this.node(this.nodemap) instanceof Collision ? this.node(this.nodemap) : this;
        }

        private void grow() {
            if (this.content.length == 64) {
                return;
            }
            Object[] c2 = new Object[this.content.length << 1];
            int[] h = new int[this.hashes.length << 1];
            int numNodes = Integer.bitCount(this.nodemap);
            int numEntries = Integer.bitCount(this.datamap);
            System.arraycopy(this.content, 0, c2, 0, numEntries << 1);
            System.arraycopy(this.content, this.content.length - numNodes, c2, c2.length - numNodes, numNodes);
            System.arraycopy(this.hashes, 0, h, 0, numEntries);
            this.hashes = h;
            this.content = c2;
        }

        Node<K, V> putEntry(int mask, int hash, K key, V value2) {
            int numEntries = Integer.bitCount(this.datamap);
            int count2 = (numEntries << 1) + Integer.bitCount(this.nodemap);
            if (count2 + 2 > this.content.length) {
                this.grow();
            }
            int idx = this.entryIndex(mask);
            int entryIdx = idx << 1;
            if (idx != numEntries) {
                System.arraycopy(this.content, entryIdx, this.content, entryIdx + 2, numEntries - idx << 1);
                System.arraycopy(this.hashes, idx, this.hashes, idx + 1, numEntries - idx);
            }
            this.datamap |= mask;
            ++this.size;
            this.hashes[idx] = hash;
            this.content[entryIdx] = key;
            this.content[entryIdx + 1] = value2;
            return this;
        }

        Node<K, V> removeEntry(int mask) {
            int numEntries;
            int idx = this.entryIndex(mask);
            if (idx != (numEntries = Integer.bitCount(this.datamap)) - 1) {
                System.arraycopy(this.content, idx + 1 << 1, this.content, idx << 1, numEntries - 1 - idx << 1);
                System.arraycopy(this.hashes, idx + 1, this.hashes, idx, numEntries - 1 - idx);
            }
            this.datamap &= ~mask;
            --this.size;
            int entryIdx = numEntries - 1 << 1;
            this.content[entryIdx] = null;
            this.content[entryIdx + 1] = null;
            return this;
        }

        Node<K, V> setNode(int mask, INode<K, V> node, long sizeDelta) {
            this.content[this.content.length - 1 - this.nodeIndex((int)mask)] = node;
            this.size += sizeDelta;
            return this;
        }

        Node<K, V> putNode(int mask, INode<K, V> node) {
            if (node.size() == 1L) {
                IEntry<K, V> e = node.nth(0L);
                return this.putEntry(mask, node.hash(0), e.key(), e.value());
            }
            int count2 = (Integer.bitCount(this.datamap) << 1) + Integer.bitCount(this.nodemap);
            if (count2 + 1 > this.content.length) {
                this.grow();
            }
            int idx = this.nodeIndex(mask);
            int numNodes = Integer.bitCount(this.nodemap);
            if (numNodes > 0) {
                System.arraycopy(this.content, this.content.length - numNodes, this.content, this.content.length - 1 - numNodes, numNodes - idx);
            }
            this.nodemap |= mask;
            this.size += node.size();
            this.content[this.content.length - 1 - idx] = node;
            return this;
        }

        Node<K, V> removeNode(int mask, long nodeSize) {
            int idx = this.nodeIndex(mask);
            int numNodes = Integer.bitCount(this.nodemap);
            this.size -= nodeSize;
            System.arraycopy(this.content, this.content.length - numNodes, this.content, this.content.length + 1 - numNodes, numNodes - 1 - idx);
            this.nodemap &= ~mask;
            this.content[this.content.length - numNodes] = null;
            return this;
        }

        private int entryIndex(int mask) {
            return Util.compressedIndex(this.datamap, mask);
        }

        private int nodeIndex(int mask) {
            return Util.compressedIndex(this.nodemap, mask);
        }

        private INode<K, V> node(int mask) {
            return (INode)this.content[this.content.length - 1 - this.nodeIndex(mask)];
        }

        private boolean isEntry(int mask) {
            return (this.datamap & mask) != 0;
        }

        private boolean isNode(int mask) {
            return (this.nodemap & mask) != 0;
        }
    }

    static interface INode<K, V> {
        public INode<K, V> put(int var1, Object var2, int var3, K var4, V var5, BiPredicate<K, K> var6, BinaryOperator<V> var7);

        public INode<K, V> remove(int var1, Object var2, int var3, K var4, BiPredicate<K, K> var5);

        public <U> INode<K, U> mapVals(Object var1, BiFunction<K, V, U> var2);

        public int hash(int var1);

        public long size();

        public IEntry<K, V> nth(long var1);

        public long indexOf(int var1, int var2, K var3, BiPredicate<K, K> var4);

        public Iterable<IEntry<K, V>> entries();

        public boolean equals(INode<K, V> var1, BiPredicate<K, K> var2, BiPredicate<V, V> var3);
    }
}

