/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRStreamProducerEGLSurface {
    public static final int EGL_STREAM_BIT_KHR = 2048;

    protected KHRStreamProducerEGLSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateStreamProducerSurfaceKHR);
    }

    public static long neglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamProducerSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(stream);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, stream, attrib_list);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreateStreamProducerSurfaceKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLStreamKHR") long stream, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return KHRStreamProducerEGLSurface.neglCreateStreamProducerSurfaceKHR(dpy, config, stream, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLSurface")
    public static long eglCreateStreamProducerSurfaceKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="EGLStreamKHR") long stream, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamProducerSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(config);
            Checks.check(stream);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, stream, attrib_list);
    }
}

