/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.binpack;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.binpack.PackNode;
import org.openrndr.binpack.Splitter;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u00c5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00128\b\u0002\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00128\b\u0002\u0010\r\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00128\b\u0002\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0003H\u0016RA\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015RA\u0010\r\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011RA\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/binpack/CenteredBinarySplitter;", "Lorg/openrndr/binpack/Splitter;", "enclosement", "Lorg/openrndr/shape/IntRectangle;", "invert", "", "constraints", "Lkotlin/Function2;", "Lorg/openrndr/binpack/PackNode;", "Lkotlin/ParameterName;", "name", "node", "rectangle", "xcon", "ycon", "(Lorg/openrndr/shape/IntRectangle;ZLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getConstraints", "()Lkotlin/jvm/functions/Function2;", "getEnclosement", "()Lorg/openrndr/shape/IntRectangle;", "getInvert", "()Z", "getXcon", "getYcon", "split", "", "openrndr-binpack"})
public final class CenteredBinarySplitter
implements Splitter {
    @NotNull
    private final IntRectangle enclosement;
    private final boolean invert;
    @NotNull
    private final Function2<PackNode, IntRectangle, Boolean> constraints;
    @NotNull
    private final Function2<PackNode, IntRectangle, Boolean> xcon;
    @NotNull
    private final Function2<PackNode, IntRectangle, Boolean> ycon;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<PackNode> split(@NotNull PackNode node, @NotNull IntRectangle rectangle) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(rectangle, "rectangle");
        if (!this.constraints.invoke(node, rectangle).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        int dw = node.getArea().getWidth() - rectangle.getWidth();
        int dh = node.getArea().getHeight() - rectangle.getHeight();
        float s2 = this.invert ? 1 : -1;
        IntRectangle lrect = null;
        IntRectangle rrect = null;
        if (dw > dh) {
            if (!this.xcon.invoke(node, rectangle).booleanValue()) return CollectionsKt.emptyList();
            if (s2 * (float)(node.getArea().getX() - this.enclosement.getX()) > s2 * (float)this.enclosement.getWidth() / (float)2) {
                lrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), rectangle.getWidth(), node.getArea().getHeight());
                rrect = new IntRectangle(node.getArea().getX() + rectangle.getWidth(), node.getArea().getY(), node.getArea().getWidth() - rectangle.getWidth(), node.getArea().getHeight());
                return CollectionsKt.listOf(new PackNode(lrect, node), new PackNode(rrect, node));
            } else {
                int ew = node.getArea().getWidth() - rectangle.getWidth();
                rrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), ew, node.getArea().getHeight());
                lrect = new IntRectangle(node.getArea().getX() + ew, node.getArea().getY(), rectangle.getWidth(), node.getArea().getHeight());
            }
            return CollectionsKt.listOf(new PackNode(lrect, node), new PackNode(rrect, node));
        } else {
            if (!this.ycon.invoke(node, rectangle).booleanValue()) return CollectionsKt.emptyList();
            if (s2 * (float)(node.getArea().getY() - this.enclosement.getY()) > s2 * (float)this.enclosement.getHeight() / (float)2) {
                lrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), node.getArea().getWidth(), rectangle.getHeight());
                rrect = new IntRectangle(node.getArea().getX(), node.getArea().getY() + rectangle.getHeight(), node.getArea().getWidth(), node.getArea().getHeight() - rectangle.getHeight());
                return CollectionsKt.listOf(new PackNode(lrect, node), new PackNode(rrect, node));
            } else {
                int eh = node.getArea().getHeight() - rectangle.getHeight();
                rrect = new IntRectangle(node.getArea().getX(), node.getArea().getY(), node.getArea().getWidth(), eh);
                lrect = new IntRectangle(node.getArea().getX(), node.getArea().getY() + eh, node.getArea().getWidth(), rectangle.getHeight());
            }
        }
        return CollectionsKt.listOf(new PackNode(lrect, node), new PackNode(rrect, node));
    }

    @NotNull
    public final IntRectangle getEnclosement() {
        return this.enclosement;
    }

    public final boolean getInvert() {
        return this.invert;
    }

    @NotNull
    public final Function2<PackNode, IntRectangle, Boolean> getConstraints() {
        return this.constraints;
    }

    @NotNull
    public final Function2<PackNode, IntRectangle, Boolean> getXcon() {
        return this.xcon;
    }

    @NotNull
    public final Function2<PackNode, IntRectangle, Boolean> getYcon() {
        return this.ycon;
    }

    public CenteredBinarySplitter(@NotNull IntRectangle enclosement, boolean invert2, @NotNull Function2<? super PackNode, ? super IntRectangle, Boolean> constraints, @NotNull Function2<? super PackNode, ? super IntRectangle, Boolean> xcon, @NotNull Function2<? super PackNode, ? super IntRectangle, Boolean> ycon) {
        Intrinsics.checkParameterIsNotNull(enclosement, "enclosement");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        Intrinsics.checkParameterIsNotNull(xcon, "xcon");
        Intrinsics.checkParameterIsNotNull(ycon, "ycon");
        this.enclosement = enclosement;
        this.invert = invert2;
        this.constraints = constraints;
        this.xcon = xcon;
        this.ycon = ycon;
    }

    public /* synthetic */ CenteredBinarySplitter(IntRectangle intRectangle, boolean bl, Function2 function2, Function2 function22, Function2 function23, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function22 = 2.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function23 = 3.INSTANCE;
        }
        this(intRectangle, bl, function2, function22, function23);
    }
}

