/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dnky;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"ltcShaders", "", "getLtcShaders", "()Ljava/lang/String;", "dnky"})
public final class LTCKt {
    @NotNull
    private static final String ltcShaders = "\n\nstruct LTC_Rect {\n    vec3  center;\n    vec3  dirx;\n    vec3  diry;\n    float halfx;\n    float halfy;\n    vec4  plane;\n};\n\nvoid LTC_initRect(out LTC_Rect rect, vec3 position, vec3 right, vec3 up, vec3 dir, vec2 size) {\n    rect.dirx = right;\n    rect.diry = up;\n\n    rect.center = position;\n    rect.halfx  = size.x;\n    rect.halfy  = size.y;\n\n    vec3 rectNormal = dir;\n    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));\n}\n\nvoid LTC_initRectPoints(LTC_Rect rect, out vec3 points[4])\n{\n    vec3 ex = rect.halfx*rect.dirx;\n    vec3 ey = rect.halfy*rect.diry;\n\n    points[0] = rect.center - ex - ey;\n    points[1] = rect.center + ex - ey;\n    points[2] = rect.center + ex + ey;\n    points[3] = rect.center - ex + ey;\n}\n\n\nfloat LTC_integrateEdge(vec3 v1, vec3 v2) {\n    float cosTheta = dot(v1, v2);\n    float theta = acos(cosTheta);\n    float res = cross(v1, v2).z * ((theta > 0.001) ? theta/sin(theta) : 1.0);\n\n    return res;\n}\n\nvoid LTC_clipQuadToHorizon(inout vec3 L[5], out int n)\n{\n    // detect clipping config\n    int config = 0;\n    if (L[0].z > 0.0) config += 1;\n    if (L[1].z > 0.0) config += 2;\n    if (L[2].z > 0.0) config += 4;\n    if (L[3].z > 0.0) config += 8;\n\n    // clip\n    n = 0;\n\n    if (config == 0)\n    {\n        // clip all\n    }\n    else if (config == 1) // V1 clip V2 V3 V4\n    {\n        n = 3;\n        L[1] = -L[1].z * L[0] + L[0].z * L[1];\n        L[2] = -L[3].z * L[0] + L[0].z * L[3];\n    }\n    else if (config == 2) // V2 clip V1 V3 V4\n    {\n        n = 3;\n        L[0] = -L[0].z * L[1] + L[1].z * L[0];\n        L[2] = -L[2].z * L[1] + L[1].z * L[2];\n    }\n    else if (config == 3) // V1 V2 clip V3 V4\n    {\n        n = 4;\n        L[2] = -L[2].z * L[1] + L[1].z * L[2];\n        L[3] = -L[3].z * L[0] + L[0].z * L[3];\n    }\n    else if (config == 4) // V3 clip V1 V2 V4\n    {\n        n = 3;\n        L[0] = -L[3].z * L[2] + L[2].z * L[3];\n        L[1] = -L[1].z * L[2] + L[2].z * L[1];\n    }\n    else if (config == 5) // V1 V3 clip V2 V4) impossible\n    {\n        n = 0;\n    }\n    else if (config == 6) // V2 V3 clip V1 V4\n    {\n        n = 4;\n        L[0] = -L[0].z * L[1] + L[1].z * L[0];\n        L[3] = -L[3].z * L[2] + L[2].z * L[3];\n    }\n    else if (config == 7) // V1 V2 V3 clip V4\n    {\n        n = 5;\n        L[4] = -L[3].z * L[0] + L[0].z * L[3];\n        L[3] = -L[3].z * L[2] + L[2].z * L[3];\n    }\n    else if (config == 8) // V4 clip V1 V2 V3\n    {\n        n = 3;\n        L[0] = -L[0].z * L[3] + L[3].z * L[0];\n        L[1] = -L[2].z * L[3] + L[3].z * L[2];\n        L[2] =  L[3];\n    }\n    else if (config == 9) // V1 V4 clip V2 V3\n    {\n        n = 4;\n        L[1] = -L[1].z * L[0] + L[0].z * L[1];\n        L[2] = -L[2].z * L[3] + L[3].z * L[2];\n    }\n    else if (config == 10) // V2 V4 clip V1 V3) impossible\n    {\n        n = 0;\n    }\n    else if (config == 11) // V1 V2 V4 clip V3\n    {\n        n = 5;\n        L[4] = L[3];\n        L[3] = -L[2].z * L[3] + L[3].z * L[2];\n        L[2] = -L[2].z * L[1] + L[1].z * L[2];\n    }\n    else if (config == 12) // V3 V4 clip V1 V2\n    {\n        n = 4;\n        L[1] = -L[1].z * L[2] + L[2].z * L[1];\n        L[0] = -L[0].z * L[3] + L[3].z * L[0];\n    }\n    else if (config == 13) // V1 V3 V4 clip V2\n    {\n        n = 5;\n        L[4] = L[3];\n        L[3] = L[2];\n        L[2] = -L[1].z * L[2] + L[2].z * L[1];\n        L[1] = -L[1].z * L[0] + L[0].z * L[1];\n    }\n    else if (config == 14) // V2 V3 V4 clip V1\n    {\n        n = 5;\n        L[4] = -L[0].z * L[3] + L[3].z * L[0];\n        L[0] = -L[0].z * L[1] + L[1].z * L[0];\n    }\n    else if (config == 15) // V1 V2 V3 V4\n    {\n        n = 4;\n    }\n\n    if (n == 3)\n        L[3] = L[0];\n    if (n == 4)\n        L[4] = L[0];\n}\n\nvec3 LTC_Evaluate(\n    vec3 N, vec3 V, vec3 P, mat3 Minv, vec3 points[4], bool twoSided)\n{\n    // construct orthonormal basis around N\n    vec3 T1, T2;\n    T1 = normalize(V - N*dot(V, N));\n    T2 = cross(N, T1);\n\n    // rotate area light in (T1, T2, N) basis\n    //Minv = mul(Minv, transpose(mat3(T1, T2, N)));\n    Minv = Minv * transpose(mat3(T1, T2, N));\n\n    // polygon (allocate 5 vertices for clipping)\n    vec3 L[5];\n    L[0] = Minv * (points[0] - P);\n    L[1] = Minv * (points[1] - P);\n    L[2] = Minv * (points[2] - P);\n    L[3] = Minv * (points[3] - P);\n\n    int n;\n    LTC_clipQuadToHorizon(L, n);\n\n    if (n == 0)\n        return vec3(0, 0, 0);\n\n    // project onto sphere\n    L[0] = normalize(L[0]);\n    L[1] = normalize(L[1]);\n    L[2] = normalize(L[2]);\n    L[3] = normalize(L[3]);\n    L[4] = normalize(L[4]);\n\n    // integrate\n    float sum = 0.0;\n\n    sum += LTC_integrateEdge(L[0], L[1]);\n    sum += LTC_integrateEdge(L[1], L[2]);\n    sum += LTC_integrateEdge(L[2], L[3]);\n    if (n >= 4)\n        sum += LTC_integrateEdge(L[3], L[4]);\n    if (n == 5)\n        sum += LTC_integrateEdge(L[4], L[0]);\n\n    sum = twoSided ? abs(sum) : max(0.0, sum);\n\n    vec3 Lo_i = vec3(sum, sum, sum);\n\n    return Lo_i;\n}\n\n\n";

    @NotNull
    public static final String getLtcShaders() {
        return ltcShaders;
    }

    static {
        ltcShaders = ltcShaders;
    }
}

