/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL15;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.Configuration;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000202H\u0016J\b\u00104\u001a\u000202H\u0016J\b\u00105\u001a\u000202H\u0016J\b\u00106\u001a\u000202H\u0016R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u001d8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u0011\"\u0004\b-\u0010\u0013R$\u0010.\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u000b\"\u0004\b0\u0010\r\u00a8\u00067"}, d2={"Lorg/openrndr/internal/gl3/ApplicationEGLGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "value", "", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "Lorg/openrndr/math/Vector2;", "cursorPosition", "getCursorPosition", "()Lorg/openrndr/math/Vector2;", "setCursorPosition", "(Lorg/openrndr/math/Vector2;)V", "cursorVisible", "", "getCursorVisible", "()Z", "setCursorVisible", "(Z)V", "driver", "Lorg/openrndr/internal/gl3/DriverGL3;", "exitRequested", "Lorg/openrndr/PresentationMode;", "presentationMode", "getPresentationMode", "()Lorg/openrndr/PresentationMode;", "setPresentationMode", "(Lorg/openrndr/PresentationMode;)V", "seconds", "", "getSeconds", "()D", "startTime", "", "vaos", "", "windowPosition", "getWindowPosition", "setWindowPosition", "windowTitle", "getWindowTitle", "setWindowTitle", "exit", "", "loop", "requestDraw", "requestFocus", "setup", "openrndr-gl3"})
public final class ApplicationEGLGL3
extends Application {
    private boolean cursorVisible;
    private DriverGL3 driver;
    private boolean exitRequested;
    private long startTime;
    private final int[] vaos;
    private final Program program;
    private final Configuration configuration;

    @Override
    public boolean getCursorVisible() {
        return this.cursorVisible;
    }

    @Override
    public void setCursorVisible(boolean bl) {
        this.cursorVisible = bl;
    }

    @Override
    @NotNull
    public Vector2 getCursorPosition() {
        return new Vector2(0.0, 0.0);
    }

    @Override
    public void setCursorPosition(@NotNull Vector2 value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
    }

    @Override
    public void requestDraw() {
        String string = "not implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup() {
        long display = EGL15.eglGetDisplay(0L);
        String string = "display " + display;
        boolean bl = false;
        System.out.println((Object)string);
        IntBuffer major = BufferUtils.createIntBuffer(1);
        IntBuffer minor = BufferUtils.createIntBuffer(1);
        EGL15.eglInitialize(display, major, minor);
        Object object = "EGL version " + major.get(0) + '.' + minor.get(0);
        boolean bl2 = false;
        System.out.println(object);
        object = MemoryStack.stackPush();
        bl2 = false;
        Throwable throwable = null;
        try {
            MemoryStack it = (MemoryStack)object;
            boolean bl3 = false;
            IntBuffer configCount = it.mallocInt(1);
            IntBuffer attributes = it.ints(12339, 1, 12322, 8, 12323, 8, 12324, 8, 12325, 24, 12326, 8, 12352, 8, 12344);
            if (!EGL15.eglChooseConfig(display, attributes, null, configCount)) {
                throw (Throwable)new RuntimeException(String.valueOf(EGL15.eglGetError()));
            }
            String string2 = "number of configs found : " + configCount.get(0);
            boolean bl4 = false;
            System.out.println((Object)string2);
            PointerBuffer configs = it.mallocPointer(configCount.get(0));
            EGL15.eglChooseConfig(display, attributes, configs, configCount);
            long surface = EGL15.eglCreatePbufferSurface(display, configs.get(0), attributes);
            EGL15.eglBindAPI(12450);
            int EGL_CONTEXT_FLAGS = 12540;
            IntBuffer contextAttributes = it.ints(12440, 3, 12539, 3, EGL_CONTEXT_FLAGS, 1, 12344);
            long context = EGL15.eglCreateContext(display, configs.get(0), 0L, contextAttributes);
            String string3 = "context: " + context;
            boolean bl5 = false;
            System.out.println((Object)string3);
            string3 = "client api " + EGL15.eglQueryString(display, 12429);
            bl5 = false;
            System.out.println((Object)string3);
            EGL15.eglMakeCurrent(display, surface, surface, context);
            GL.createCapabilities();
            string3 = String.valueOf(GL33C.glGetString(7936));
            bl5 = false;
            System.out.println((Object)string3);
            string3 = "opengl version: " + GL33C.glGetString(7938);
            bl5 = false;
            System.out.println((Object)string3);
            GL33C.glGenVertexArrays(this.vaos);
            GL33C.glBindVertexArray(this.vaos[0]);
            this.startTime = System.currentTimeMillis();
            ProgramRenderTargetGL3 defaultRenderTarget = new ProgramRenderTargetGL3(this.program);
            defaultRenderTarget.bind();
            this.program.setDrawer(new Drawer(this.driver));
            this.program.setup();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
        }
    }

    @Override
    public void loop() {
        while (!this.exitRequested) {
            GL33C.glBindVertexArray(this.vaos[0]);
            this.program.getDrawer().reset();
            this.program.getDrawer().ortho();
            this.program.draw();
        }
    }

    @Override
    @Nullable
    public String getClipboardContents() {
        return "";
    }

    @Override
    public void setClipboardContents(@Nullable String value2) {
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return "";
    }

    @Override
    public void setWindowTitle(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
    }

    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        return Vector2.Companion.getZERO();
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
    }

    @Override
    public double getSeconds() {
        return (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
    }

    @Override
    @NotNull
    public PresentationMode getPresentationMode() {
        return PresentationMode.AUTOMATIC;
    }

    @Override
    public void setPresentationMode(@NotNull PresentationMode value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, "value");
    }

    public ApplicationEGLGL3(@NotNull Program program2, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull(program2, "program");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.program = program2;
        this.configuration = configuration;
        this.startTime = System.currentTimeMillis();
        this.vaos = new int[1];
        this.driver = new DriverGL3();
        Driver.Companion.setDriver(this.driver);
    }
}

