/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u00132\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ0\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSampler;", "", "()V", "angleTolerance", "", "cuspLimit", "direction", "", "Lorg/openrndr/math/Vector2;", "distanceTolerance", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "distanceToleranceSquare", "points", "recursionLimit", "", "sample", "Lkotlin/Pair;", "", "x1", "x2", "x3", "x4", "", "level", "Companion", "openrndr-shape"})
public final class BezierCubicSampler {
    private final int recursionLimit = 8;
    private final List<Vector2> points;
    private final List<Vector2> direction;
    private double distanceToleranceSquare;
    private final double angleTolerance = 0.0;
    private final double cuspLimit = 0.0;
    private double distanceTolerance;
    private static final double colinearityEpsilon = 1.0E-30;
    private static final double angleToleranceEpsilon = 0.01;
    public static final Companion Companion = new Companion(null);

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final Pair<List<Vector2>, List<Vector2>> sample(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3, @NotNull Vector2 x4) {
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        Intrinsics.checkParameterIsNotNull(x2, "x2");
        Intrinsics.checkParameterIsNotNull(x3, "x3");
        Intrinsics.checkParameterIsNotNull(x4, "x4");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.direction.clear();
        this.points.add(x1);
        this.direction.add(x2.minus(x1));
        this.sample(x1, x2, x3, x4, 0);
        this.points.add(x4);
        this.direction.add(x4.minus(x3));
        return new Pair<List<Vector2>, List<Vector2>>(this.points, this.direction);
    }

    private final void sample(Vector2 x1, Vector2 x2, Vector2 x3, Vector2 x4, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Vector2 x12 = x1.plus(x2).times(0.5);
        Vector2 x23 = x2.plus(x3).times(0.5);
        Vector2 x34 = x3.plus(x4).times(0.5);
        Vector2 x123 = x12.plus(x23).times(0.5);
        Vector2 x234 = x23.plus(x34).times(0.5);
        Vector2 x1234 = x123.plus(x234).times(0.5);
        double dx = x4.getX() - x1.getX();
        double dy = x4.getY() - x1.getY();
        double d2 = Math.abs((x2.getX() - x4.getX()) * dy - (x2.getY() - x4.getY()) * dx);
        double d3 = Math.abs((x3.getX() - x4.getX()) * dy - (x3.getY() - x4.getY()) * dx);
        boolean p1 = d2 > colinearityEpsilon;
        boolean p0 = d3 > colinearityEpsilon;
        int p = (p1 ? 2 : 0) + (p0 ? 1 : 0);
        double k = 0.0;
        double da1 = 0.0;
        double da2 = 0.0;
        switch (p) {
            case 0: {
                k = dx * dx + dy * dy;
                if (k == 0.0) {
                    d2 = BezierCubicSampler.Companion.squareDistance(x1.getX(), x1.getY(), x2.getX(), x2.getY());
                    d3 = BezierCubicSampler.Companion.squareDistance(x4.getX(), x4.getY(), x3.getX(), x3.getY());
                } else {
                    k = 1.0 / k;
                    da1 = x2.getX() - x1.getX();
                    da2 = x2.getY() - x1.getY();
                    d2 = k * (da1 * dx + da2 * dy);
                    da1 = x3.getX() - x1.getX();
                    da2 = x3.getY() - x1.getY();
                    d3 = k * (da1 * dx + da2 * dy);
                    if (d2 > 0.0 && d2 < 1.0 && d3 > 0.0 && d3 < 1.0) {
                        return;
                    }
                    d2 = d2 <= 0.0 ? BezierCubicSampler.Companion.squareDistance(x2.getX(), x2.getY(), x1.getX(), x1.getY()) : (d2 >= 1.0 ? BezierCubicSampler.Companion.squareDistance(x2.getX(), x2.getY(), x4.getX(), x4.getY()) : BezierCubicSampler.Companion.squareDistance(x2.getX(), x2.getY(), x1.getX() + d2 * dx, x1.getY() + d2 * dy));
                    double d = d3 <= 0.0 ? BezierCubicSampler.Companion.squareDistance(x3.getX(), x3.getY(), x1.getX(), x1.getY()) : (d3 = d3 >= 1.0 ? BezierCubicSampler.Companion.squareDistance(x3.getX(), x3.getY(), x4.getX(), x4.getY()) : BezierCubicSampler.Companion.squareDistance(x3.getX(), x3.getY(), x1.getX() + d3 * dx, x1.getY() + d3 * dy));
                }
                if (d2 > d3) {
                    if (!(d2 < this.distanceToleranceSquare)) break;
                    this.points.add(new Vector2(x2.getX(), x2.getY()));
                    this.direction.add(x4.minus(x1));
                    return;
                }
                if (!(d3 < this.distanceToleranceSquare)) break;
                this.points.add(new Vector2(x3.getX(), x3.getY()));
                this.direction.add(x4.minus(x1));
                return;
            }
            case 1: {
                if (!(d3 * d3 <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < angleToleranceEpsilon) {
                    this.points.add(x23);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                da1 = Math.abs(Math.atan2(x4.getY() - x3.getY(), x4.getX() - x3.getX()) - Math.atan2(x3.getY() - x2.getY(), x3.getX() - x2.getX()));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    this.points.add(x2);
                    this.direction.add(x4.minus(x1));
                    this.points.add(x3);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                this.points.add(x3);
                this.direction.add(x4.minus(x1));
                return;
            }
            case 2: {
                if (!(d2 * d2 <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < angleToleranceEpsilon) {
                    this.points.add(x23);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                da1 = Math.abs(Math.atan2(x3.getY() - x2.getY(), x3.getX() - x2.getX()) - Math.atan2(x2.getY() - x1.getY(), x2.getX() - x1.getX()));
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    this.points.add(x2);
                    this.direction.add(x4.minus(x1));
                    this.points.add(x3);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                this.points.add(x2);
                this.direction.add(x4.minus(x1));
                return;
            }
            case 3: {
                if (!((d2 + d3) * (d2 + d3) <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < angleToleranceEpsilon) {
                    this.points.add(x23);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                k = Math.atan2(x3.getY() - x2.getY(), x3.getX() - x2.getX());
                da1 = Math.abs(k - Math.atan2(x2.getY() - x1.getY(), x2.getX() - x1.getX()));
                da2 = Math.abs(Math.atan2(x4.getY() - x3.getY(), x4.getX() - x3.getX()) - k);
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da2 >= Math.PI) {
                    da2 = Math.PI * 2 - da2;
                }
                if (da1 + da2 < this.angleTolerance) {
                    this.points.add(x23);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                if (this.cuspLimit == 0.0) break;
                if (da1 > this.cuspLimit) {
                    this.points.add(x2);
                    this.direction.add(x4.minus(x1));
                    return;
                }
                if (!(da2 > this.cuspLimit)) break;
                this.points.add(x3);
                this.direction.add(x4.minus(x1));
                return;
            }
        }
        this.sample(x1, x12, x123, x1234, level + 1);
        this.sample(x1234, x234, x34, x4, level + 1);
    }

    public BezierCubicSampler() {
        List list;
        BezierCubicSampler bezierCubicSampler = this;
        boolean bl = false;
        bezierCubicSampler.points = list = (List)new ArrayList();
        bezierCubicSampler = this;
        bl = false;
        bezierCubicSampler.direction = list = (List)new ArrayList();
        this.distanceTolerance = 0.5;
    }

    static {
        colinearityEpsilon = 1.0E-30;
        angleToleranceEpsilon = 0.01;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSampler$Companion;", "", "()V", "angleToleranceEpsilon", "", "colinearityEpsilon", "squareDistance", "x", "y", "x1", "y1", "openrndr-shape"})
    public static final class Companion {
        private final double squareDistance(double x, double y, double x1, double y1) {
            double dx = x1 - x;
            double dy = y1 - y;
            return dx * dx + dy * dy;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

