/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.shape.Composition;
import org.openrndr.svg.SVGDocument;
import org.openrndr.svg.SVGLoader;
import org.openrndr.svg.SVGLoaderKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a8\u0006\u000b"}, d2={"expandToTwoDigitsPerComponent", "", "hexValue", "loadSVG", "Lorg/openrndr/shape/Composition;", "svgString", "normalizeColorHex", "colorHex", "parseColor", "Lorg/openrndr/color/ColorRGBa;", "scolor", "openrndr-svg"})
public final class SVGLoaderKt {
    @NotNull
    public static final Composition loadSVG(@NotNull String svgString) {
        Intrinsics.checkParameterIsNotNull(svgString, "svgString");
        SVGDocument doc = new SVGLoader().loadSVG(svgString);
        return doc.composition();
    }

    @Nullable
    public static final ColorRGBa parseColor(@NotNull String scolor) {
        ColorRGBa colorRGBa;
        Intrinsics.checkParameterIsNotNull(scolor, "scolor");
        CharSequence charSequence = scolor;
        boolean bl = false;
        if (charSequence.length() == 0 || Intrinsics.areEqual(scolor, "none")) {
            colorRGBa = null;
        } else if (StringsKt.startsWith$default(scolor, "#", false, 2, null)) {
            String normalizedColor = SVGLoaderKt.normalizeColorHex(scolor);
            Long v = Long.decode(normalizedColor);
            int vi = (int)v.longValue();
            int r = vi >> 16 & 0xFF;
            int g = vi >> 8 & 0xFF;
            int b = vi & 0xFF;
            colorRGBa = new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0, null, 16, null);
        } else if (Intrinsics.areEqual(scolor, "white")) {
            colorRGBa = ColorRGBa.Companion.getWHITE();
        } else if (Intrinsics.areEqual(scolor, "silver")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xC0C0C0);
        } else if (Intrinsics.areEqual(scolor, "gray")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x808080);
        } else if (Intrinsics.areEqual(scolor, "black")) {
            colorRGBa = ColorRGBa.Companion.getBLACK();
        } else if (Intrinsics.areEqual(scolor, "red")) {
            colorRGBa = ColorRGBa.Companion.getRED();
        } else if (Intrinsics.areEqual(scolor, "maroon")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x800000);
        } else if (Intrinsics.areEqual(scolor, "yellow")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xFFFF00);
        } else if (Intrinsics.areEqual(scolor, "olive")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x808000);
        } else if (Intrinsics.areEqual(scolor, "lime")) {
            colorRGBa = ColorRGBa.Companion.fromHex(65280);
        } else if (Intrinsics.areEqual(scolor, "green")) {
            colorRGBa = ColorRGBa.Companion.fromHex(32768);
        } else if (Intrinsics.areEqual(scolor, "aqua")) {
            colorRGBa = ColorRGBa.Companion.fromHex(65535);
        } else if (Intrinsics.areEqual(scolor, "teal")) {
            colorRGBa = ColorRGBa.Companion.fromHex(32896);
        } else if (Intrinsics.areEqual(scolor, "blue")) {
            colorRGBa = ColorRGBa.Companion.fromHex(255);
        } else if (Intrinsics.areEqual(scolor, "navy")) {
            colorRGBa = ColorRGBa.Companion.fromHex(128);
        } else if (Intrinsics.areEqual(scolor, "fuchsia")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0xFF00FF);
        } else if (Intrinsics.areEqual(scolor, "purple")) {
            colorRGBa = ColorRGBa.Companion.fromHex(0x800080);
        } else if (Intrinsics.areEqual(scolor, "orange")) {
            colorRGBa = ColorRGBa.Companion.fromHex(16753920);
        } else {
            throw (Throwable)new RuntimeException("could not parse color: " + scolor);
        }
        return colorRGBa;
    }

    @NotNull
    public static final String normalizeColorHex(@NotNull String colorHex) {
        String string;
        Intrinsics.checkParameterIsNotNull(colorHex, "colorHex");
        String string2 = "#?([0-9a-f]{3,6})";
        RegexOption regexOption = RegexOption.IGNORE_CASE;
        boolean bl = false;
        Regex colorHexRegex = new Regex(string2, regexOption);
        MatchResult matchResult = colorHexRegex.matchEntire(colorHex);
        if (matchResult == null) {
            throw (Throwable)new RuntimeException("The provided colorHex '" + colorHex + "' is not a valid color hex for the SVG spec");
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        if (matchGroup == null) {
            Intrinsics.throwNpe();
        }
        String string3 = matchGroup.getValue();
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).toLowerCase()");
        String hexValue = string5;
        switch (hexValue.length()) {
            case 3: {
                string = SVGLoaderKt.expandToTwoDigitsPerComponent('f' + hexValue);
                break;
            }
            case 6: {
                string = hexValue;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("The provided colorHex '" + colorHex + "' is not in a supported format");
            }
        }
        String normalizedArgb = string;
        return '#' + normalizedArgb;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String expandToTwoDigitsPerComponent(@NotNull String hexValue) {
        Intrinsics.checkParameterIsNotNull(hexValue, "hexValue");
        Sequence $this$reduce$iv = SequencesKt.map(StringsKt.asSequence(hexValue), expandToTwoDigitsPerComponent.1.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void component;
            String string = (String)iterator$iv.next();
            String accumulatedHex = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = accumulatedHex + (String)component;
        }
        return (String)accumulator$iv;
    }
}

