; Penrose - 256 byte intro by TomCat/Abaddon
; entry for the 1st Revision tiny intro compo

; triangle parameters
SIZE EQU 1536
; tunnel parameters
STEPS EQU 8
PERSP EQU 2560
COLORS EQU 128

ORG 256
 DW     127             ; constant 127 -> amplitude for sinus table
 DW     3C00H           ; constant 1/128 -> calculating PI/128 for sinus table

 MOV    AL,13H          ; set video mode 320x200
@@:
 INT    10H             ; call VGA Bios
 IMUL   DX,BX,7FH
 IMUL   CX,BX,3FH
 IMUL   AX,BX,30H
 MOV    CL,AH           ; DH/CH/CL->R/G/B
 INC    BX              ; loop more than enough
 MOV    AX,1010H        ; set only one color by the VGA BIOS
 JNO    @B              ; CL = 255

 MOV    BH,2
@@:
 FLDPI                  ; PI
 FMUL   DWORD [SI]      ; PI/128
 FIMUL  WORD [DI]       ; counter*PI/128
 FSIN                   ; SIN(counter*PI/128)
 FIMUL  WORD [SI]       ; 127*SIN(counter*PI/128)
 FISTP  WORD [BX+SI]    ; -
 INC    BX
 DEC    BYTE [DI]       ; loop 256x
 JNZ    @B              ; BX = sinus table

 MOV    BP,320
 CLD                    ; spare byte
 MOV    SI,0A000H       ; segment of video memory
 MOV    ES,SI           ; writing temp data to addr 100H@SI could be slow
main:
 HLT                    ; wait for timing (cheaper than 46CH BIOS var)
 DEC    BL              ; BL = my own timer counter, BX = angle
.2:
 CWD
 MOV    AX,DI
 DIV    BP              ; DL = sX = 0..255, DH = sY = 0..199
 ADD    DX,-160;28         ; 160 would be the center
 SUB    AL,112
 XCHG   CX,AX
 MOV    CH,STEPS-1
 PUSHA

 AND    CH,BL           ; CH = tunnel color
 ADD    CH,COLORS-STEPS-1
 MOV    [SI],CH

.3:
 MOV    AX,PERSP
 DIV    CH
 SUB    CH,STEPS

 PUSH   AX              ; clip floor
 SHR    AL,1            ; at half of radius
 CMP    AL,CL
 POP    AX
 JLE    .4

 PUSH   AX

 MOV    AL,CL           ; screen coord Y
 IMUL   AL              ; dY*dY
 XCHG   BP,AX

 MOV    AL,[BX]
 IMUL   CH              ; cX = radius * SIN(angle)
 SAR    AX,7
 ADD    AX,DX           ; dX = sX-cX
 IMUL   AX,AX
 ADD    BP,AX

 POP    AX

 MUL    AL              ; R*R
 CMP    BP,AX
 JC     .5              ; dX*dX+dY*dY < R*R

.4:
 MOV    [SI],CH         ; pixel = tunnel color

.5:
 CMP    CH,PERSP/255    ; was the smallest radius?
 JG     .3


 CALL   penrose
.6:
 MOVSB
 POPA
 INC    DI
 JNZ    .2

 CMP    [BP-320+penrose.0+2],CH ; SIZE*4/3/256-1
 JE     @F              ; if center position is reached then end of transition
 ADD    [BP-320+penrose.0+2],BH ; move the bars in the direction of center
@@:

 IN     AL,60H          ; check for keypress
 DAS                    ; if not pressed
 JC     main            ; then go to next frame

penrose:                ; BX:angle, DL:dX, DH:dY, CL:128, CH:7
 XOR    DH,DL
 JS     .6
 MOV    AX,211

 ADD    AL,CL           ; if we are at 45 lines lower than the center
 JNG    @F
 IMUL   BP,AX,-640      ; then check the backbuffer for triangle
 IMUL   BYTE [BX]       ; shift the shadow in x direction
 SAR    AX,6            ; in opposite of the light
 SUB    BP,AX
 CMP    BYTE [ES:DI+BP],128   ; if backbuffer pixel > 127
 JB     @F              ; if backbuffer pixel = triangle
 SHR    BYTE [SI],1     ; then decrase the intensity of the floor
@@:

 MOV    CH,120;124;120;124;85
 MOV    DH,SIZE*3/256
.1:                     ; CH = triangle color, CL = bar length
 PUSHA                  ; backup BX and CX, the angle and the color
 MOV    DI,-1*SIZE*13/6+97
.2:
.0:
 MOV    BP,05BA0H       ; BP = offset from the center (at start out of screen)
 PUSH   BX
.3:
 MOV    AL,[BX]
 IMUL   CL              ; SIN(angle)*dY
 ADD    BP,AX
 SUB    BL,64
 MOV    AL,[BX]
 IMUL   DL              ; SIN(angle-PI/2)*dX
 ADD    AX,BP
 JNS    @F
 NEG    AX              ; c = ABS(COS*dX+SIN*dY+offset)
@@:
 CMP    AH,DH           ; if c > length then here is no bar
 JAE    .4              ; else check the other two sides of bar
 ADD    BL,64+128+43    ; BL = rotation angle + PI/3 (deg 60)
 MOV    BP,DI           ; BP = other offset from the center
 CMP    DH,BH           ;
 MOV    DH,SIZE/2/256   ; CL = other length aka width of bar
 JNE    .3              ; if the pixel inside the bar go back

 INC    BYTE [SI]       ; then check have other bar found already?
 JS    .4               ; if yes then skip
 ADD    [SI],CH         ; add triangle color to background color
 STC                    ; make the triangle transparent
 RCR    BYTE [SI],1
.4:
 POP    BX              ; restore angle
 SUB    BL,42+128       ; angle = angle-PI/3
 MOV    DH,SIZE*2/256   ; length of the other bar
 XOR    DI,(-1*SIZE*7/6) XOR (-1*SIZE*13/6+97)
 JPE    .2              ; loop 2x, two bars with the same color

 POPA                   ; restore BX CX
 SUB    BL,85           ; angle = angle-2PI/3
 SUB    CH,30;41;62;41;30;41           ; decrasing colorindex of the bar
 JNC    .1              ; loop 3x

.6:
RETN                    ; return to DOS prompt

