#include "SimpleSceneBase.as"

//Lol since we don't do alpha, we can only fade to white.... mkay? :P

enum FadeMode {
    FM_ADDITIVE = 0,
    FM_ALPHA = 1,
}

class Fade : SimpleSceneBase
{
    private Object@ mObj;
    private Timer@ mTimer;
    private Color mColor;
    private pFloat mFactor = 0;
    private pFloat mFraction = 0;
    private pUInt mProgress; 
    private pUInt mTarget; 
    private bool mFadeIn = false;
    private FadeMode mMode = FM_ADDITIVE;

    Action@ onFadeEnd;


    Fade(Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir) {
        super(control, window, pool, resourcedir); 
        @mObj = GAME.objectFactory.createCube();
        mObj.setScale(window.width, 1, window.height);
        
        mObj.model.setDrawMode(DM_EMISSIVE);
        mObj.model.setMaterialType(MT_TRANSLUCENT);
        mObj.model.setColor(BLACK);
        @mTimer = GAME.control.createTimer(1, true);
        mTimer.elapsed += Action(this.fadeTick);
        		
        pFloat hW = window.width * 0.5;
    	pFloat hH = window.height * 0.5;

		@mCam = Camera(-hW, hW, hH, -hH, -100, 100);
        mViewport.addCamera(1, mCam);
        mViewport.disableClear();

        mScene.add(mCam);
        mScene.add(mObj);
    }

    void pause() {
        if (mProgress != 0) //yes, potential race condition. Highly unlikely, Don't care. 
            mTimer.pause();
    }

    void resume() {
        if (mProgress != 0) //yes, potential race condition. Highly unlikely, Don't care. 
            mTimer.start();
    }

    void cancel() {
        mTimer.stop();
        mProgress = 0;
    }

    
    void setMode(FadeMode mode) {
        mMode = mode;
        switch (mMode) {
            case FM_ADDITIVE: 
                mObj.model.setDrawMode(DM_ADDITIVE);
                mObj.model.setMaterialType(MT_OPAQUE);
                break;
            case FM_ALPHA:
                mObj.model.setDrawMode(DM_EMISSIVE);
                mObj.model.setMaterialType(MT_TRANSLUCENT);
                break;
        }
    }


    void fadeOut(Color color, FadeMode mode, pUInt ms) {
        
        setMode(mode);
        mColor = color;

        mFadeIn = false;
        mFactor = 0;
        mProgress = 0;
        mTarget = ms;
        mFraction = 1.0f / pFloat(mTarget);
        mTimer.start();
    }

    void fadeIn(Color color, FadeMode mode, pUInt ms) {
        setMode(mode);
        mColor = color;

        mFadeIn = true;
        mFactor = 1;
        mProgress = 0;
        mTarget = ms;
        mFraction = 1.0f / pFloat(mTarget);
        
        mTimer.start();
    }

    Color getColor(pFloat factor) {
        Color color;

        switch (mMode) {
            case FM_ADDITIVE:
                color = Color(mColor.r * factor, mColor.g * factor, mColor.b * factor,1) ;
                break;
            case FM_ALPHA:
                color = Color(mColor.r, mColor.g, mColor.b, factor);
                break;
        }

        return color;
    }

    private void fadeTick() 
    {
        ++mProgress;
        if (mFadeIn) {
            mFactor -= mFraction;
            if (mFactor < 0.0f) mFactor = 0.0f;
        } else {
            mFactor += mFraction;
        }

        mObj.model.setColor(getColor(mFactor));
        if (mProgress >= mTarget) {
            mTimer.stop();
            onFadeEnd();
        }
    }

    private void onWindowResize(Window@ w, pUInt width, pUInt height) {
		pFloat hW = w.width * 0.5;
    	pFloat hH = w.height * 0.5;

		Projection p(-hW, hW, hH, -hH, -100, 100);
        mViewport.width = w.width;
        mViewport.height = w.height;

        mObj.setScale(w.width, 1, w.height);
    	mCam.projection = p;
	}
	
	
}