
class FancyMenuButton: Button 
{
    Vector3 sizes = Vector3(375, 1,66);
    pFloat active = 1.1;
    pFloat pressed = 0.9; 

    weakref<Object> mObj;
    Label@ mLabel;

    FancyMenuButton(Scene@ scene, String text, String@ model  = "") {

        BitmapFont@ myFont = GAME.resourcePool.getBitmapFont(GAME.assetRoot + "Fonts/blightfont.fnt");
	    //Construct a label
	 	Label@ msg = Label(myFont, text);
        msg.applyScale(0.6);
    		
         Object@ obj;
        if (model == "" )
		    @obj = GAME.objectFactory.load(GAME.assetRoot + "/3D/Menu/Button.fbx");
        else
            @obj = GAME.objectFactory.load(model);

    	msg.setPosition(-msg.width * 0.5, -2, msg.height * 0.6);
		obj.combine(msg);

        scene.add(obj);
       

        @obj.userRef = this;
        @mObj = obj;
    }

    void enable() {
        auto object = mObj.get();
        if (object is null) return;

        object.model.visible = true;
        Button::enable();
    }

    void disable() {
        auto object = mObj.get();
        if (object is null) return;

        object.model.visible = false;
        Button::disable();
    }


    void set_position(Vector3 pos) {
        auto object = mObj.get();
        if (object is null) return;
        object.position = pos;
    }
    
    void hover() {
        //overload this to change the state of the button at the appropriate time
        auto object = mObj.get();
        if (object is null) return;
        object.applyScale(active);
        Button::hover();
    }

    void buttonDown() {
        auto object = mObj.get();
        if (object is null) return;
        Button::buttonDown();
        object.applyScale(pressed);
    }

    void buttonUp() {
        auto object = mObj.get();
        if (object is null) return;
      
        object.setScale(1);
        if (mActive)
            object.applyScale(active);
        Button::buttonUp(); 
    }

    void endHover() {
        auto object = mObj.get();
        if (object is null) return;
        object.setScale(1);
        Button::endHover();
    }
}
