#include "Gui.as"
#include "FancyMenuButton.as"

class GameMenu : SimpleSceneBase
{
    private GUI@ mGui;
    private FancyMenuButton@ mResumeButton;
    private FancyMenuButton@ mRestartButton;
    private FancyMenuButton@ mSettingsButton;
    private FancyMenuButton@ mBackToMainButton;
    private FancyMenuButton@ mQuitButton;
    private DirectionalLight@ mLight;
    

    private bool mEnabled = false;
    private bool mActive = false;

	
	GameMenu( Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir)
	{
        super(control, window, pool, resourcedir);

        pFloat hW = mWindow.width * 0.5;
        pFloat hH = mWindow.height * 0.5;

        @mCam = Camera(-hW, hW, hH, -hH, -100, 100);

		mScene.add(mCam);
  
		mViewport.addCamera(0, mCam);
        mViewport.disableClear();

        @mLight = DirectionalLight();
        mScene.add(mLight);

        @mGui = GUI(window, mScene);

      //  pUInt offset = 120;
        pInt pos = 200;

        @mResumeButton = FancyMenuButton(mScene, "Resume game");
        mResumeButton.position = Vector3(0,0,pos);
        @mResumeButton.onButtonUp = Action(this.resumeGame);
        pUInt offset = pUInt(mResumeButton.sizes.z) + 10;

        @mRestartButton = FancyMenuButton(mScene, "Restart level");
        mRestartButton.position = Vector3(0,0,pos -= offset);
        @mRestartButton.onButtonUp = Action(this.restartLevel);

        @mBackToMainButton = FancyMenuButton(mScene, "Back to main");
        mBackToMainButton.position = Vector3(0,0,pos -= offset);
        @mBackToMainButton.onButtonUp = Action(this.backToMain);

        @mQuitButton = FancyMenuButton(mScene,  "Quit");
        mQuitButton.position = Vector3(0,0,pos -= offset);
        @mQuitButton.onButtonUp = Action(this.Quit);

        mGui.addButton(1, mResumeButton);
        mGui.addButton(2, mRestartButton);
        //mGui.addButton(3, mSettingsButton);
        mGui.addButton(3, mBackToMainButton);
        mGui.addButton(4, mQuitButton);
    }

    void release() {
		if (@mScene == null) return;
        mScene.clear();
        @mScene = null;
    }



    ~GameMenu( ) {
    }

    void onKeyDown(pKeyCode) { if (mActive) Hide(); else Show();  }
	void controllerBtnDown(GameController@ controller, pControllerButton btn) { if (mActive) Hide(); else Show(); }

    
    private void onWindowResize(Window@ w, pUInt width, pUInt height) {
		pFloat hW = w.width * 0.5;
    	pFloat hH = w.height * 0.5;

		Projection p(-hW, hW, -hH, hH, -100, 100);
        mViewport.width = w.width;
        mViewport.height = w.height;
    	mCam.projection = p;
	}
	

    void enable() {
        if (mEnabled) return;
        mEnabled = true;
		mControl.Input.keyDown(PK_ESCAPE) +=  KeyStateCallback(this.onKeyDown);
		mControl.Input.controllerButtonDown(PCB_BUTTON_START) += ControllerButtonCallback(this.controllerBtnDown);
    }

    void disable() {
        if (!mEnabled) return;
        mEnabled = false;
		mControl.Input.keyDown(PK_ESCAPE) -=  KeyStateCallback(this.onKeyDown);
		mControl.Input.controllerButtonDown(PCB_BUTTON_START) -= ControllerButtonCallback(this.controllerBtnDown);
    }

    void resumeGame() {
        Hide();
    }

    void restartLevel() {
        GAME.restartLevel();
        Hide();
    }

    void backToMain() {
        GAME.ShowMenu();
        disable();
        Hide();
    }

    
    void Quit() {
        disable();
        Hide();
        GAME.quit();
    }
    	
	void Show() {
        mActive = true;
		SimpleSceneBase::Show();
        mGui.activate();
        GAME.pause();
	}
    
	void Hide() {
        mActive = false;
        mGui.deactivate();
		SimpleSceneBase::Hide();
        GAME.resume();
	}


}