#include "../SimpleSceneBase.as"
#include "../LevelInfo.as"
#include "MenuButton.as"


funcdef void StartLevelCB(pUInt i);

class LevelSelection : SimpleSceneBase
{

    pUInt mLevelCount = 0;
    pUInt mCompleted = 0;
    LevelInfo@ mLevelInfo;
    Object@ mBackground;
    private GUI@ mGui;

    FancyMenuButton@ mCancelButton;
    FancyMenuButton@ mStartButton;
    FancyMenuButton@ mNextButton;
    FancyMenuButton@ mPrevButton;

    Label@ mSelectedLevelLbl;
    Label@ mLockedLbl;


    StartLevelCB@ onStartLevel;
    Action@ onCancel;

    bool mActivated = false;
    pUInt mSelectedLevel = 1;

    LevelSelection(Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir, LevelInfo@ levelInfo)
    {
        super(control, window, pool, resourcedir);
        @mLevelInfo = levelInfo;

        @mGui = GUI(window, mScene);

        pFloat hW = mWindow.width * 0.5;
        pFloat hH = mWindow.height * 0.5;

        @mCam = Camera(-hW, hW, hH, -hH, -100, 100);

		mScene.add(mCam);

        mScene.add(DirectionalLight());
  
		mViewport.addCamera(0, mCam);
        mViewport.disableClear();

        pUInt menuwidth = 800;
        pUInt menuheight = 300;

        @mBackground = GAME.objectFactory.load(GAME.assetRoot + "3D/Menu/select_level_menu.FBX");
        mBackground.translate(0, 2, 0);
        mScene.add(mBackground);

        BitmapFont@ myFont = GAME.resourcePool.getBitmapFont(GAME.assetRoot + "Fonts/blightfont.fnt");

     
	    //Construct a label
        @mSelectedLevelLbl = Label(myFont, "");
        mSelectedLevelLbl.text = String(mSelectedLevel);
        mSelectedLevelLbl.translate(0,0,30);
        mScene.add(mSelectedLevelLbl);
        
        @mLockedLbl = Label(myFont, "Locked");
        mLockedLbl.translate(-mLockedLbl.width * 0.5 ,0, -50);
        mLockedLbl.model.visible = false;
        mScene.add(mLockedLbl);


        @mCancelButton = FancyMenuButton(mScene, "Cancel", GAME.assetRoot + "3D/Menu/button.FBX");
        @mCancelButton.onButtonUp = Action(this.cancel);
        mCancelButton.position = Vector3(-menuwidth * 0.5 + 200 ,0,-menuheight * 0.5 + 30);

        @mStartButton = FancyMenuButton(mScene, "Start", GAME.assetRoot + "3D/Menu/button.FBX");
        @mStartButton.onButtonUp = Action(this.startGame);
        mStartButton.position = Vector3(menuwidth * 0.5 - 200 ,0,-menuheight * 0.5 + 30);

        @mLockedLbl = Label(myFont, "Locked");
        mLockedLbl.translate(menuwidth * 0.5 - 260 ,0,-menuheight * 0.5 + 60);
        mLockedLbl.model.visible = false;
        mScene.add(mLockedLbl);


        @mNextButton = FancyMenuButton(mScene, "", GAME.assetRoot + "3D/Menu/arrow.FBX");
        @mNextButton.onButtonUp = Action(this.next);
        mNextButton.position = Vector3(menuwidth * 0.5 - 170 ,0,0);

        @mPrevButton = FancyMenuButton(mScene, "", GAME.assetRoot + "3D/Menu/arrow.FBX");
        mPrevButton.mObj.get().rotate(0,1,0,PI);
        @mPrevButton.onButtonUp = Action(this.prev);
        mPrevButton.position = Vector3(-menuwidth * 0.5 + 170 ,0,0);
       
        mGui.addButton(1, mStartButton);
        mGui.addButton(2, mNextButton);
        mGui.addButton(3, mPrevButton);
        mGui.addButton(4, mCancelButton);
    }

    void release() {
        mScene.clear();
        @mScene = null;
    }

    void onWindowResize(Window@ w, pUInt width, pUInt height) {
		pFloat hW = w.width * 0.5;
    	pFloat hH = w.height * 0.5;

		Projection p(-hW, hW, -hH, hH, -100, 100);
        mViewport.width = w.width;
        mViewport.height = w.height;
    	mCam.projection = p;
	}


    void Show() {
        if (mActivated) return;
        mActivated = true;

		SimpleSceneBase::Show();
        mGui.activate();
	}
    
	void Hide() {
        if (!mActivated) return;
        mActivated = false;

        mGui.deactivate();
		SimpleSceneBase::Hide();
	}

    void cancel() {
        if (onCancel !is null)
            onCancel();
        Hide();
    }

    void startGame() {
        if (onStartLevel !is null)
            onStartLevel(mSelectedLevel);
        Hide();
    }

    void next() {
        if (mSelectedLevel == mLevelInfo.levelcount) return;
        ++mSelectedLevel;
        if (mSelectedLevel > mLevelInfo.progress) {
            mLockedLbl.model.visible = true;
            mStartButton.disable();
        }
        mSelectedLevelLbl.text = String(mSelectedLevel);
    }

    void prev() {
        if (mSelectedLevel == 1) return;
        
        --mSelectedLevel;

        if (mSelectedLevel <= mLevelInfo.progress) {
            mLockedLbl.model.visible = false;
            mStartButton.enable();
        }

        mSelectedLevelLbl.text = String(mSelectedLevel);
    }

    


}
