
class SimpleSceneBase
{
	Scene@ mScene;
	Camera@ mCam;
	Control@ mControl;
	Window@ mWindow;
	Viewport@ mViewport;
	ResourcePool@ mPool;
	Panel@ mPanel;
	String@ mResourceDir;
	pUInt mViewportIdx = pUInt(-1);
	
	SimpleSceneBase( Control@ control, Window@ window, ResourcePool@ pool, String@ ResourceDir)
	{
		@mWindow = window;
		@mControl = control;
		@mPool = pool;
		@mResourceDir = ResourceDir;
		
		//Add a viewport to the window: (this one is just the entire window)
		@mViewport = Viewport(0, 0, mWindow.width, mWindow.height); 
		mViewport.enableClear(); //enable clear color (or don't, whatever suits your usecase best) Default is BLACK
	
		@mScene = Scene(Partition());
	}

	void Show() {
		mViewportIdx = mWindow.addViewport(mViewport);

		mControl.addScene(mScene);
	}

	void Hide() {
		if (mViewportIdx == pUInt(-1)) return; //premature hide

		echo ("Removing viewport! " + String(mViewportIdx));
		mWindow.removeViewport(mViewportIdx);
		mViewportIdx = -1;
		mControl.removeScene(mScene);
	}

	~SimpleSceneBase()
    {
		//Yes this duplicates from "Hide" but this allows "Hide" to be overwritten to use events and register/deregister handlers.
		//Doing that in the destructor can result in ref problems between Piko3D and Angelscript for some reason.
		if (mViewportIdx != pUInt(-1)) mWindow.removeViewport(mViewportIdx);
		mControl.removeScene(mScene);
    }
}