#include "SimpleSceneBase.as"

class StartupScreen : SimpleSceneBase
{
	private OpenALSource@ mMenuMusic;
	private Timer@ mMusicTimer;
	private pFloat mMusicElapsed = 0.0;
	
	Action@ StartCB;

	
	StartupScreen( Control@ control, Window@ window, ResourcePool@ pool, String@ resourcedir)
	{
		super(control, window, pool, resourcedir);
		
		//@mCam = Camera(0, mWindow.width, 0, -mWindow.height, -100, 100);
		@mCam = Camera(-1920 *0.5, 1920* 0.5, 1080* 0.5, -1080 * 0.5, 0, 10);
		mScene.add(mCam);
		mViewport.addCamera(0, mCam);
		mViewport.enableClear(Color(128,128,128,255)); //enable clear color (or don't, whatever suits your usecase best) Default is BLACK
		

		auto background = GAME.objectFactory.createPoster(GAME.assetRoot + "3D/Menu/startscreen.png");
    mScene.add(background);
		background.model.setDrawMode(DM_EMISSIVE);
    background.translate(0,10,0);


		//Get a font:
		BitmapFont@ myFont = pool.getBitmapFont(mResourceDir + "Fonts/blightfont.fnt");
		//Construct a label
		Label@ welcome = Label(myFont, "Press any key to start");

		welcome.translate(-welcome.width * 0.5, 0, -300);
		
		
		
		@mMusicTimer = GAME.control.createTimer(1000, true);
		mMusicTimer.elapsed += Action(this.musicTick);
		mMusicTimer.stop();
		
		mScene.add(welcome);
		
		@mMenuMusic = GAME.audio.createMenuSource();
	}
	
    private void musicTick() 
    {
        mMusicElapsed += 1.0;
		if (mMusicElapsed > 10.0) { // yes, hardcoded time, Dascon-PressKey.ogg takes 10 secs
			GAME.audio.playMainMenuMusic();
			mMenuMusic.loop = true;
			mMusicTimer.stop();
		}
	}	

	
	void Show() {
		SimpleSceneBase::Show();
		mControl.Input.keyDown(PK_ANY) +=  KeyStateCallback(this.onKeyDown);
		mControl.Input.controllerButtonDown(PCB_ANY) += ControllerButtonCallback(this.controllerBtnDown);
		mControl.Input.mouseButtonDown(PMB_ANY) += MouseButtonCallback(this.onMouseButtonDown);
		
		mMusicTimer.start();
		GAME.audio.stopLevelMusic();
		mMenuMusic.play(mPool.getSound(mResourceDir + "Music/Dascon-PressKey.ogg"));
	}

	void Hide() {
		SimpleSceneBase::Hide();
		mControl.Input.keyDown(PK_ANY) -= KeyStateCallback(this.onKeyDown);
		mControl.Input.controllerButtonDown(PCB_ANY) -= ControllerButtonCallback(this.controllerBtnDown);
		mControl.Input.mouseButtonDown(PMB_ANY) -= MouseButtonCallback(this.onMouseButtonDown);
		
		mMenuMusic.stop();
		mMusicTimer.stop();
		mMusicElapsed = 0.0;
		mMenuMusic.loop = false;
	}
	
	void onKeyDown(pKeyCode) { start(); }
	void controllerBtnDown(GameController@ controller, pControllerButton btn) {	start();}
	void onMouseButtonDown(pMouseButton, pInt x, pInt y) { start();}

	private void onWindowResize(Window@ w, pUInt width, pUInt height) {
			pFloat hW = w.width * 0.5;
			pFloat hH = w.height * 0.5;

			Projection p(-hW, hW, hH, -hH, -100, 100);
			mViewport.width = w.width;
      mViewport.height = w.height;
			mCam.projection = p;
	}
	
	
	void start() {
		Hide();
		if (StartCB !is null) StartCB();
	}	
	
	~StartupScreen()
    {
		echo ("Destroying Startupscreen!");
    }
}