
class GameSettingsSave {
  File@ file;
  //Map<String, SettingWrapper@> saveSettings;

  Map<String, String> saves;
 
  String saveFileName;
  GameSettingsSave(String name) {
    saveFileName = name;
    @file = File();
    readFromFile();
	save();
  }

  void readFromFile() {
    file.open(saveFileName,"r");
    while(!file.isEndOfFile()){
      String keyValue = file.readLine();
      if(keyValue.length()>2){
        int length = keyValue.length()-1;
        keyValue = keyValue.subString(0,length);
        int split = keyValue.findFirst(' ');
        String key = keyValue.subString(0,split);
        String value = keyValue.subString(split+1,length-1);
        saves[key] = value;
      }
    }

    file.close();
  }

  void save() {
    int res = file.open(saveFileName,"w");
    for(auto it = saves.begin(); it++;){
      //echo(it.key+" "+it.value);
      file.writeString(it.key+" "+it.value+"\n");
    }

    file.close();
  }

  void saveValue(String _id, String _value){
    saves.erase(_id);
    saves[_id] = _value;
  }

  void saveValue(String _id, int _value){
    saves.erase(_id);
    saves[_id] = String(_value);
  }

  void saveValue(String _id, uint _value){
    saves.erase(_id);
    saves[_id] = String(_value);
  }

  void saveValue(String _id, bool _value){
    saves.erase(_id);
    saves[_id] = String(_value);
  }

  bool loadString(String &in _id, String &out returnVal){
    if(saves.contains(_id)){
      returnVal = saves[_id];
      return true;
    }
    return false;
  }

  bool loadInt(String &in _id, int &out returnVal){
    if(saves.contains(_id)){
      returnVal = saves[_id].toInt();
      return true;
    }
    return false;
  }

  bool loadUint(String &in _id, uint &out returnVal){
    if(saves.contains(_id)){
      returnVal = saves[_id].toUint();
      return true;
    }
    return false;
  }

  bool loadBool(String &in _id, bool &out returnVal){
    if(saves.contains(_id)){
      returnVal = saves[_id].toBool();
      return true;
    }
    return false;
  }

}
