import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: motionBlur
    name: "motionBlur"
    effectName: "MotionBlur"
    enabled: syncRoot(motionBlur.name+".ON")

    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;
        }
    }

    RenderTarget { RenderTargetLayer { textureRT: "velBufFeed1"; format: "RGBA16F"; width: windowWidth; height: windowHeight } }
    RenderTarget { RenderTargetLayer { textureRT: "velBufFeed2"; format: "RGBA16F"; width: windowWidth; height: windowHeight } }

    function getCurrentVelBuf() {
        return ((frameIndex&1)===0) ? "velBufFeed1" : "velBufFeed2";
    }

    RenderTarget {
        RenderTargetLayer { textureRT: getCurrentVelBuf(); format: "RGBA16F"; width: windowWidth; height: windowHeight }
        Texture { textureUnit: 0; textureRT: "emitBuf"; textureWrap: "clamp" }
        Texture { textureUnit: 1; textureRT: ((frameIndex&1)===0) ? "velBufFeed2" : "velBufFeed1"; textureWrap: "clamp" }
        Shader {
            file: "velBufFeed"
            ShaderParam { paramName: "g_feed"; paramValue: sync(motionBlur.name+".feedback") }
            ShaderParam { paramName: "g_newVel"; paramValue: syncOsc(motionBlur.name+".newVel") }
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            drawBuffers: 1
        }
    }


    Blit { textureRT: "screenBuffer"; blitRT: 0 }
  //  Texture { textureUnit: 0; imageUnit: 0; textureRT: getCurrentVelBuf() }
    Texture { textureUnit: 0; textureRT: "screenBuffer"; textureWrap: "clamp" }
    Texture { textureUnit: 1; textureRT:  getCurrentVelBuf(); textureWrap: "clamp" }
    Shader {
        file: "motionBlur"
        ShaderParam { paramName: "g_amp"; paramValue: sync(motionBlur.name+".amp") }
        ShaderParam { paramName: "g_chroma"; paramValue: syncOsc(motionBlur.name+".chroma") }
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }
}
