import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: effect
    name: "spaceWiper"
    effectName: "SpaceWiper"

    Blit { textureRT: "current" }
    Shader { file: "spaceWiper" }
    Texture { textureUnit: 0; textureRT: "current" }
    Texture { textureUnit: 1; textureRT: "mainDepth" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "wipeWidth"; paramValue: sync(effect.name+".wipe.width") }
        ShaderParam { paramName: "wipePosX"; paramValue: syncFFT(effect.name+".wipe.posX") }
        ShaderParam { paramName: "wipeExp"; paramValueVec4: sync(effect.name+".wipe.exp")+","+sync(effect.name+".wipe.expBelow")+","+sync(effect.name+".wipe.expAbove") }
        ShaderParam { paramName: "wipeZero"; paramValue: sync(effect.name+".wipe.zero") }
        ShaderParam { paramName: "wipeOrig"; paramValue: sync(effect.name+".wipe.orig") }
        ShaderParam { paramName: "wipeBright"; paramValue: sync(effect.name+".wipe.bright") }
        ShaderParam { paramName: "wipeRepe"; paramValue: sync(effect.name+".wipe.repe", 1000.0) }
    }
}
