/*
 * Decompiled with CFR 0.152.
 */
package glm_.dualQuat;

import glm_.dualQuat.dualQuat_operators;
import glm_.mat2x4.Mat2x4;
import glm_.mat3x4.Mat3x4;
import glm_.quat.Quat;
import glm_.vec3.Vec3;
import glm_.vec4.Vec4;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 G2\u00020\u0001:\u0001GB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004BG\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B\u0017\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aB\u001b\b\u0016\u0012\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u001c\u00a2\u0006\u0002\u0010\u001eB\u0015\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010 J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0006H\u0086\u0006J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0006H\u0086\u0006J\u0018\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u00172\b\b\u0002\u0010+\u001a\u00020\u0000J\u0018\u0010.\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00192\b\b\u0002\u0010+\u001a\u00020\u0000J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u001dH\u0086\u0002J\b\u00105\u001a\u00020\u001dH\u0016J\u0006\u00106\u001a\u00020-J\u0010\u00107\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020\u0000J\u0019\u00108\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0086\u0002JI\u00108\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0086\u0002J \u00109\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u00062\b\b\u0002\u0010+\u001a\u00020\u0000J\u0006\u0010;\u001a\u00020\u0000J\u0006\u0010<\u001a\u00020\u0000J\u0011\u0010=\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010=\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010>\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010?\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010JF\u0010?\u001a\u00020-2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0019\u0010@\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010B\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010B\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0086\u0006J\u0016\u0010B\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0014J\u0011\u0010B\u001a\u00020C2\u0006\u0010*\u001a\u00020CH\u0086\u0006J\u0016\u0010B\u001a\u00020C2\u0006\u0010*\u001a\u00020C2\u0006\u0010+\u001a\u00020CJ\u0011\u0010B\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0006H\u0086\u0006J\u0016\u0010B\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010D\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010D\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0014H\u0086\u0006J\u0011\u0010D\u001a\u00020-2\u0006\u0010*\u001a\u00020CH\u0086\u0006J\u0011\u0010D\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0006H\u0086\u0006J\t\u0010E\u001a\u00020\u0000H\u0086\u0002J\t\u0010F\u001a\u00020\u0000H\u0086\u0002R\u001a\u0010\u001f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\u0011R\u0014\u0010$\u001a\u00020\u001dX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\"\"\u0004\b(\u0010\u0011\u00a8\u0006H"}, d2={"Lglm_/dualQuat/DualQuat;", "", "()V", "dualQuat", "(Lglm_/dualQuat/DualQuat;)V", "realW", "", "realX", "realY", "realZ", "dualW", "dualX", "dualY", "dualZ", "(FFFFFFFF)V", "real", "Lglm_/quat/Quat;", "(Lglm_/quat/Quat;)V", "orientation", "translation", "Lglm_/vec3/Vec3;", "(Lglm_/quat/Quat;Lglm_/vec3/Vec3;)V", "m", "Lglm_/mat2x4/Mat2x4;", "(Lglm_/mat2x4/Mat2x4;)V", "Lglm_/mat3x4/Mat3x4;", "(Lglm_/mat3x4/Mat3x4;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "dual", "(Lglm_/quat/Quat;Lglm_/quat/Quat;)V", "getDual", "()Lglm_/quat/Quat;", "setDual", "length", "getLength", "()I", "getReal", "setReal", "div", "b", "res", "divAssign", "", "dualquat_cast", "x", "equals", "", "other", "get", "index", "hashCode", "identity", "inverse", "invoke", "lerp", "a", "normalize", "normalizeAssign", "plus", "plusAssign", "put", "set", "quat", "times", "Lglm_/vec4/Vec4;", "timesAssign", "unaryMinus", "unaryPlus", "Companion", "glm"})
public final class DualQuat {
    private final int length = 2;
    @NotNull
    private Quat real;
    @NotNull
    private Quat dual;
    @JvmField
    public static final int size;
    public static final Companion Companion;

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final Quat get(int index) {
        Quat quat;
        switch (index) {
            case 0: {
                quat = this.real;
                break;
            }
            case 1: {
                quat = this.dual;
                break;
            }
            default: {
                throw (Throwable)new Error();
            }
        }
        return quat;
    }

    @NotNull
    public final Quat set(int index, @NotNull Quat quat) {
        Quat quat2;
        Intrinsics.checkParameterIsNotNull(quat, "quat");
        switch (index) {
            case 0: {
                quat2 = this.real.put(quat);
                break;
            }
            case 1: {
                quat2 = this.dual.put(quat);
                break;
            }
            default: {
                throw (Throwable)new Error();
            }
        }
        return quat2;
    }

    @NotNull
    public final DualQuat unaryPlus() {
        return this;
    }

    @NotNull
    public final DualQuat unaryMinus() {
        return new DualQuat(this.real.unaryMinus(), this.dual.unaryMinus());
    }

    public final void put(@NotNull Quat real, @NotNull Quat dual) {
        Intrinsics.checkParameterIsNotNull(real, "real");
        Intrinsics.checkParameterIsNotNull(dual, "dual");
        real.put(real.w.floatValue(), real.x.floatValue(), real.y.floatValue(), real.z.floatValue());
        dual.put(dual.w.floatValue(), dual.x.floatValue(), dual.y.floatValue(), dual.z.floatValue());
    }

    public final void put(float realW, float realX, float realY, float realZ, float dualW, float dualX, float dualY, float dualZ) {
        this.real.put(realW, realX, realY, realZ);
        this.dual.put(dualW, dualX, dualY, dualZ);
    }

    @NotNull
    public final DualQuat invoke(float realW, float realX, float realY, float realZ, float dualW, float dualX, float dualY, float dualZ) {
        this.put(realW, realX, realY, realZ, dualW, dualX, dualY, dualZ);
        return this;
    }

    @NotNull
    public final DualQuat invoke(@NotNull Quat real, @NotNull Quat dual) {
        Intrinsics.checkParameterIsNotNull(real, "real");
        Intrinsics.checkParameterIsNotNull(dual, "dual");
        this.put(real, dual);
        return this;
    }

    @NotNull
    public final DualQuat plus(@NotNull DualQuat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(new DualQuat(), this, b);
    }

    @NotNull
    public final DualQuat plus(@NotNull DualQuat b, @NotNull DualQuat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.plus(res, this, b);
    }

    public final void plusAssign(@NotNull DualQuat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final DualQuat times(@NotNull DualQuat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new DualQuat(), this, b);
    }

    @NotNull
    public final DualQuat times(float b) {
        return Companion.times(new DualQuat(), this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Vec3(), this, b);
    }

    @NotNull
    public final Vec4 times(@NotNull Vec4 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Vec4(), this, b);
    }

    @NotNull
    public final DualQuat times(@NotNull DualQuat b, @NotNull DualQuat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final DualQuat times(float b, @NotNull DualQuat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b, @NotNull Vec3 res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec4 times(@NotNull Vec4 b, @NotNull Vec4 res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    public final void timesAssign(@NotNull DualQuat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.times(this, this, b);
    }

    public final void timesAssign(float b) {
        Companion.times(this, this, b);
    }

    public final void timesAssign(@NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.times(b, this, b);
    }

    public final void timesAssign(@NotNull Vec4 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.times(b, this, b);
    }

    @NotNull
    public final DualQuat div(float b) {
        return Companion.div(new DualQuat(), this, b);
    }

    @NotNull
    public final DualQuat div(float b, @NotNull DualQuat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.div(res, this, b);
    }

    public final void divAssign(float b) {
        Companion.div(this, this, b);
    }

    public final void identity() {
        this.real.put(1.0f, 0.0f, 0.0f, 0.0f);
        this.dual.put(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public final DualQuat normalize() {
        return this.div(this.real.length(), new DualQuat());
    }

    @NotNull
    public final DualQuat normalizeAssign() {
        this.divAssign(this.real.length());
        return this;
    }

    @NotNull
    public final DualQuat lerp(@NotNull DualQuat b, float a2, @NotNull DualQuat res) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        float f = a2;
        boolean bl2 = bl = f >= 0.0f && f <= 1.0f;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        float k = this.real.dot(b.real) < 0.0f ? -a2 : a2;
        float j = 1.0f - a2;
        return res.invoke(this.real.w.floatValue() * j + b.real.w.floatValue() * k, this.real.x.floatValue() * j + b.real.x.floatValue() * k, this.real.y.floatValue() * j + b.real.y.floatValue() * k, this.real.z.floatValue() * j + b.real.z.floatValue() * k, this.dual.z.floatValue() * j + b.dual.z.floatValue() * k, this.dual.z.floatValue() * j + b.dual.z.floatValue() * k, this.dual.z.floatValue() * j + b.dual.z.floatValue() * k, this.dual.z.floatValue() * j + b.dual.z.floatValue() * k);
    }

    @NotNull
    public static /* synthetic */ DualQuat lerp$default(DualQuat dualQuat, DualQuat dualQuat2, float f, DualQuat dualQuat3, int n, Object object) {
        if ((n & 4) != 0) {
            dualQuat3 = new DualQuat();
        }
        return dualQuat.lerp(dualQuat2, f, dualQuat3);
    }

    @NotNull
    public final DualQuat inverse(@NotNull DualQuat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        float realW = this.real.w.floatValue();
        float realX = -this.real.x.floatValue();
        float realY = -this.real.y.floatValue();
        float realZ = -this.real.z.floatValue();
        float dualW = this.dual.w.floatValue();
        float dualX = -this.dual.x.floatValue();
        float dualY = -this.dual.y.floatValue();
        float dualZ = -this.dual.z.floatValue();
        float dot = realX * dualX + realY * dualY + realZ * dualZ + realW * dualW;
        float w = dualW + realW * (-2.0f * dot);
        float x = dualX + realX * (-2.0f * dot);
        float y = dualY + realY * (-2.0f * dot);
        float z = dualZ + realZ * (-2.0f * dot);
        return res.invoke(realW, realX, realY, realZ, w, x, y, z);
    }

    @NotNull
    public static /* synthetic */ DualQuat inverse$default(DualQuat dualQuat, DualQuat dualQuat2, int n, Object object) {
        if ((n & 1) != 0) {
            dualQuat2 = new DualQuat();
        }
        return dualQuat.inverse(dualQuat2);
    }

    @NotNull
    public final DualQuat dualquat_cast(@NotNull Mat2x4 x, @NotNull DualQuat res) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return res.invoke(x.get(0).getW().floatValue(), x.get(0).getX().floatValue(), x.get(0).getY().floatValue(), x.get(0).getZ().floatValue(), x.get(1).getW().floatValue(), x.get(1).getX().floatValue(), x.get(1).getY().floatValue(), x.get(1).getZ().floatValue());
    }

    @NotNull
    public static /* synthetic */ DualQuat dualquat_cast$default(DualQuat dualQuat, Mat2x4 mat2x4, DualQuat dualQuat2, int n, Object object) {
        if ((n & 2) != 0) {
            dualQuat2 = new DualQuat();
        }
        return dualQuat.dualquat_cast(mat2x4, dualQuat2);
    }

    @NotNull
    public final DualQuat dualquat_cast(@NotNull Mat3x4 m, @NotNull DualQuat res) {
        float r;
        Intrinsics.checkParameterIsNotNull(m, "m");
        Intrinsics.checkParameterIsNotNull(res, "res");
        Quat real = new Quat();
        float trace = m.get(0, 0).floatValue() + m.get(1, 1).floatValue() + m.get(2, 2).floatValue();
        if (trace > 0.0f) {
            float f = 1.0f + trace;
            r = (float)Math.sqrt(f);
            float invR = 0.5f / r;
            real.w = Float.valueOf(0.5f * r);
            real.x = Float.valueOf((m.get(2, 1).floatValue() - m.get(1, 2).floatValue()) * invR);
            real.y = Float.valueOf((m.get(0, 2).floatValue() - m.get(2, 0).floatValue()) * invR);
            real.z = Float.valueOf((m.get(1, 0).floatValue() - m.get(0, 1).floatValue()) * invR);
        } else if (m.get(0, 0).floatValue() > m.get(1, 1).floatValue() && m.get(0, 0).floatValue() > m.get(2, 2).floatValue()) {
            float invR = 1.0f + m.get(0, 0).floatValue() - m.get(1, 1).floatValue() - m.get(2, 2).floatValue();
            r = (float)Math.sqrt(invR);
            invR = 0.5f / r;
            real.x = Float.valueOf(0.5f * r);
            real.y = Float.valueOf((m.get(1, 0).floatValue() + m.get(0, 1).floatValue()) * invR);
            real.z = Float.valueOf((m.get(0, 2).floatValue() + m.get(2, 0).floatValue()) * invR);
            real.w = Float.valueOf((m.get(2, 1).floatValue() - m.get(1, 2).floatValue()) * invR);
        } else if (m.get(1, 1).floatValue() > m.get(2, 2).floatValue()) {
            float invR = 1.0f + m.get(1, 1).floatValue() - m.get(0, 0).floatValue() - m.get(2, 2).floatValue();
            r = (float)Math.sqrt(invR);
            invR = 0.5f / r;
            real.x = Float.valueOf((m.get(1, 0).floatValue() + m.get(0, 1).floatValue()) * invR);
            real.y = Float.valueOf(0.5f * r);
            real.z = Float.valueOf((m.get(2, 1).floatValue() + m.get(1, 2).floatValue()) * invR);
            real.w = Float.valueOf((m.get(0, 2).floatValue() - m.get(2, 0).floatValue()) * invR);
        } else {
            float invR = 1.0f + m.get(2, 2).floatValue() - m.get(0, 0).floatValue() - m.get(1, 1).floatValue();
            r = (float)Math.sqrt(invR);
            invR = 0.5f / r;
            real.x = Float.valueOf((m.get(0, 2).floatValue() + m.get(2, 0).floatValue()) * invR);
            real.y = Float.valueOf((m.get(2, 1).floatValue() + m.get(1, 2).floatValue()) * invR);
            real.z = Float.valueOf(0.5f * r);
            real.w = Float.valueOf((m.get(1, 0).floatValue() - m.get(0, 1).floatValue()) * invR);
        }
        Quat dual = new Quat(-0.5f * (m.get(0, 3).floatValue() * real.x.floatValue() + m.get(1, 3).floatValue() * real.y.floatValue() + m.get(2, 3).floatValue() * real.z.floatValue()), 0.5f * (m.get(0, 3).floatValue() * real.w.floatValue() + m.get(1, 3).floatValue() * real.z.floatValue() - m.get(2, 3).floatValue() * real.y.floatValue()), 0.5f * (-m.get(0, 3).floatValue() * real.z.floatValue() + m.get(1, 3).floatValue() * real.w.floatValue() + m.get(2, 3).floatValue() * real.x.floatValue()), 0.5f * (m.get(0, 3).floatValue() * real.y.floatValue() - m.get(1, 3).floatValue() * real.x.floatValue() + m.get(2, 3).floatValue() * real.w.floatValue()));
        return res.invoke(real, dual);
    }

    @NotNull
    public static /* synthetic */ DualQuat dualquat_cast$default(DualQuat dualQuat, Mat3x4 mat3x4, DualQuat dualQuat2, int n, Object object) {
        if ((n & 2) != 0) {
            dualQuat2 = new DualQuat();
        }
        return dualQuat.dualquat_cast(mat3x4, dualQuat2);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DualQuat && Intrinsics.areEqual(this.real, ((DualQuat)other).real) && Intrinsics.areEqual(this.dual, ((DualQuat)other).dual);
    }

    public int hashCode() {
        return 31 * this.real.hashCode() + this.dual.hashCode();
    }

    @NotNull
    public final Quat getReal() {
        return this.real;
    }

    public final void setReal(@NotNull Quat quat) {
        Intrinsics.checkParameterIsNotNull(quat, "<set-?>");
        this.real = quat;
    }

    @NotNull
    public final Quat getDual() {
        return this.dual;
    }

    public final void setDual(@NotNull Quat quat) {
        Intrinsics.checkParameterIsNotNull(quat, "<set-?>");
        this.dual = quat;
    }

    public DualQuat(@NotNull Quat real, @NotNull Quat dual) {
        Intrinsics.checkParameterIsNotNull(real, "real");
        Intrinsics.checkParameterIsNotNull(dual, "dual");
        this.real = real;
        this.dual = dual;
        this.length = 2;
    }

    public DualQuat() {
        this(new Quat(), new Quat(0.0f));
    }

    public DualQuat(@NotNull DualQuat dualQuat) {
        Intrinsics.checkParameterIsNotNull(dualQuat, "dualQuat");
        this(new Quat(dualQuat.real), new Quat(dualQuat.dual));
    }

    public DualQuat(float realW, float realX, float realY, float realZ, float dualW, float dualX, float dualY, float dualZ) {
        this(new Quat(realW, realX, realY, realZ), new Quat(dualW, dualX, dualY, dualZ));
    }

    public DualQuat(@NotNull Quat real) {
        Intrinsics.checkParameterIsNotNull(real, "real");
        this(real, new Quat(0.0f));
    }

    public DualQuat(@NotNull Quat orientation, @NotNull Vec3 translation) {
        Intrinsics.checkParameterIsNotNull(orientation, "orientation");
        Intrinsics.checkParameterIsNotNull(translation, "translation");
        this(orientation, new Quat(-0.5f * (translation.getX().floatValue() * orientation.x.floatValue() + translation.getY().floatValue() * orientation.y.floatValue() + translation.getZ().floatValue() * orientation.z.floatValue()), 0.5f * (translation.getX().floatValue() * orientation.w.floatValue() + translation.getY().floatValue() * orientation.z.floatValue() - translation.getZ().floatValue() * orientation.y.floatValue()), 0.5f * (-translation.getX().floatValue() * orientation.z.floatValue() + translation.getY().floatValue() * orientation.w.floatValue() + translation.getZ().floatValue() * orientation.x.floatValue()), 0.5f * (translation.getX().floatValue() * orientation.y.floatValue() - translation.getY().floatValue() * orientation.x.floatValue() + translation.getZ().floatValue() * orientation.w.floatValue())));
    }

    public DualQuat(@NotNull Mat2x4 m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        this();
        this.dualquat_cast(m, this);
    }

    public DualQuat(@NotNull Mat3x4 m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        this();
        this.dualquat_cast(m, this);
    }

    public DualQuat(@NotNull Function1<? super Integer, Float> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        this(((Number)block.invoke((Integer)0)).floatValue(), ((Number)block.invoke((Integer)1)).floatValue(), ((Number)block.invoke((Integer)2)).floatValue(), ((Number)block.invoke((Integer)3)).floatValue(), ((Number)block.invoke((Integer)4)).floatValue(), ((Number)block.invoke((Integer)5)).floatValue(), ((Number)block.invoke((Integer)6)).floatValue(), ((Number)block.invoke((Integer)7)).floatValue());
    }

    static {
        Companion = new Companion(null);
        size = Quat.size * 2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lglm_/dualQuat/DualQuat$Companion;", "Lglm_/dualQuat/dualQuat_operators;", "()V", "size", "", "identity", "Lglm_/dualQuat/DualQuat;", "glm"})
    public static final class Companion
    implements dualQuat_operators {
        @NotNull
        public final DualQuat identity() {
            return new DualQuat();
        }

        private Companion() {
        }

        @Override
        @NotNull
        public DualQuat plus(@NotNull DualQuat res, @NotNull DualQuat a2, @NotNull DualQuat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return dualQuat_operators.DefaultImpls.plus(this, res, a2, b);
        }

        @Override
        @NotNull
        public DualQuat times(@NotNull DualQuat res, @NotNull DualQuat a2, @NotNull DualQuat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return dualQuat_operators.DefaultImpls.times((dualQuat_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull DualQuat q, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return dualQuat_operators.DefaultImpls.times((dualQuat_operators)this, res, q, v);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Vec3 v, @NotNull DualQuat q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return dualQuat_operators.DefaultImpls.times((dualQuat_operators)this, res, v, q);
        }

        @Override
        @NotNull
        public Vec4 times(@NotNull Vec4 res, @NotNull DualQuat q, @NotNull Vec4 v) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return dualQuat_operators.DefaultImpls.times((dualQuat_operators)this, res, q, v);
        }

        @Override
        @NotNull
        public Vec4 times(@NotNull Vec4 res, @NotNull Vec4 v, @NotNull DualQuat q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return dualQuat_operators.DefaultImpls.times((dualQuat_operators)this, res, v, q);
        }

        @Override
        @NotNull
        public DualQuat times(@NotNull DualQuat res, @NotNull DualQuat q, float s2) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return dualQuat_operators.DefaultImpls.times((dualQuat_operators)this, res, q, s2);
        }

        @Override
        @NotNull
        public DualQuat div(@NotNull DualQuat res, @NotNull DualQuat q, float s2) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return dualQuat_operators.DefaultImpls.div(this, res, q, s2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

