/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.ExtensionsKt;
import glm_.Primitive_extensionsKt;
import glm_.glm;
import glm_.mat3x3.Mat3;
import glm_.mat3x3.Mat3d;
import glm_.mat4x4.Mat4;
import glm_.mat4x4.Mat4d;
import glm_.quat.Quat;
import glm_.quat.QuatT;
import glm_.quat.gtcQuaternion;
import glm_.quat.quatD_operators;
import glm_.vec3.Vec3;
import glm_.vec3.Vec3d;
import glm_.vec4.Vec4bool;
import glm_.vec4.Vec4d;
import glm_.vec4.Vec4t;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 T2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001TB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB\u001b\b\u0016\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0010\u00a2\u0006\u0002\u0010\u0012B\u000f\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0019B'\b\u0016\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001d\u001a\u00020\u001b\u0012\u0006\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001fB\u0013\b\u0016\u0012\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030 \u00a2\u0006\u0002\u0010!B%\u0012\u0006\u0010\u001a\u001a\u00020\u0002\u0012\u0006\u0010\u001c\u001a\u00020\u0002\u0012\u0006\u0010\u001d\u001a\u00020\u0002\u0012\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u0002J\"\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u0000H\u0007J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u000bJ\u0012\u0010(\u001a\u00020\u00002\b\b\u0002\u0010&\u001a\u00020\u0000H\u0007J\u0006\u0010)\u001a\u00020\u0000J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010.\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0096\u0002J\u0012\u00103\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u000bH\u0007J\b\u00104\u001a\u00020\u0011H\u0016J\u0012\u00105\u001a\u00020\u00002\b\b\u0002\u0010&\u001a\u00020\u0000H\u0007J\u0006\u00106\u001a\u00020\u0000J\u0006\u00107\u001a\u00020\u0002J\u0011\u00108\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0016\u00108\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u0011\u00109\u001a\u00020-2\u0006\u0010+\u001a\u00020\u0000H\u0086\u0006J\u0012\u0010:\u001a\u00020\u00002\b\b\u0002\u0010&\u001a\u00020\u0000H\u0007J\u0006\u0010;\u001a\u00020\u0000J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010=\u001a\u00020-2\u0006\u0010+\u001a\u00020\u0000H\u0086\u0006J\u0010\u0010>\u001a\u00020-2\b\b\u0002\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020-2\b\b\u0002\u0010?\u001a\u00020@J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0000H\u0086\u0004J&\u0010B\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002J\u0019\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u001bH\u0096\u0002J\"\u0010G\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u00022\b\b\u0002\u0010&\u001a\u00020\u0000H\u0007J\u0016\u0010I\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0002J\u0011\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010J\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0086\u0006J\u0016\u0010J\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bJ\u0011\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0017H\u0086\u0006J\u0016\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010K\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0086\u0004J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0017H\u0086\u0004J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0002H\u0086\u0004J\u0015\u0010L\u001a\u00020-2\n\u0010M\u001a\u00060Nj\u0002`OH\u0086\u0004J\b\u0010P\u001a\u00020@H\u0016J\t\u0010Q\u001a\u00020\u0000H\u0086\u0002J\t\u0010R\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010S\u001a\u00020-2\b\b\u0002\u0010&\u001a\u00020\u0017H\u0007\u00a8\u0006U"}, d2={"Lglm_/quat/QuatD;", "Lglm_/quat/QuatT;", "", "()V", "d", "(D)V", "q", "Lglm_/quat/Quat;", "(Lglm_/quat/Quat;)V", "s", "v", "Lglm_/vec3/Vec3d;", "(DLglm_/vec3/Vec3d;)V", "u", "(Lglm_/vec3/Vec3d;Lglm_/vec3/Vec3d;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "eulerAngle", "Lglm_/vec3/Vec3;", "(Lglm_/vec3/Vec3;)V", "vec4", "Lglm_/vec4/Vec4d;", "(Lglm_/vec4/Vec4d;)V", "(Lglm_/quat/QuatD;)V", "w", "", "x", "y", "z", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lglm_/vec4/Vec4t;", "(Lglm_/vec4/Vec4t;)V", "(DDDD)V", "angle", "angleAxis", "axis", "res", "angleAxisAssign", "conjugate", "conjugateAssign", "div", "b", "divAssign", "", "dot", "equals", "", "other", "", "eulerAngles", "hashCode", "inverse", "inverseAssign", "length", "minus", "minusAssign", "normalize", "normalizeAssign", "plus", "plusAssign", "print", "name", "", "printErr", "put", "quat", "set", "index", "value", "slerp", "interp", "slerpAssign", "times", "timesAssign", "to", "ptr", "", "Lkool/Ptr;", "toString", "unaryMinus", "unaryPlus", "vectorize", "Companion", "glm"})
public final class QuatD
extends QuatT<Double> {
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public final QuatD put(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public final QuatD put(@NotNull QuatD quat) {
        Intrinsics.checkParameterIsNotNull(quat, "quat");
        return this.put(quat.w.doubleValue(), quat.x.doubleValue(), quat.y.doubleValue(), quat.z.doubleValue());
    }

    public final void to(long ptr) {
        MemoryUtil.memPutDouble(ptr, this.w.doubleValue());
        MemoryUtil.memPutDouble(ptr + (long)Primitive_extensionsKt.getBYTES(DoubleCompanionObject.INSTANCE), this.x.doubleValue());
        MemoryUtil.memPutDouble(ptr + (long)(Primitive_extensionsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 2), this.y.doubleValue());
        MemoryUtil.memPutDouble(ptr + (long)(Primitive_extensionsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 3), this.z.doubleValue());
    }

    @Override
    public void set(int index, @NotNull Number value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        switch (index) {
            case 0: {
                this.x = ExtensionsKt.getD(value2);
                break;
            }
            case 1: {
                this.y = ExtensionsKt.getD(value2);
                break;
            }
            case 2: {
                this.z = ExtensionsKt.getD(value2);
                break;
            }
            case 3: {
                this.w = ExtensionsKt.getD(value2);
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final QuatD unaryPlus() {
        return this;
    }

    @NotNull
    public final QuatD unaryMinus() {
        return new QuatD(-this.w.doubleValue(), -this.x.doubleValue(), -this.y.doubleValue(), -this.z.doubleValue());
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.plus(res, this, b);
    }

    public final void plusAssign(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.minus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.minus(res, this, b);
    }

    public final void minusAssign(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.minus(this, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(double b) {
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Vec3d(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times(double b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b, @NotNull Vec3d res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final QuatD timesAssign(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD timesAssign(double b) {
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Vec3d timesAssign(@NotNull Vec3d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(b, this, b);
    }

    @NotNull
    public final QuatD timesAssign(@NotNull Vec4d b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD div(double b) {
        return Companion.div(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD div(double b, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.div(res, this, b);
    }

    public final void divAssign(double b) {
        Companion.div(this, this, b);
    }

    public final double length() {
        return glm.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize(@NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.normalize(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ QuatD normalize$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.normalize(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize() {
        return QuatD.normalize$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD normalizeAssign() {
        return glm.INSTANCE.normalize(this, this);
    }

    public final double dot(@NotNull QuatD b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.angleAxis(angle, axis, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ QuatD angleAxis$default(QuatD quatD, double d, Vec3d vec3d, QuatD quatD2, int n, Object object) {
        if ((n & 4) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.angleAxis(d, vec3d, quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis) {
        return QuatD.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @NotNull
    public final QuatD angleAxisAssign(double angle, @NotNull Vec3d axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return glm.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate(@NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.conjugate(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ QuatD conjugate$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.conjugate(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate() {
        return QuatD.conjugate$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD conjugateAssign() {
        return glm.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse(@NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.inverse(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ QuatD inverse$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.inverse(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse() {
        return QuatD.inverse$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD inverseAssign() {
        return glm.INSTANCE.inverse(this, this);
    }

    public final double angle() {
        return glm.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles(@NotNull Vec3d res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.eulerAngles(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Vec3d eulerAngles$default(QuatD quatD, Vec3d vec3d, int n, Object object) {
        if ((n & 1) != 0) {
            vec3d = new Vec3d();
        }
        return quatD.eulerAngles(vec3d);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles() {
        return QuatD.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp, @NotNull QuatD res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.slerp(this, b, interp, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ QuatD slerp$default(QuatD quatD, QuatD quatD2, double d, QuatD quatD3, int n, Object object) {
        if ((n & 4) != 0) {
            quatD3 = new QuatD();
        }
        return quatD.slerp(quatD2, d, quatD3);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp) {
        return QuatD.slerp$default(this, b, interp, null, 4, null);
    }

    @NotNull
    public final QuatD slerpAssign(@NotNull QuatD b, double interp) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.slerp(this, b, interp, this);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof QuatD && ((Number)this.get(0)).doubleValue() == ((Number)((QuatD)other).get(0)).doubleValue() && ((Number)this.get(1)).doubleValue() == ((Number)((QuatD)other).get(1)).doubleValue() && ((Number)this.get(2)).doubleValue() == ((Number)((QuatD)other).get(2)).doubleValue() && ((Number)this.get(3)).doubleValue() == ((Number)((QuatD)other).get(3)).doubleValue();
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.w.hashCode() + this.x.hashCode()) + this.y.hashCode()) + this.z.hashCode();
    }

    public final void printErr(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        System.err.println(name + " (" + this.w.doubleValue() + ", {" + this.x.doubleValue() + ", " + this.y.doubleValue() + ", " + this.z.doubleValue() + "})");
    }

    public static /* synthetic */ void printErr$default(QuatD quatD, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        quatD.printErr(string);
    }

    public final void print(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string = name + " (" + this.w.doubleValue() + ", {" + this.x.doubleValue() + ", " + this.y.doubleValue() + ", " + this.z.doubleValue() + "})";
        System.out.println((Object)string);
    }

    public static /* synthetic */ void print$default(QuatD quatD, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        quatD.print(string);
    }

    @NotNull
    public String toString() {
        return "QuatD (" + this.w.doubleValue() + ", {" + this.x.doubleValue() + ", " + this.y.doubleValue() + ", " + this.z.doubleValue() + "})";
    }

    @JvmOverloads
    public final void vectorize(@NotNull Vec4d res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        res.put(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue(), this.w.doubleValue());
    }

    @JvmOverloads
    public static /* synthetic */ void vectorize$default(QuatD quatD, Vec4d vec4d, int n, Object object) {
        if ((n & 1) != 0) {
            vec4d = new Vec4d();
        }
        quatD.vectorize(vec4d);
    }

    @JvmOverloads
    public final void vectorize() {
        QuatD.vectorize$default(this, null, 1, null);
    }

    public QuatD(double w, double x, double y, double z) {
        super(w, x, y, z);
    }

    public QuatD() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public QuatD(double d) {
        this(d, d, d, d);
    }

    public QuatD(@NotNull Quat q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(q.w, q.x, q.y, q.z);
    }

    public QuatD(double s2, @NotNull Vec3d v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this(s2, v.getX(), v.getY(), v.getZ());
    }

    public QuatD(@NotNull Vec3d u, @NotNull Vec3d v) {
        Vec3d vec3d;
        Intrinsics.checkParameterIsNotNull(u, "u");
        Intrinsics.checkParameterIsNotNull(v, "v");
        this();
        double d = u.dot(u) * v.dot(v);
        double normUnormV = Math.sqrt(d);
        double realPart = normUnormV + u.dot(v);
        if (realPart < (double)1.0E-6f * normUnormV) {
            realPart = 0.0;
            double d2 = u.getX();
            double d3 = Math.abs(d2);
            double d4 = d3;
            d2 = u.getZ();
            double d5 = Math.abs(d2);
            vec3d = d4 > d5 ? new Vec3d(-u.getY().doubleValue(), u.getX(), 0.0) : new Vec3d(0.0, -u.getZ().doubleValue(), u.getY());
        } else {
            vec3d = u.cross(v);
        }
        Vec3d w = vec3d;
        this.put(realPart, w.getX(), w.getY(), w.getZ()).normalizeAssign();
    }

    public QuatD(@NotNull Function1<? super Integer, Double> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        this(((Number)block.invoke((Integer)0)).doubleValue(), ((Number)block.invoke((Integer)1)).doubleValue(), ((Number)block.invoke((Integer)2)).doubleValue(), ((Number)block.invoke((Integer)3)).doubleValue());
    }

    public QuatD(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkParameterIsNotNull(eulerAngle, "eulerAngle");
        this();
        double eX = (double)eulerAngle.getX().floatValue() * 0.5;
        double eY = (double)eulerAngle.getY().floatValue() * 0.5;
        double eZ = (double)eulerAngle.getZ().floatValue() * 0.5;
        double cX = glm.INSTANCE.cos(eX);
        double cY = glm.INSTANCE.cos(eY);
        double cZ = glm.INSTANCE.cos(eZ);
        double sX = glm.INSTANCE.sin(eX);
        double sY = glm.INSTANCE.sin(eY);
        double sZ = glm.INSTANCE.sin(eZ);
        this.w = cX * cY * cZ + sX * sY * sZ;
        this.x = sX * cY * cZ - cX * sY * sZ;
        this.y = cX * sY * cZ + sX * cY * sZ;
        this.z = cX * cY * sZ - sX * sY * cZ;
    }

    public QuatD(@NotNull Vec4d vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(vec4.getW(), vec4.getX(), vec4.getY(), vec4.getZ());
    }

    public QuatD(@NotNull QuatD q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(ExtensionsKt.getD(q.w), ExtensionsKt.getD(q.x), ExtensionsKt.getD(q.y), ExtensionsKt.getD(q.z));
    }

    public QuatD(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkParameterIsNotNull(w, "w");
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(y, "y");
        Intrinsics.checkParameterIsNotNull(z, "z");
        this(ExtensionsKt.getD(w), ExtensionsKt.getD(x), ExtensionsKt.getD(y), ExtensionsKt.getD(z));
    }

    public QuatD(@NotNull Vec4t<?> vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(ExtensionsKt.getD(vec4.getW()), ExtensionsKt.getD(vec4.getX()), ExtensionsKt.getD(vec4.getY()), ExtensionsKt.getD(vec4.getZ()));
    }

    static {
        Companion = new Companion(null);
        size = 4 * Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Quat fromPointer(long ptr) {
        return Companion.fromPointer(ptr);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lglm_/quat/QuatD$Companion;", "Lglm_/quat/quatD_operators;", "Lglm_/quat/gtcQuaternion;", "()V", "size", "", "fromPointer", "Lglm_/quat/Quat;", "ptr", "", "Lkool/Ptr;", "glm"})
    public static final class Companion
    implements quatD_operators,
    gtcQuaternion {
        @JvmStatic
        @NotNull
        public final Quat fromPointer(long ptr) {
            return new Quat(MemoryUtil.memGetDouble(ptr), MemoryUtil.memGetDouble(ptr + (long)Primitive_extensionsKt.getBYTES(DoubleCompanionObject.INSTANCE)), MemoryUtil.memGetDouble(ptr + (long)(Primitive_extensionsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 2)), MemoryUtil.memGetDouble(ptr + (long)(Primitive_extensionsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 3)));
        }

        private Companion() {
        }

        @Override
        @NotNull
        public QuatD plus(@NotNull QuatD res, @NotNull QuatD a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.plus(this, res, a2, b);
        }

        @Override
        @NotNull
        public QuatD minus(@NotNull QuatD res, @NotNull QuatD a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.minus(this, res, a2, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a2, double b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res, @NotNull QuatD a2, @NotNull Vec3d b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res, @NotNull Vec3d a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res, @NotNull QuatD a2, @NotNull Vec4d b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public QuatD div(@NotNull QuatD res, @NotNull QuatD a2, double b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return quatD_operators.DefaultImpls.div(this, res, a2, b);
        }

        @Override
        public float length(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.length((gtcQuaternion)this, q);
        }

        @Override
        public double length(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.length((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q);
        }

        @Override
        public float dot(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.dot((gtcQuaternion)this, a2, b);
        }

        @Override
        public double dot(@NotNull QuatD a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.dot((gtcQuaternion)this, a2, b);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a2, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a2, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a2, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a2, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a2, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a2, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2);
        }

        @Override
        public float roll(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.roll((gtcQuaternion)this, q);
        }

        @Override
        public double roll(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.roll((gtcQuaternion)this, q);
        }

        @Override
        public float pitch(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.pitch((gtcQuaternion)this, q);
        }

        @Override
        public double pitch(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.pitch((gtcQuaternion)this, q);
        }

        @Override
        public float yaw(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.yaw((gtcQuaternion)this, q);
        }

        @Override
        public double yaw(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.yaw((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mat3_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mat4_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.mat4d_cast(this, res, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return gtcQuaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return gtcQuaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        public float angle(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.angle((gtcQuaternion)this, q);
        }

        @Override
        public double angle(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.angle((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ) {
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ) {
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lessThan(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lessThan(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lessThanEqual(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lessThanEqual(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.greater(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.greater(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.greaterThan(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.greaterThan(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.equal(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.equal(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.notEqual(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.notEqual(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.isNan(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.isInf(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.isInf(this, q);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

