/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.detail.SetupKt;
import glm_.func.Func_trigonometricKt;
import glm_.glm;
import glm_.mat3x3.Mat3;
import glm_.mat4x4.Mat4;
import glm_.quat.Quat;
import glm_.quat.gtxQuaternion$WhenMappings;
import glm_.vec3.Vec3;
import glm_.vec3.operators.Vec3_operatorsKt;
import glm_.vec4.Vec4;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0016J\u0012\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0004\u001a\u00020\u0006H\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J \u0010!\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0016J0\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\nH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020+H\u0016\u00a8\u0006-"}, d2={"Lglm_/quat/gtxQuaternion;", "", "cross", "Lglm_/vec3/Vec3;", "res", "q", "Lglm_/quat/Quat;", "v", "exp", "extractRealComponent", "", "fastMix", "x", "y", "a", "intermediate", "prev", "curr", "next", "length2", "log", "pow", "quatIdentity", "quatLookAt", "direction", "up", "quatLookAtLH", "quatLookAtRH", "rotate", "Lglm_/vec4/Vec4;", "rotation", "orig", "dest", "shortMix", "squad", "q1", "q2", "s1", "s2", "h", "toMat3", "Lglm_/mat3x3/Mat3;", "toMat4", "Lglm_/mat4x4/Mat4;", "toQuat", "glm"})
public interface gtxQuaternion {
    @NotNull
    public Quat quatIdentity(@NotNull Quat var1);

    @NotNull
    public Vec3 cross(@NotNull Vec3 var1, @NotNull Quat var2, @NotNull Vec3 var3);

    @NotNull
    public Vec3 cross(@NotNull Vec3 var1, @NotNull Vec3 var2, @NotNull Quat var3);

    @NotNull
    public Quat squad(@NotNull Quat var1, @NotNull Quat var2, @NotNull Quat var3, @NotNull Quat var4, float var5);

    @NotNull
    public Quat intermediate(@NotNull Quat var1, @NotNull Quat var2, @NotNull Quat var3);

    @NotNull
    public Quat exp(@NotNull Quat var1);

    @NotNull
    public Quat log(@NotNull Quat var1);

    @NotNull
    public Quat pow(@NotNull Quat var1, float var2);

    @NotNull
    public Vec3 rotate(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Quat rotate(@NotNull Quat var1, @NotNull Vec4 var2);

    public float extractRealComponent(@NotNull Quat var1);

    @NotNull
    public Mat3 toMat3(@NotNull Quat var1);

    @NotNull
    public Mat4 toMat4(@NotNull Quat var1);

    @NotNull
    public Quat toQuat(@NotNull Mat3 var1);

    @NotNull
    public Quat toQuat(@NotNull Mat4 var1);

    @NotNull
    public Quat shortMix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public Quat fastMix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public Quat rotation(@NotNull Vec3 var1, @NotNull Vec3 var2);

    @NotNull
    public Quat quatLookAt(@NotNull Vec3 var1, @NotNull Vec3 var2);

    @NotNull
    public Quat quatLookAtRH(@NotNull Vec3 var1, @NotNull Vec3 var2);

    @NotNull
    public Quat quatLookAtLH(@NotNull Vec3 var1, @NotNull Vec3 var2);

    public float length2(@NotNull Quat var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Quat quatIdentity(gtxQuaternion $this, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return res.put(1.0f, 0.0f, 0.0f, 0.0f);
        }

        @NotNull
        public static /* synthetic */ Quat quatIdentity$default(gtxQuaternion gtxQuaternion2, Quat quat, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quatIdentity");
            }
            if ((n & 1) != 0) {
                quat = new Quat();
            }
            return gtxQuaternion2.quatIdentity(quat);
        }

        @NotNull
        public static Vec3 cross(gtxQuaternion $this, @NotNull Vec3 res, @NotNull Quat q, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            float dot = glm.INSTANCE.dot(q, q);
            float w = q.w.floatValue() / dot;
            float x = -q.x.floatValue() / dot;
            float y = -q.y.floatValue() / dot;
            float z = -q.z.floatValue() / dot;
            float uvX = y * v.getZ().floatValue() - v.getY().floatValue() * z;
            float uvY = z * v.getX().floatValue() - v.getZ().floatValue() * x;
            float uvZ = x * v.getY().floatValue() - v.getX().floatValue() * y;
            float uuvX = y * uvZ - uvY * z;
            float uuvY = z * uvX - uvZ * x;
            float uuvZ = x * uvY - uvX * y;
            float resX = v.getX().floatValue() + (uvX * w + uuvX) * 2.0f;
            float resY = v.getY().floatValue() + (uvY * w + uuvY) * 2.0f;
            float resZ = v.getZ().floatValue() + (uvZ * w + uuvZ) * 2.0f;
            return res.invoke(Float.valueOf(resX), Float.valueOf(resY), Float.valueOf(resZ));
        }

        @NotNull
        public static Vec3 cross(gtxQuaternion $this, @NotNull Vec3 res, @NotNull Vec3 v, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(q, "q");
            float uvX = q.y.floatValue() * v.getZ().floatValue() - v.getY().floatValue() * q.z.floatValue();
            float uvY = q.z.floatValue() * v.getX().floatValue() - v.getZ().floatValue() * q.x.floatValue();
            float uvZ = q.x.floatValue() * v.getY().floatValue() - v.getX().floatValue() * q.y.floatValue();
            float uuvX = q.y.floatValue() * uvZ - uvY * q.z.floatValue();
            float uuvY = q.z.floatValue() * uvX - uvZ * q.x.floatValue();
            float uuvZ = q.x.floatValue() * uvY - uvX * q.y.floatValue();
            float resX = v.getX().floatValue() + (uvX * q.w.floatValue() + uuvX) * 2.0f;
            float resY = v.getY().floatValue() + (uvY * q.w.floatValue() + uuvY) * 2.0f;
            float resZ = v.getZ().floatValue() + (uvZ * q.w.floatValue() + uuvZ) * 2.0f;
            return res.invoke(Float.valueOf(resX), Float.valueOf(resY), Float.valueOf(resZ));
        }

        @NotNull
        public static Quat squad(gtxQuaternion $this, @NotNull Quat q1, @NotNull Quat q2, @NotNull Quat s1, @NotNull Quat s2, float h) {
            Intrinsics.checkParameterIsNotNull(q1, "q1");
            Intrinsics.checkParameterIsNotNull(q2, "q2");
            Intrinsics.checkParameterIsNotNull(s1, "s1");
            Intrinsics.checkParameterIsNotNull(s2, "s2");
            return glm.INSTANCE.mix(glm.INSTANCE.mix(q1, q2, h), glm.INSTANCE.mix(s1, s2, h), (float)2 * (1.0f - h) * h);
        }

        @NotNull
        public static Quat intermediate(gtxQuaternion $this, @NotNull Quat prev, @NotNull Quat curr, @NotNull Quat next) {
            Intrinsics.checkParameterIsNotNull(prev, "prev");
            Intrinsics.checkParameterIsNotNull(curr, "curr");
            Intrinsics.checkParameterIsNotNull(next, "next");
            Quat invQuat = Quat.inverse$default(curr, null, 1, null);
            return $this.exp($this.log(next.plus(invQuat)).plus($this.log(prev.plus(invQuat))).div(-4.0f)).times(curr);
        }

        @NotNull
        public static Quat exp(gtxQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Vec3 u = new Vec3(q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
            float angle = u.length();
            if (angle < glm.epsilonF) {
                return new Quat();
            }
            Vec3 v = u.div(angle);
            return new Quat(Func_trigonometricKt.getCos(angle), Vec3_operatorsKt.times(Func_trigonometricKt.getSin(angle), v));
        }

        @NotNull
        public static Quat log(gtxQuaternion $this, @NotNull Quat q) {
            Quat quat;
            Intrinsics.checkParameterIsNotNull(q, "q");
            Vec3 u = new Vec3(q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
            float vec3Len = u.length();
            if (vec3Len < glm.epsilonF) {
                quat = q.w.floatValue() > 0.0f ? new Quat(glm.INSTANCE.log(q.w.floatValue()), 0.0f, 0.0f, 0.0f) : (q.w.floatValue() < 0.0f ? new Quat(glm.INSTANCE.log(-q.w.floatValue()), glm.PIf, 0.0f, 0.0f) : new Quat(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY()));
            } else {
                float t = glm.INSTANCE.atan(vec3Len, q.w.floatValue()) / vec3Len;
                float quatLen2 = vec3Len * vec3Len + q.w.floatValue() * q.w.floatValue();
                quat = new Quat(0.5f * glm.INSTANCE.log(quatLen2), t * q.x.floatValue(), t * q.y.floatValue(), t * q.z.floatValue());
            }
            return quat;
        }

        @NotNull
        public static Quat pow(gtxQuaternion $this, @NotNull Quat x, float y) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            if (y > -glm.epsilonF && y < glm.epsilonF) {
                return new Quat(1.0f, 0.0f, 0.0f, 0.0f);
            }
            float f = x.x.floatValue() * x.x.floatValue() + x.y.floatValue() * x.y.floatValue() + x.z.floatValue() * x.z.floatValue() + x.w.floatValue() * x.w.floatValue();
            float magnitude = (float)Math.sqrt(f);
            f = x.w.floatValue() / magnitude;
            if (Math.abs(f) > 1.0f - glm.epsilonF && Math.abs(f = x.w.floatValue() / magnitude) < 1.0f + glm.epsilonF) {
                return new Quat(glm.INSTANCE.pow(x.w.floatValue(), y), 0.0f, 0.0f, 0.0f);
            }
            float f2 = x.w.floatValue() / magnitude;
            float angle = (float)Math.acos(f2);
            float newAngle = angle * y;
            float f3 = (float)Math.sin(newAngle);
            float f4 = (float)Math.sin(angle);
            float div = f3 / f4;
            float mag = glm.INSTANCE.pow(magnitude, y - 1.0f);
            float f5 = (float)Math.cos(newAngle);
            float f6 = x.z.floatValue() * div * mag;
            float f7 = x.y.floatValue() * div * mag;
            float f8 = x.x.floatValue() * div * mag;
            float f9 = f5 * magnitude * mag;
            return new Quat(f9, f8, f7, f6);
        }

        @NotNull
        public static Vec3 rotate(gtxQuaternion $this, @NotNull Quat q, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return q.times(v);
        }

        @NotNull
        public static Quat rotate(gtxQuaternion $this, @NotNull Quat q, @NotNull Vec4 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return q.times(v);
        }

        public static float extractRealComponent(gtxQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            float w = 1.0f - q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() - q.z.floatValue() * q.z.floatValue();
            return w < 0.0f ? 0.0f : -((float)Math.sqrt(w));
        }

        @NotNull
        public static Mat3 toMat3(gtxQuaternion $this, @NotNull Quat x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            return x.toMat3();
        }

        @NotNull
        public static Mat4 toMat4(gtxQuaternion $this, @NotNull Quat x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            return x.toMat4();
        }

        @NotNull
        public static Quat toQuat(gtxQuaternion $this, @NotNull Mat3 x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            return x.toQuat();
        }

        @NotNull
        public static Quat toQuat(gtxQuaternion $this, @NotNull Mat4 x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            return x.toQuat();
        }

        @NotNull
        public static Quat shortMix(gtxQuaternion $this, @NotNull Quat x, @NotNull Quat y, float a2) {
            float k1;
            float k0;
            Intrinsics.checkParameterIsNotNull(x, "x");
            Intrinsics.checkParameterIsNotNull(y, "y");
            if (a2 <= 0.0f) {
                return x;
            }
            if (a2 >= 1.0f) {
                return y;
            }
            float fCos = x.dot(y);
            Quat y2 = new Quat(y);
            if (fCos < 0.0f) {
                y2 = y.unaryMinus();
                fCos = -fCos;
            }
            if (fCos > 1.0f - glm.epsilonF) {
                k0 = 1.0f - a2;
                k1 = 0.0f + a2;
            } else {
                float f = 1.0f - fCos * fCos;
                float fSin = (float)Math.sqrt(f);
                float fAngle = glm.INSTANCE.atan(fSin, fCos);
                float fOneOverSin = 1.0f / fSin;
                float f2 = (1.0f - a2) * fAngle;
                k0 = (float)Math.sin(f2) * fOneOverSin;
                f2 = (0.0f + a2) * fAngle;
                k1 = (float)Math.sin(f2) * fOneOverSin;
            }
            return new Quat(k0 * x.w.floatValue() + k1 * y2.w.floatValue(), k0 * x.x.floatValue() + k1 * y2.x.floatValue(), k0 * x.y.floatValue() + k1 * y2.y.floatValue(), k0 * x.z.floatValue() + k1 * y2.z.floatValue());
        }

        @NotNull
        public static Quat fastMix(gtxQuaternion $this, @NotNull Quat x, @NotNull Quat y, float a2) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            Intrinsics.checkParameterIsNotNull(y, "y");
            return glm.INSTANCE.normalize(x.times(1.0f - a2).plus(y.times(a2)));
        }

        @NotNull
        public static Quat rotation(gtxQuaternion $this, @NotNull Vec3 orig, @NotNull Vec3 dest) {
            Intrinsics.checkParameterIsNotNull(orig, "orig");
            Intrinsics.checkParameterIsNotNull(dest, "dest");
            float cosTheta = orig.dot(dest);
            if (cosTheta >= 1.0f - glm.epsilonF) {
                return DefaultImpls.quatIdentity$default($this, null, 1, null);
            }
            if (cosTheta < (float)-1 + glm.epsilonF) {
                Vec3 rotationAxis = new Vec3((Number)0, (Number)0, (Number)1).cross(orig);
                if (rotationAxis.length2() < glm.epsilonF) {
                    rotationAxis = new Vec3((Number)1, (Number)0, (Number)0).cross(orig);
                }
                rotationAxis = Vec3.normalize$default(rotationAxis, null, 1, null);
                return glm.INSTANCE.angleAxis(glm.PIf, rotationAxis);
            }
            Vec3 rotationAxis = orig.cross(dest);
            float f = (1.0f + cosTheta) * (float)2;
            float s2 = (float)Math.sqrt(f);
            float invs = 1.0f / s2;
            return new Quat(s2 * 0.5f, rotationAxis.getX().floatValue() * invs, rotationAxis.getY().floatValue() * invs, rotationAxis.getZ().floatValue() * invs);
        }

        @NotNull
        public static Quat quatLookAt(gtxQuaternion $this, @NotNull Vec3 direction, @NotNull Vec3 up) {
            Quat quat;
            Intrinsics.checkParameterIsNotNull(direction, "direction");
            Intrinsics.checkParameterIsNotNull(up, "up");
            switch (gtxQuaternion$WhenMappings.$EnumSwitchMapping$0[SetupKt.getGLM_COORDINATE_SYSTEM().ordinal()]) {
                case 1: {
                    quat = $this.quatLookAtLH(direction, up);
                    break;
                }
                default: {
                    quat = $this.quatLookAtRH(direction, up);
                }
            }
            return quat;
        }

        @NotNull
        public static Quat quatLookAtRH(gtxQuaternion $this, @NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkParameterIsNotNull(direction, "direction");
            Intrinsics.checkParameterIsNotNull(up, "up");
            Mat3 result2 = new Mat3();
            result2.set(2, direction.unaryMinus());
            result2.set(0, up.cross(result2.get(2)).normalizeAssign());
            result2.set(1, result2.get(2).cross(result2.get(0)));
            return result2.toQuat();
        }

        @NotNull
        public static Quat quatLookAtLH(gtxQuaternion $this, @NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkParameterIsNotNull(direction, "direction");
            Intrinsics.checkParameterIsNotNull(up, "up");
            Mat3 result2 = new Mat3();
            result2.set(2, direction);
            result2.set(0, up.cross(result2.get(2)).normalizeAssign());
            result2.set(1, result2.get(2).cross(result2.get(0)));
            return result2.toQuat();
        }

        public static float length2(gtxQuaternion $this, @NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return q.dot(q);
        }
    }
}

