/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Line2;
import io.lacuna.artifex.Matrix3;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.utils.DoubleAccumulator;
import io.lacuna.artifex.utils.Equations;
import io.lacuna.artifex.utils.Scalars;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.LinearList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;

public class Bezier2 {
    public static Curve2 curve(Vec2 p0, Vec2 p1) {
        return Line2.line(p0, p1);
    }

    public static Curve2 curve(Vec2 p0, Vec2 p1, Vec2 p2) {
        return new QuadraticBezier2(p0, p1, p2);
    }

    public static Curve2 curve(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3) {
        return new CubicBezier2(p0, p1, p2, p3);
    }

    private static double sign(double n) {
        double s2 = Math.signum(n);
        return s2 == 0.0 ? -1.0 : s2;
    }

    private static <V extends Curve2> void subdivide(List<Vec2> result2, V c, ToDoubleFunction<V> error, double maxError) {
        if (error.applyAsDouble(c) <= maxError) {
            result2.add(c.start());
        } else {
            Curve2[] split = c.split(0.5);
            Bezier2.subdivide(result2, split[0], error, maxError);
            Bezier2.subdivide(result2, split[1], error, maxError);
        }
    }

    public static double signedDistance(Vec2 p, Vec2 a2, Vec2 b) {
        Vec2 d = b.sub(a2);
        return (Vec2.cross(p, d) + Vec2.cross(b, a2)) / d.length();
    }

    public static class CubicBezier2
    implements Curve2 {
        private static final int SEARCH_STARTS = 4;
        private static final int SEARCH_STEPS = 8;
        public final Vec2 p0;
        public final Vec2 p1;
        public final Vec2 p2;
        public final Vec2 p3;
        private boolean noInflections = false;
        private Box2 bounds;

        private CubicBezier2(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3, boolean noInflections) {
            this(p0, p1, p2, p3);
            this.noInflections = noInflections;
        }

        CubicBezier2(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3) {
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        @Override
        public Vec2 position(double t) {
            if (t == 0.0) {
                return this.start();
            }
            if (t == 1.0) {
                return this.end();
            }
            double mt = 1.0 - t;
            double mt2 = mt * mt;
            double t2 = t * t;
            return this.p0.mul(mt2 * mt).add(this.p1.mul(3.0 * mt2 * t)).add(this.p2.mul(3.0 * mt * t2)).add(this.p3.mul(t2 * t));
        }

        @Override
        public Vec2 direction(double t) {
            double mt = 1.0 - t;
            return this.p1.sub(this.p0).mul(3.0 * mt * mt).add(this.p2.sub(this.p1).mul(6.0 * mt * t)).add(this.p3.sub(this.p2).mul(3.0 * t * t));
        }

        @Override
        public double signedArea() {
            return (this.p3.x * (-this.p0.y - 3.0 * this.p1.y - 6.0 * this.p2.y) - 3.0 * this.p2.x * (this.p0.y + this.p1.y - 2.0 * this.p3.y) + 3.0 * this.p1.x * (-2.0 * this.p0.y + this.p2.y + this.p3.y) + this.p0.x * (6.0 * this.p1.y + 3.0 * this.p2.y + this.p3.y)) / 20.0;
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public boolean isFlat(double epsilon2) {
            double d2;
            double d1 = Bezier2.signedDistance(this.p1, this.p0, this.p3);
            double k = d1 * (d2 = Bezier2.signedDistance(this.p2, this.p0, this.p3)) < 0.0 ? 0.4444444444444444 : 0.75;
            return Math.abs(d1 * k) < epsilon2 && Math.abs(d2 * k) < epsilon2;
        }

        @Override
        public CubicBezier2 endpoints(Vec2 start, Vec2 end2) {
            return new CubicBezier2(start, this.p1.add(start.sub(this.p0)), this.p2.add(end2.sub(this.p3)), end2, this.noInflections);
        }

        @Override
        public Vec2 start() {
            return this.p0;
        }

        @Override
        public Vec2 end() {
            return this.p3;
        }

        @Override
        public Curve2[] split(double t) {
            if (t <= 0.0 || t >= 1.0) {
                throw new IllegalArgumentException("t must be within (0,1)");
            }
            Vec2 e = Vec.lerp(this.p0, this.p1, t);
            Vec2 f = Vec.lerp(this.p1, this.p2, t);
            Vec2 g = Vec.lerp(this.p2, this.p3, t);
            Vec2 h = Vec.lerp(e, f, t);
            Vec2 j = Vec.lerp(f, g, t);
            Vec2 k = this.position(t);
            return new Curve2[]{new CubicBezier2(this.p0, e, h, k, this.noInflections), new CubicBezier2(k, j, g, this.p3, this.noInflections)};
        }

        @Override
        public Vec2[] subdivide(double error) {
            ArrayList<Vec2> points = new ArrayList<Vec2>();
            Bezier2.subdivide(points, this, b -> Math.max(Vec.lerp(b.p0, b.p3, 0.3333333333333333).sub(b.p1).lengthSquared(), Vec.lerp(b.p0, b.p3, 0.6666666666666666).sub(b.p2).lengthSquared()), error * error);
            points.add(this.end());
            return points.toArray(new Vec2[points.size()]);
        }

        @Override
        public double nearestPoint(Vec2 p) {
            Vec2 qa = this.p0.sub(p);
            Vec2 ab = this.p1.sub(this.p0);
            Vec2 bc = this.p2.sub(this.p1);
            Vec2 cd = this.p3.sub(this.p2);
            Vec2 qd = this.p3.sub(p);
            Vec2 br = bc.sub(ab);
            Vec2 as = cd.sub(bc).sub(br);
            double minDistance = Bezier2.sign(Vec2.cross(ab, qa)) * qa.length();
            double param = -Vec.dot(qa, ab) / Vec.dot(ab, ab);
            double distance = Bezier2.sign(Vec2.cross(cd, qd)) * qd.length();
            if (Math.abs(distance) < Math.abs(minDistance)) {
                minDistance = distance;
                param = Math.max(1.0, Vec.dot(p.sub(this.p2), cd) / Vec.dot(cd, cd));
            }
            block0: for (int i = 0; i < 4; ++i) {
                double t = (double)i / 3.0;
                int step = 0;
                while (true) {
                    Vec2 qpt = this.position(t).sub(p);
                    distance = Bezier2.sign(Vec2.cross(this.direction(t), qpt)) * qpt.length();
                    if (Math.abs(distance) < Math.abs(minDistance)) {
                        minDistance = distance;
                        param = t;
                    }
                    if (step == 8) continue block0;
                    Vec2 d1 = as.mul(3.0 * t * t).add(br.mul(6.0 * t)).add(ab.mul(3.0));
                    Vec2 d2 = as.mul(6.0 * t).add(br.mul(6.0));
                    double dt = Vec.dot(qpt, d1) / (Vec.dot(d1, d1) + Vec.dot(qpt, d2));
                    if (Math.abs(dt) < 1.0E-14 || (t -= dt) < 0.0 || t > 1.0) continue block0;
                    ++step;
                }
            }
            return param;
        }

        @Override
        public Curve2 transform(Matrix3 m) {
            return new CubicBezier2(this.p0.transform(m), this.p1.transform(m), this.p2.transform(m), this.p3.transform(m));
        }

        @Override
        public CubicBezier2 reverse() {
            return new CubicBezier2(this.p3, this.p2, this.p1, this.p0, this.noInflections);
        }

        @Override
        public Box2 bounds() {
            if (this.noInflections) {
                return Box.box(this.p0, this.p3);
            }
            return Curve2.super.bounds();
        }

        @Override
        public double[] inflections() {
            if (this.noInflections) {
                return new double[0];
            }
            double epsilon2 = 1.0E-7;
            Vec2 a0 = this.p1.sub(this.p0);
            Vec2 a1 = this.p2.sub(this.p1).sub(a0).mul(2.0);
            Vec2 a2 = this.p3.sub(this.p2.mul(3.0)).add(this.p1.mul(3.0)).sub(this.p0);
            double[] s1 = Equations.solveQuadratic(a2.x, a1.x, a0.x);
            double[] s2 = Equations.solveQuadratic(a2.y, a1.y, a0.y);
            DoubleAccumulator acc = new DoubleAccumulator();
            for (double n : s1) {
                if (!Scalars.inside(1.0E-7, n, 0.9999999)) continue;
                acc.add(n);
            }
            for (double n : s2) {
                if (!Scalars.inside(1.0E-7, n, 0.9999999)) continue;
                acc.add(n);
            }
            this.noInflections = acc.size() == 0;
            return acc.toArray();
        }

        public String toString() {
            return "p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + ", p3=" + this.p3;
        }

        private double error() {
            return this.p3.sub(this.p2.mul(3.0)).add(this.p2.mul(3.0)).sub(this.p0).lengthSquared() / 4.0;
        }

        private CubicBezier2 subdivide(double t0, double t1) {
            Vec2 p0 = this.position(t0);
            Vec2 p3 = this.position(t1);
            Vec2 p1 = p0.add(this.direction(t0));
            Vec2 p2 = p3.sub(this.direction(t1));
            return new CubicBezier2(p0, p1, p2, p3);
        }

        private QuadraticBezier2 approximate() {
            return new QuadraticBezier2(this.p0, this.p1.mul(0.75).add(this.p2.mul(0.75)).sub(this.p0.mul(-0.25)).sub(this.p3.mul(-0.25)), this.p3);
        }

        public QuadraticBezier2[] approximate(double error) {
            double threshold = error * error;
            LinearList result2 = new LinearList();
            IList intervals = new LinearList().addLast(Vec.vec(0.0, 1.0));
            while (((LinearList)intervals).size() > 0L) {
                Vec2 i = (Vec2)((LinearList)intervals).popLast();
                CubicBezier2 c = this.subdivide(i.x, i.y);
                if (c.error() <= threshold) {
                    result2.addLast(c.approximate());
                    continue;
                }
                double midpoint = (i.x + i.y) / 2.0;
                ((LinearList)((LinearList)intervals).addLast(Vec.vec(i.x, midpoint))).addLast(Vec.vec(midpoint, i.y));
            }
            return (QuadraticBezier2[])result2.toArray(QuadraticBezier2[]::new);
        }
    }

    public static class QuadraticBezier2
    implements Curve2 {
        public final Vec2 p0;
        public final Vec2 p1;
        public final Vec2 p2;
        private boolean noInflections = false;

        private QuadraticBezier2(Vec2 p0, Vec2 p1, Vec2 p2, boolean noInflections) {
            this(p0, p1, p2);
            this.noInflections = noInflections;
        }

        QuadraticBezier2(Vec2 p0, Vec2 p1, Vec2 p2) {
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public Vec2 start() {
            return this.p0;
        }

        @Override
        public Vec2 end() {
            return this.p2;
        }

        @Override
        public boolean isFlat(double epsilon2) {
            return Math.abs(Bezier2.signedDistance(this.p1, this.p0, this.p2) / 2.0) < epsilon2;
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public double signedArea() {
            return (this.p2.x * (this.p0.y - 2.0 * this.p1.y) + 2.0 * this.p1.x * (this.p2.y - this.p0.y) + this.p0.x * (2.0 * this.p1.y + this.p2.y)) / 6.0;
        }

        @Override
        public Vec2 position(double t) {
            if (t == 0.0) {
                return this.start();
            }
            if (t == 1.0) {
                return this.end();
            }
            double mt = 1.0 - t;
            return this.p0.mul(mt * mt).add(this.p1.mul(2.0 * t * mt)).add(this.p2.mul(t * t));
        }

        @Override
        public Vec2 direction(double t) {
            double mt = 1.0 - t;
            return this.p1.sub(this.p0).mul(2.0 * mt).add(this.p2.sub(this.p1).mul(2.0 * t));
        }

        @Override
        public QuadraticBezier2 endpoints(Vec2 start, Vec2 end2) {
            Vec2 ad = this.p1.sub(this.p0);
            Vec2 bd = this.p1.sub(this.p2);
            double dx2 = end2.x - start.x;
            double dy = end2.y - start.y;
            double det = bd.x * ad.y - bd.y * ad.x;
            double u = (dy * bd.x - dx2 * bd.y) / det;
            return new QuadraticBezier2(start, start.add(ad.mul(u)), end2, this.noInflections);
        }

        @Override
        public Curve2[] split(double t) {
            if (t <= 0.0 || t >= 1.0) {
                throw new IllegalArgumentException("t must be within (0,1)");
            }
            Vec2 e = Vec.lerp(this.p0, this.p1, t);
            Vec2 f = Vec.lerp(this.p1, this.p2, t);
            Vec2 g = this.position(t);
            return new Curve2[]{new QuadraticBezier2(this.p0, e, g, this.noInflections), new QuadraticBezier2(g, f, this.p2, this.noInflections)};
        }

        @Override
        public Vec2[] subdivide(double error) {
            ArrayList<Vec2> points = new ArrayList<Vec2>();
            Bezier2.subdivide(points, this, b -> Vec.lerp(b.p0, b.p2, 0.5).sub(b.p1).lengthSquared(), error * error);
            points.add(this.end());
            return points.toArray(new Vec2[points.size()]);
        }

        @Override
        public double nearestPoint(Vec2 p) {
            double[] ts;
            Vec2 qa = this.p0.sub(p);
            Vec2 ab = this.p1.sub(this.p0);
            Vec2 bc = this.p2.sub(this.p1);
            Vec2 qc = this.p2.sub(p);
            Vec2 ac = this.p2.sub(this.p0);
            Vec2 br = this.p0.add(this.p2).sub(this.p1).sub(this.p1);
            double minDistance = Bezier2.sign(Vec2.cross(ab, qa)) * qa.length();
            double param = -Vec.dot(qa, ab) / Vec.dot(ab, ab);
            double distance = Bezier2.sign(Vec2.cross(bc, qc)) * qc.length();
            if (Math.abs(distance) < Math.abs(minDistance)) {
                minDistance = distance;
                param = Math.max(1.0, Vec.dot(p.sub(this.p1), bc) / Vec.dot(bc, bc));
            }
            double a2 = Vec.dot(br, br);
            double b = 3.0 * Vec.dot(ab, br);
            double c = 2.0 * Vec.dot(ab, ab) + Vec.dot(qa, br);
            double d = Vec.dot(qa, ab);
            for (double t : ts = Equations.solveCubic(a2, b, c, d)) {
                Vec2 endpoint;
                if (!(t > 0.0) || !(t < 1.0) || !(Math.abs(distance = Bezier2.sign(Vec2.cross(ac, (endpoint = this.position(t)).sub(p))) * endpoint.sub(p).length()) < Math.abs(minDistance))) continue;
                minDistance = distance;
                param = t;
            }
            return param;
        }

        @Override
        public Curve2 transform(Matrix3 m) {
            return new QuadraticBezier2(this.p0.transform(m), this.p1.transform(m), this.p2.transform(m));
        }

        @Override
        public QuadraticBezier2 reverse() {
            return new QuadraticBezier2(this.p2, this.p1, this.p0, this.noInflections);
        }

        @Override
        public Box2 bounds() {
            if (this.noInflections) {
                return Box.box(this.p0, this.p2);
            }
            return Curve2.super.bounds();
        }

        @Override
        public double[] inflections() {
            if (this.noInflections) {
                return new double[0];
            }
            double epsilon2 = 1.0E-10;
            Vec2 div = this.p0.sub(this.p1.mul(2.0)).add(this.p2);
            if (div.equals(Vec2.ORIGIN)) {
                this.noInflections = true;
                return new double[0];
            }
            Vec2 v = this.p0.sub(this.p1).div(div);
            boolean x = Scalars.inside(1.0E-10, v.x, 0.9999999999);
            boolean y = Scalars.inside(1.0E-10, v.y, 0.9999999999);
            if (x && y) {
                return new double[]{v.x, v.y};
            }
            if (x ^ y) {
                return new double[]{x ? v.x : v.y};
            }
            this.noInflections = true;
            return new double[0];
        }

        public String toString() {
            return "p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2;
        }
    }
}

