/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Box3;
import io.lacuna.artifex.Box4;
import io.lacuna.artifex.Interval;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.Vec4;
import io.lacuna.artifex.utils.Scalars;
import java.awt.geom.Rectangle2D;
import java.util.function.DoublePredicate;

public abstract class Box<T extends Vec<T>, U extends Box<T, U>> {
    private static final DoublePredicate POSITIVE = d -> d > 0.0;
    private static final DoublePredicate NOT_NEGATIVE = d -> d >= 0.0;

    public static Box2 from(Rectangle2D rect) {
        return new Box2(new Vec2(rect.getMinX(), rect.getMinY()), new Vec2(rect.getMaxX(), rect.getMaxY()));
    }

    public static Box2 box(Vec2 a2, Vec2 b) {
        return new Box2(a2, b);
    }

    public static Box2 box(Interval a2, Interval b) {
        return new Box2(Vec.vec(a2.lo, b.lo), Vec.vec(a2.hi, b.hi));
    }

    public static Box3 box(Vec3 a2, Vec3 b) {
        return new Box3(a2, b);
    }

    public static Box4 box(Vec4 a2, Vec4 b) {
        return new Box4(a2, b);
    }

    public abstract T lower();

    public abstract T upper();

    public abstract boolean isEmpty();

    protected abstract U construct(T var1, T var2);

    protected abstract U empty();

    public double distanceSquared(T point) {
        T l = this.lower().sub(point);
        T u = point.sub(this.upper());
        return u.zip(l, (a2, b) -> Scalars.max(0.0, a2, b)).lengthSquared();
    }

    public double distance(T point) {
        return Math.sqrt(this.distanceSquared(point));
    }

    public U union(U b) {
        if (this.isEmpty()) {
            return b;
        }
        if (((Box)b).isEmpty()) {
            return (U)this;
        }
        return this.construct(this.lower().zip(((Box)b).lower(), Math::min), this.upper().zip(((Box)b).upper(), Math::max));
    }

    public U union(T v) {
        if (this.isEmpty()) {
            return this.construct(v, v);
        }
        return this.construct(this.lower().zip(v, Math::min), this.upper().zip(v, Math::max));
    }

    public U intersection(U b) {
        if (this.isEmpty() || ((Box)b).isEmpty() || !this.intersects(b)) {
            return this.empty();
        }
        return this.construct(this.lower().zip(((Box)b).lower(), Math::max), this.upper().zip(((Box)b).upper(), Math::min));
    }

    public boolean intersects(U b) {
        if (this.isEmpty() || ((Box)b).isEmpty()) {
            return false;
        }
        return ((Box)b).upper().sub(this.lower()).every(NOT_NEGATIVE) && this.upper().sub(((Box)b).lower()).every(NOT_NEGATIVE);
    }

    public boolean contains(T v) {
        return v.sub(this.lower()).every(NOT_NEGATIVE) && this.upper().sub(v).every(NOT_NEGATIVE);
    }

    public Interval nth(int idx) {
        return Interval.interval(this.lower().nth(idx), this.upper().nth(idx));
    }

    public T clamp(T v) {
        return v.zip(this.lower(), Math::max).zip(this.upper(), Math::min);
    }

    public T size() {
        return this.upper().sub(this.lower());
    }

    public T normalize(T v) {
        return v.sub(this.lower()).div(this.size());
    }

    public T lerp(double t) {
        return this.lower().add(this.size().mul(t));
    }

    public T lerp(T v) {
        return this.lower().add(this.size().mul(v));
    }

    public U translate(T v) {
        return this.construct(this.lower().add(v), this.upper().add(v));
    }

    public U scale(T v) {
        return this.construct(this.lower().mul(v), this.upper().mul(v));
    }

    public U expand(double t) {
        if (this.isEmpty()) {
            return (U)this;
        }
        Object nLower = this.lower().map(n -> n - t);
        Object nUpper = this.upper().map(n -> n + t);
        return nUpper.sub(nLower).every(NOT_NEGATIVE) ? this.construct(nLower, nUpper) : this.empty();
    }

    public U expand(T v) {
        if (this.isEmpty()) {
            return (U)this;
        }
        T nLower = this.lower().sub(v);
        T nUpper = this.upper().add(v);
        return nUpper.sub(nLower).every(NOT_NEGATIVE) ? this.construct(nLower, nUpper) : this.empty();
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return 31 * this.lower().hashCode() ^ this.upper().hashCode();
    }

    public static <T extends Vec<T>, U extends Box<T, U>> boolean equals(Box<T, U> a2, Box<T, U> b, double epsilon2) {
        return Vec.equals(a2.lower(), b.lower(), epsilon2) && Vec.equals(a2.upper(), b.upper(), epsilon2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Box) {
            Box b = (Box)obj;
            if (this.isEmpty()) {
                return b.isEmpty();
            }
            return this.lower().equals(b.lower()) && this.upper().equals(b.upper());
        }
        return false;
    }

    public String toString() {
        return "[" + this.lower() + ", " + this.upper() + "]";
    }
}

