/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Interval;
import io.lacuna.artifex.Matrix3;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.utils.Intersections;
import java.util.Arrays;

public interface Curve2 {
    public Vec2 position(double var1);

    public double signedArea();

    public double length();

    default public Vec2 start() {
        return this.position(0.0);
    }

    default public Vec2 end() {
        return this.position(1.0);
    }

    public Curve2 endpoints(Vec2 var1, Vec2 var2);

    public Vec2 direction(double var1);

    public Curve2[] split(double var1);

    public boolean isFlat(double var1);

    default public Curve2 range(Interval interval) {
        return this.range(interval.lo, interval.hi);
    }

    default public Curve2 range(double tMin, double tMax) {
        if (tMin == tMax) {
            throw new IllegalArgumentException("range must be non-zero");
        }
        if (tMax < tMin) {
            throw new IllegalArgumentException("tMin must be less than tMax");
        }
        if (tMin == 0.0 && tMax == 1.0) {
            return this;
        }
        if (tMin == 0.0) {
            return this.split(tMax)[0];
        }
        if (tMax == 1.0) {
            return this.split(tMin)[1];
        }
        return this.split(tMin)[1].split((tMax - tMin) / (1.0 - tMin))[0].endpoints(this.position(tMin), this.position(tMax));
    }

    default public Curve2[] split(double[] ts) {
        if (ts.length == 0) {
            return new Curve2[]{this};
        }
        ts = (double[])ts.clone();
        Arrays.sort(ts);
        int offset2 = ts[0] == 0.0 ? 1 : 0;
        int len = ts.length - offset2 - (ts[ts.length - 1] == 1.0 ? 1 : 0);
        System.arraycopy(ts, offset2, ts, 0, len);
        if (len == 0) {
            return new Curve2[]{this};
        }
        if (len == 1) {
            return this.split(ts[0]);
        }
        Curve2[] result2 = new Curve2[len + 1];
        result2[0] = this.range(0.0, ts[0]);
        for (int i = 0; i < len - 1; ++i) {
            result2[i + 1] = this.range(ts[i], ts[i + 1]);
        }
        result2[len] = this.range(ts[len - 1], 1.0);
        return result2;
    }

    public double nearestPoint(Vec2 var1);

    default public Box2 bounds() {
        Box2 bounds = Box.box(this.start(), this.end());
        for (double t : this.inflections()) {
            bounds = (Box2)bounds.union(this.position(t));
        }
        return bounds;
    }

    public Vec2[] subdivide(double var1);

    public Curve2 transform(Matrix3 var1);

    public Curve2 reverse();

    public double[] inflections();

    default public Vec2[] intersections(Curve2 c) {
        return Intersections.intersections(this, c);
    }
}

