/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.utils.Bits;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinearList<V>
implements IList<V>,
Cloneable {
    private static final int DEFAULT_CAPACITY = 4;
    private Object[] elements;
    private int mask;
    private int size;
    private int offset;
    private int hash = -1;

    public static <V> LinearList<V> of(V ... elements) {
        LinearList<V> list = new LinearList<V>(elements.length);
        for (V e : elements) {
            list.addLast((Object)e);
        }
        return list;
    }

    public static <V> LinearList<V> from(Collection<V> collection) {
        return collection.stream().collect(Lists.linearCollector(collection.size()));
    }

    public static <V> LinearList<V> from(Iterable<V> iterable) {
        return LinearList.from(iterable.iterator());
    }

    public static <V> LinearList<V> from(Iterator<V> iterator2) {
        LinearList<V> list = new LinearList<V>();
        iterator2.forEachRemaining(object -> this.addLast(object));
        return list;
    }

    public static <V> LinearList<V> from(IList<V> list) {
        if (list.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("LinearList cannot hold more than 1 << 30 entries");
        }
        if (list instanceof LinearList) {
            return ((LinearList)list).clone();
        }
        return list.stream().collect(Lists.linearCollector((int)list.size()));
    }

    public LinearList() {
        this(4);
    }

    public LinearList(int capacity) {
        this(0, new Object[Math.max(1, 1 << Bits.log2Ceil(capacity))]);
    }

    private LinearList(int size, Object[] elements) {
        this.size = size;
        this.offset = 0;
        this.mask = elements.length - 1;
        this.elements = elements;
    }

    private void resize(int newCapacity) {
        Object[] nElements = new Object[newCapacity];
        int truncatedSize = Math.min(this.size, this.elements.length - this.offset);
        System.arraycopy(this.elements, this.offset, nElements, 0, truncatedSize);
        if (this.size != truncatedSize) {
            System.arraycopy(this.elements, 0, nElements, truncatedSize, this.size - truncatedSize);
        }
        this.mask = nElements.length - 1;
        this.elements = nElements;
        this.offset = 0;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public LinearList<V> addLast(V value2) {
        if (this.size == this.elements.length) {
            this.resize(this.size << 1);
        }
        this.elements[this.offset + this.size++ & this.mask] = value2;
        this.hash = -1;
        return this;
    }

    @Override
    public LinearList<V> addFirst(V value2) {
        if (this.size == this.elements.length) {
            this.resize(this.size << 1);
        }
        this.offset = this.offset - 1 & this.mask;
        this.elements[this.offset] = value2;
        ++this.size;
        this.hash = -1;
        return this;
    }

    @Override
    public LinearList<V> removeFirst() {
        if (this.size == 0) {
            return this;
        }
        this.offset = this.offset + 1 & this.mask;
        --this.size;
        this.hash = -1;
        return this;
    }

    @Override
    public LinearList<V> removeLast() {
        if (this.size == 0) {
            return this;
        }
        this.elements[this.offset + --this.size & this.mask] = null;
        this.hash = -1;
        return this;
    }

    public LinearList<V> clear() {
        Arrays.fill(this.elements, null);
        this.offset = 0;
        this.size = 0;
        this.hash = -1;
        return this;
    }

    @Override
    public LinearList<V> set(long idx, V value2) {
        if (idx == (long)this.size) {
            return this.addLast((Object)value2);
        }
        if (idx > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        this.elements[this.offset + (int)idx & this.mask] = value2;
        this.hash = -1;
        return this;
    }

    LinearList<V> linearConcat(IList<V> l) {
        long newSize = this.size() + l.size();
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("cannot hold more than 1 << 31 entries");
        }
        if (l instanceof LinearList) {
            LinearList list = (LinearList)l;
            if (this.offset != 0 || newSize > (long)this.elements.length) {
                this.resize(1 << Bits.log2Ceil(newSize));
            }
            int truncatedListSize = Math.min(list.size, list.elements.length - list.offset);
            System.arraycopy(list.elements, list.offset, this.elements, this.size, truncatedListSize);
            if (list.size != truncatedListSize) {
                System.arraycopy(list.elements, 0, this.elements, this.size + truncatedListSize, list.size - truncatedListSize);
            }
            this.size = (int)((long)this.size + list.size());
            this.hash = -1;
        } else {
            for (V e : l) {
                this.addLast((Object)e);
            }
        }
        return this;
    }

    @Override
    public V nth(long idx) {
        if (idx < 0L || idx >= (long)this.size) {
            throw new IndexOutOfBoundsException(idx + " must be within [0," + this.size + ")");
        }
        return (V)this.elements[this.offset + (int)idx & this.mask];
    }

    public V popFirst() {
        Object val = this.first();
        this.removeFirst();
        return val;
    }

    public V popLast() {
        Object val = this.last();
        this.removeLast();
        return val;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            final int limit;
            int idx;
            {
                this.limit = LinearList.this.offset + LinearList.this.size;
                this.idx = LinearList.this.offset;
            }

            @Override
            public boolean hasNext() {
                return this.idx != this.limit;
            }

            @Override
            public V next() {
                if (this.idx == this.limit) {
                    throw new NoSuchElementException();
                }
                Object val = LinearList.this.elements[this.idx++ & LinearList.this.mask];
                return val;
            }
        };
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public IList<V> forked() {
        return new Lists.VirtualList(this);
    }

    @Override
    public IList<V> linear() {
        return this;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = (int)Lists.hash(this);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IList) {
            return Lists.equals(this, (IList)obj);
        }
        return false;
    }

    public String toString() {
        return Lists.toString(this);
    }

    @Override
    public LinearList<V> clone() {
        LinearList<V> l = new LinearList<V>(this.size, (Object[])this.elements.clone());
        l.offset = this.offset;
        return l;
    }
}

