/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

import io.lacuna.bifurcan.utils.BitVector;

public class BitIntSet {
    public static long[] create() {
        return BitVector.create(0);
    }

    public static long get(long[] set, int bitsPerElement, int idx) {
        return BitVector.get(set, idx * bitsPerElement, bitsPerElement);
    }

    public static int indexOf(long[] set, int bitsPerElement, int size, long val) {
        int low = 0;
        int high = size - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            long curr = BitIntSet.get(set, bitsPerElement, mid);
            if (curr < val) {
                low = mid + 1;
                continue;
            }
            if (curr > val) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static long[] add(long[] set, int bitsPerElement, int size, long val) {
        int idx = BitIntSet.indexOf(set, bitsPerElement, size, val);
        if (idx < 0) {
            idx = -idx - 1;
            return BitVector.insert(set, bitsPerElement * size, val, bitsPerElement * idx, bitsPerElement);
        }
        return set;
    }

    public static long[] remove(long[] set, int bitsPerElement, int size, long val) {
        int idx = BitIntSet.indexOf(set, bitsPerElement, size, val);
        if (idx < 0) {
            return set;
        }
        return BitVector.remove(set, bitsPerElement * size, bitsPerElement * idx, bitsPerElement);
    }
}

