/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbrp_node")
public class STBRPNode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int NEXT;

    public STBRPNode(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), STBRPNode.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="stbrp_coord")
    public short x() {
        return STBRPNode.nx(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short y() {
        return STBRPNode.ny(this.address());
    }

    @Nullable
    @NativeType(value="stbrp_node *")
    public STBRPNode next() {
        return STBRPNode.nnext(this.address());
    }

    public static STBRPNode malloc() {
        return STBRPNode.wrap(STBRPNode.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static STBRPNode calloc() {
        return STBRPNode.wrap(STBRPNode.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static STBRPNode create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return STBRPNode.wrap(STBRPNode.class, MemoryUtil.memAddress(container), container);
    }

    public static STBRPNode create(long address) {
        return STBRPNode.wrap(STBRPNode.class, address);
    }

    @Nullable
    public static STBRPNode createSafe(long address) {
        return address == 0L ? null : STBRPNode.wrap(STBRPNode.class, address);
    }

    public static Buffer malloc(int capacity) {
        return STBRPNode.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(STBRPNode.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBRPNode.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = STBRPNode.__create(capacity, SIZEOF);
        return STBRPNode.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return STBRPNode.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : STBRPNode.wrap(Buffer.class, address, capacity);
    }

    public static STBRPNode mallocStack() {
        return STBRPNode.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPNode callocStack() {
        return STBRPNode.callocStack(MemoryStack.stackGet());
    }

    public static STBRPNode mallocStack(MemoryStack stack) {
        return STBRPNode.wrap(STBRPNode.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPNode callocStack(MemoryStack stack) {
        return STBRPNode.wrap(STBRPNode.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBRPNode.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBRPNode.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBRPNode.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBRPNode.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nx(long struct) {
        return UNSAFE.getShort(null, struct + (long)X);
    }

    public static short ny(long struct) {
        return UNSAFE.getShort(null, struct + (long)Y);
    }

    @Nullable
    public static STBRPNode nnext(long struct) {
        return STBRPNode.createSafe(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    static {
        Struct.Layout layout = STBRPNode.__struct(STBRPNode.__member(2), STBRPNode.__member(2), STBRPNode.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        NEXT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<STBRPNode, Buffer>
    implements NativeResource {
        private static final STBRPNode ELEMENT_FACTORY = STBRPNode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap2) {
            super(address, null, -1, 0, cap2, cap2);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap2) {
            super(address, container, mark, pos, lim, cap2);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected STBRPNode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="stbrp_coord")
        public short x() {
            return STBRPNode.nx(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short y() {
            return STBRPNode.ny(this.address());
        }

        @Nullable
        @NativeType(value="stbrp_node *")
        public STBRPNode next() {
            return STBRPNode.nnext(this.address());
        }
    }
}

