/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.internal.Driver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "width", "", "height", "contentScale", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "loadImage", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "fileOrUrl", "", "openrndr-core"})
public final class ColorBufferKt {
    @NotNull
    public static final ColorBuffer colorBuffer(int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type2, @NotNull BufferMultisample multisample2) {
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        Intrinsics.checkParameterIsNotNull(multisample2, "multisample");
        return Driver.Companion.getDriver().createColorBuffer(width, height, contentScale, format, type2, multisample2);
    }

    @NotNull
    public static /* synthetic */ ColorBuffer colorBuffer$default(int n, int n2, double d, ColorFormat colorFormat, ColorType colorType, BufferMultisample bufferMultisample, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n3 & 0x10) != 0) {
            colorType = ColorType.UINT8;
        }
        if ((n3 & 0x20) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        return ColorBufferKt.colorBuffer(n, n2, d, colorFormat, colorType, bufferMultisample);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull String fileOrUrl) {
        ColorBuffer colorBuffer;
        Intrinsics.checkParameterIsNotNull(fileOrUrl, "fileOrUrl");
        try {
            new URL(fileOrUrl);
            colorBuffer = ColorBuffer.Companion.fromUrl(fileOrUrl);
        }
        catch (MalformedURLException e) {
            colorBuffer = ColorBuffer.Companion.fromFile(fileOrUrl);
        }
        return colorBuffer;
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return ColorBuffer.Companion.fromFile(file);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        String string = url.toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string, "url.toExternalForm()");
        return ColorBuffer.Companion.fromUrl(string);
    }
}

