/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math.transforms;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Quaternion;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000fJ \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/math/transforms/TransformBuilder;", "", "()V", "transform", "Lorg/openrndr/math/Matrix44;", "getTransform", "()Lorg/openrndr/math/Matrix44;", "setTransform", "(Lorg/openrndr/math/Matrix44;)V", "multiply", "", "matrix", "rotate", "axis", "Lorg/openrndr/math/Quaternion;", "Lorg/openrndr/math/Vector3;", "degrees", "", "scale", "scaleX", "scaleY", "scaleZ", "translate", "x", "y", "z", "offset", "Lorg/openrndr/math/Vector2;", "openrndr-math"})
public final class TransformBuilder {
    @NotNull
    private Matrix44 transform = Matrix44.Companion.getIDENTITY();

    @NotNull
    public final Matrix44 getTransform() {
        return this.transform;
    }

    public final void setTransform(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.transform = matrix44;
    }

    public final void rotate(@NotNull Quaternion axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        this.transform = this.transform.times(axis.getMatrix());
    }

    public final void rotate(@NotNull Vector3 axis, double degrees) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        this.transform = this.transform.times(TransformsKt.rotate(axis, degrees));
    }

    public static /* synthetic */ void rotate$default(TransformBuilder transformBuilder, Vector3 vector3, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = Vector3.Companion.getUNIT_Z();
        }
        transformBuilder.rotate(vector3, d);
    }

    public final void translate(@NotNull Vector3 offset2) {
        Intrinsics.checkParameterIsNotNull(offset2, "offset");
        this.transform = this.transform.times(TransformsKt.translate(offset2));
    }

    public final void translate(@NotNull Vector2 offset2) {
        Intrinsics.checkParameterIsNotNull(offset2, "offset");
        this.transform = this.transform.times(TransformsKt.translate(offset2.getXy0()));
    }

    public final void translate(double x, double y, double z) {
        this.transform = this.transform.times(TransformsKt.translate(new Vector3(x, y, z)));
    }

    public static /* synthetic */ void translate$default(TransformBuilder transformBuilder, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        transformBuilder.translate(d, d2, d3);
    }

    public final void scale(double scale2) {
        this.transform = this.transform.times(TransformsKt.scale(scale2, scale2, scale2));
    }

    public final void scale(double scaleX, double scaleY, double scaleZ) {
        this.transform = this.transform.times(TransformsKt.scale(scaleX, scaleY, scaleZ));
    }

    public final void scale(@NotNull Vector3 scale2) {
        Intrinsics.checkParameterIsNotNull(scale2, "scale");
        this.transform = this.transform.times(TransformsKt.scale(scale2.getX(), scale2.getY(), scale2.getZ()));
    }

    public final void multiply(@NotNull Matrix44 matrix) {
        Intrinsics.checkParameterIsNotNull(matrix, "matrix");
        this.transform = this.transform.times(matrix);
    }
}

