/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.openrndr.math.Vector2;
import org.openrndr.svg.Command;
import org.openrndr.svg.SVGDocument;
import org.openrndr.svg.SVGGroup;
import org.openrndr.svg.SVGPath;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/svg/SVGLoader;", "", "()V", "handleCircle", "", "group", "Lorg/openrndr/svg/SVGGroup;", "e", "Lorg/jsoup/nodes/Element;", "handleEllipse", "handleGroup", "parent", "handleLine", "handlePath", "handlePolygon", "handlePolyline", "handleRectangle", "loadSVG", "Lorg/openrndr/svg/SVGDocument;", "svg", "", "openrndr-svg"})
public final class SVGLoader {
    @NotNull
    public final SVGDocument loadSVG(@NotNull String svg) {
        Intrinsics.checkParameterIsNotNull(svg, "svg");
        Document doc = Jsoup.parse(svg, "", Parser.xmlParser());
        Element root = doc.select("svg").first();
        String version = root.attr("version");
        SVGGroup rootGroup = new SVGGroup(null, 1, null);
        Element element = root;
        Intrinsics.checkExpressionValueIsNotNull(element, "root");
        this.handleGroup(rootGroup, element);
        return new SVGDocument(rootGroup);
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePolygon(SVGGroup group, Element e) {
        void $receiver$iv;
        SVGPath sVGPath;
        void $receiver$iv$iv;
        int n;
        Object element$iv$iv2;
        Object object;
        CharSequence charSequence;
        String it;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        String string = e.attr("points");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"points\")");
        Object object2 = string;
        Object object3 = "[ ,\n]+";
        object3 = new Regex((String)object3);
        int n2 = 0;
        object2 = ((Regex)object3).split((CharSequence)object2, n2);
        object3 = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            charSequence = it;
            void v1 = charSequence;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)v1)).toString();
            collection.add(object);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            it = (String)element$iv$iv2;
            n = 0;
            charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List tokens = (List)destination$iv$iv;
        Iterable $receiver$iv3 = RangesKt.until(0, tokens.size() / 2);
        destination$iv$iv = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            double d;
            void it2;
            int item$iv$iv;
            n = item$iv$iv = ((IntIterator)element$iv$iv2).nextInt();
            collection = destination$iv$iv2;
            boolean bl = false;
            String $i$f$filterTo = (String)tokens.get((int)(it2 * 2));
            double d2 = Double.parseDouble($i$f$filterTo);
            $i$f$filterTo = (String)tokens.get((int)(it2 * 2 + true));
            double d3 = d = Double.parseDouble($i$f$filterTo);
            double d4 = d2;
            object = new Vector2(d4, d3);
            collection.add(object);
        }
        List points = (List)destination$iv$iv2;
        SVGPath $receiver = sVGPath = new SVGPath();
        boolean bl = false;
        $receiver.setId(e.id());
        $receiver.parseDrawAttributes(e);
        $receiver.parseTransform(e);
        $receiver.getCommands().add(new Command("M", ((Vector2)points.get(0)).getX(), ((Vector2)points.get(0)).getY()));
        Iterable item$iv$iv = RangesKt.until(1, points.size());
        Collection destination$iv = $receiver.getCommands();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it3;
            int item$iv;
            int $i$f$filter = item$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv;
            boolean bl2 = false;
            Command command = new Command("L", ((Vector2)points.get((int)it3)).getX(), ((Vector2)points.get((int)it3)).getY());
            collection2.add(command);
        }
        $receiver.getCommands().add(new Command("Z", new double[0]));
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePolyline(SVGGroup group, Element e) {
        void $receiver$iv;
        SVGPath sVGPath;
        void $receiver$iv$iv;
        int n;
        Object element$iv$iv2;
        Object object;
        CharSequence charSequence;
        String it;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        String string = e.attr("points");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"points\")");
        Object object2 = string;
        Object object3 = "[ ,\n]+";
        object3 = new Regex((String)object3);
        int n2 = 0;
        object2 = ((Regex)object3).split((CharSequence)object2, n2);
        object3 = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            charSequence = it;
            void v1 = charSequence;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)v1)).toString();
            collection.add(object);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            it = (String)element$iv$iv2;
            n = 0;
            charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List tokens = (List)destination$iv$iv;
        Iterable $receiver$iv3 = RangesKt.until(0, tokens.size() / 2);
        destination$iv$iv = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            double d;
            void it2;
            int item$iv$iv;
            n = item$iv$iv = ((IntIterator)element$iv$iv2).nextInt();
            collection = destination$iv$iv2;
            boolean bl = false;
            String $i$f$filterTo = (String)tokens.get((int)(it2 * 2));
            double d2 = Double.parseDouble($i$f$filterTo);
            $i$f$filterTo = (String)tokens.get((int)(it2 * 2 + true));
            double d3 = d = Double.parseDouble($i$f$filterTo);
            double d4 = d2;
            object = new Vector2(d4, d3);
            collection.add(object);
        }
        List points = (List)destination$iv$iv2;
        SVGPath $receiver = sVGPath = new SVGPath();
        boolean bl = false;
        $receiver.setId(e.id());
        $receiver.parseDrawAttributes(e);
        $receiver.parseTransform(e);
        $receiver.getCommands().add(new Command("M", ((Vector2)points.get(0)).getX(), ((Vector2)points.get(0)).getY()));
        Iterable item$iv$iv = RangesKt.until(1, points.size());
        Collection destination$iv = $receiver.getCommands();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it3;
            int item$iv;
            int $i$f$filter = item$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv;
            boolean bl2 = false;
            Command command = new Command("L", ((Vector2)points.get((int)it3)).getX(), ((Vector2)points.get((int)it3)).getY());
            collection2.add(command);
        }
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    private final void handleGroup(SVGGroup parent, Element e) {
        SVGGroup sVGGroup;
        SVGGroup $receiver = sVGGroup = new SVGGroup(null, 1, null);
        boolean bl = false;
        $receiver.setId(e.id());
        $receiver.parseTransform(e);
        SVGGroup group = sVGGroup;
        parent.getElements().add(group);
        Elements elements = e.children();
        Intrinsics.checkExpressionValueIsNotNull(elements, "e.children()");
        Iterable $receiver$iv = elements;
        for (Object element$iv : $receiver$iv) {
            String string;
            Element c = (Element)element$iv;
            boolean bl2 = false;
            if (c.tagName() == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case 3433509: {
                    if (!string.equals("path")) break;
                    n = 1;
                    break;
                }
                case 3496420: {
                    if (!string.equals("rect")) break;
                    n = 2;
                    break;
                }
                case -397519558: {
                    if (!string.equals("polygon")) break;
                    n = 3;
                    break;
                }
                case 3321844: {
                    if (!string.equals("line")) break;
                    n = 4;
                    break;
                }
                case 103: {
                    if (!string.equals("g")) break;
                    n = 5;
                    break;
                }
                case -1656480802: {
                    if (!string.equals("ellipse")) break;
                    n = 6;
                    break;
                }
                case -1360216880: {
                    if (!string.equals("circle")) break;
                    n = 7;
                    break;
                }
                case 561938880: {
                    if (!string.equals("polyline")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 5: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handleGroup(group, element);
                    break;
                }
                case 1: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handlePath(group, element);
                    break;
                }
                case 4: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handleLine(group, element);
                    break;
                }
                case 2: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handleRectangle(group, element);
                    break;
                }
                case 6: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handleEllipse(group, element);
                    break;
                }
                case 7: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handleCircle(group, element);
                    break;
                }
                case 3: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handlePolygon(group, element);
                    break;
                }
                case 8: {
                    Element element = c;
                    Intrinsics.checkExpressionValueIsNotNull(element, "c");
                    this.handlePolyline(group, element);
                }
            }
        }
    }

    private final void handleEllipse(SVGGroup group, Element e) {
        double d;
        double d2;
        double d3;
        double d4;
        String string;
        String it = string = e.attr("cx");
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d4 = 0.0;
        } else {
            charSequence = it;
            d4 = Double.parseDouble((String)charSequence);
        }
        double x = d4;
        String it2 = bl = e.attr("cy");
        boolean bl2 = false;
        String string3 = it2;
        Intrinsics.checkExpressionValueIsNotNull(string3, "it");
        CharSequence charSequence2 = string3;
        if (charSequence2.length() == 0) {
            d3 = 0.0;
        } else {
            charSequence2 = it2;
            d3 = Double.parseDouble((String)charSequence2);
        }
        double y = d3;
        String it3 = bl2 = e.attr("rx");
        boolean bl3 = false;
        String string4 = it3;
        Intrinsics.checkExpressionValueIsNotNull(string4, "it");
        CharSequence charSequence3 = string4;
        if (charSequence3.length() == 0) {
            d2 = 0.0;
        } else {
            charSequence3 = it3;
            d2 = Double.parseDouble((String)charSequence3);
        }
        double width = d2 * 2.0;
        String it4 = bl3 = e.attr("ry");
        boolean bl4 = false;
        String string5 = it4;
        Intrinsics.checkExpressionValueIsNotNull(string5, "it");
        CharSequence charSequence4 = string5;
        if (charSequence4.length() == 0) {
            d = 0.0;
        } else {
            charSequence4 = it4;
            d = Double.parseDouble((String)charSequence4);
        }
        double height = d * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = (x -= width / (double)2) + width;
        double ye = (y -= height / (double)2) + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        SVGPath path = new SVGPath();
        path.setId(e.id());
        path.parseDrawAttributes(e);
        path.parseTransform(e);
        path.getCommands().add(new Command("M", x, ym));
        path.getCommands().add(new Command("C", x, ym - oy, xm - ox, y, xm, y));
        path.getCommands().add(new Command("C", xm + ox, y, xe, ym - oy, xe, ym));
        path.getCommands().add(new Command("C", xe, ym + oy, xm + ox, ye, xm, ye));
        path.getCommands().add(new Command("C", xm - ox, ye, x, ym + oy, x, ym));
        path.getCommands().add(new Command("z", new double[0]));
        group.getElements().add(path);
    }

    private final void handleCircle(SVGGroup group, Element e) {
        double d;
        double d2;
        double d3;
        double d4;
        String string;
        String it = string = e.attr("cx");
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d4 = 0.0;
        } else {
            charSequence = it;
            d4 = Double.parseDouble((String)charSequence);
        }
        double x = d4;
        String it2 = bl = e.attr("cy");
        boolean bl2 = false;
        String string3 = it2;
        Intrinsics.checkExpressionValueIsNotNull(string3, "it");
        CharSequence charSequence2 = string3;
        if (charSequence2.length() == 0) {
            d3 = 0.0;
        } else {
            charSequence2 = it2;
            d3 = Double.parseDouble((String)charSequence2);
        }
        double y = d3;
        String it3 = bl2 = e.attr("r");
        boolean bl3 = false;
        String string4 = it3;
        Intrinsics.checkExpressionValueIsNotNull(string4, "it");
        CharSequence charSequence3 = string4;
        if (charSequence3.length() == 0) {
            d2 = 0.0;
        } else {
            charSequence3 = it3;
            d2 = Double.parseDouble((String)charSequence3);
        }
        double width = d2 * 2.0;
        String it4 = bl3 = e.attr("r");
        boolean bl4 = false;
        String string5 = it4;
        Intrinsics.checkExpressionValueIsNotNull(string5, "it");
        CharSequence charSequence4 = string5;
        if (charSequence4.length() == 0) {
            d = 0.0;
        } else {
            charSequence4 = it4;
            d = Double.parseDouble((String)charSequence4);
        }
        double height = d * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = (x -= width / (double)2) + width;
        double ye = (y -= height / (double)2) + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        SVGPath path = new SVGPath();
        path.setId(e.id());
        path.parseDrawAttributes(e);
        path.parseTransform(e);
        path.getCommands().add(new Command("M", x, ym));
        path.getCommands().add(new Command("C", x, ym - oy, xm - ox, y, xm, y));
        path.getCommands().add(new Command("C", xm + ox, y, xe, ym - oy, xe, ym));
        path.getCommands().add(new Command("C", xe, ym + oy, xm + ox, ye, xm, ye));
        path.getCommands().add(new Command("C", xm - ox, ye, x, ym + oy, x, ym));
        path.getCommands().add(new Command("z", new double[0]));
        group.getElements().add(path);
    }

    private final void handleRectangle(SVGGroup group, Element e) {
        SVGPath sVGPath;
        double d;
        double d2;
        String string;
        String it = string = e.attr("x");
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d2 = 0.0;
        } else {
            charSequence = it;
            d2 = Double.parseDouble((String)charSequence);
        }
        double x = d2;
        String it2 = bl = e.attr("y");
        boolean $i$a$-let-SVGLoader$handleRectangle$y$22 = false;
        String string3 = it2;
        Intrinsics.checkExpressionValueIsNotNull(string3, "it");
        CharSequence charSequence2 = string3;
        if (charSequence2.length() == 0) {
            d = 0.0;
        } else {
            charSequence2 = it2;
            d = Double.parseDouble((String)charSequence2);
        }
        double y = d;
        String string4 = e.attr("width");
        Intrinsics.checkExpressionValueIsNotNull(string4, "e.attr(\"width\")");
        String $i$a$-let-SVGLoader$handleRectangle$y$22 = string4;
        double width = Double.parseDouble($i$a$-let-SVGLoader$handleRectangle$y$22);
        String string5 = e.attr("height");
        Intrinsics.checkExpressionValueIsNotNull(string5, "e.attr(\"height\")");
        String string6 = string5;
        double height = Double.parseDouble(string6);
        SVGPath $receiver = sVGPath = new SVGPath();
        boolean bl2 = false;
        $receiver.setId(e.id());
        $receiver.parseTransform(e);
        $receiver.parseDrawAttributes(e);
        $receiver.getCommands().add(new Command("M", x, y));
        $receiver.getCommands().add(new Command("h", width));
        $receiver.getCommands().add(new Command("v", height));
        $receiver.getCommands().add(new Command("h", -width));
        $receiver.getCommands().add(new Command("z", new double[0]));
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    private final void handleLine(SVGGroup group, Element e) {
        SVGPath sVGPath;
        String string = e.attr("x1");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"x1\")");
        String string2 = string;
        double x1 = Double.parseDouble(string2);
        String string3 = e.attr("x2");
        Intrinsics.checkExpressionValueIsNotNull(string3, "e.attr(\"x2\")");
        String string4 = string3;
        double x2 = Double.parseDouble(string4);
        String string5 = e.attr("y1");
        Intrinsics.checkExpressionValueIsNotNull(string5, "e.attr(\"y1\")");
        String string6 = string5;
        double y1 = Double.parseDouble(string6);
        String string7 = e.attr("y2");
        Intrinsics.checkExpressionValueIsNotNull(string7, "e.attr(\"y2\")");
        String string8 = string7;
        double y2 = Double.parseDouble(string8);
        SVGPath $receiver = sVGPath = new SVGPath();
        boolean bl = false;
        $receiver.parseDrawAttributes(e);
        $receiver.getCommands().add(new Command("M", x1, y1));
        $receiver.getCommands().add(new Command("L", x2, y2));
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    private final void handlePath(SVGGroup group, Element e) {
        SVGPath sVGPath;
        String string = e.attr("d");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"d\")");
        SVGPath $receiver = sVGPath = SVGPath.Companion.fromSVGPathString(string);
        boolean bl = false;
        $receiver.setId(e.id());
        $receiver.parseDrawAttributes(e);
        $receiver.parseTransform(e);
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }
}

