/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Color;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.shape.StrokeWeight;
import org.openrndr.shape.TextNode;
import org.openrndr.svg.VisitStage;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2,\u0010\u000f\u001a(\u0012\u0004\u0012\u00020\u000e\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\b\u0015H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u00020\f*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\n\u00a8\u0006\u001c"}, d2={"svg", "", "Lorg/openrndr/color/ColorRGBa;", "getSvg", "(Lorg/openrndr/color/ColorRGBa;)Ljava/lang/String;", "Lorg/openrndr/math/Matrix44;", "(Lorg/openrndr/math/Matrix44;)Ljava/lang/String;", "Lorg/openrndr/shape/Shape;", "(Lorg/openrndr/shape/Shape;)Ljava/lang/String;", "Lorg/openrndr/shape/ShapeContour;", "(Lorg/openrndr/shape/ShapeContour;)Ljava/lang/String;", "process", "", "compositionNode", "Lorg/openrndr/shape/CompositionNode;", "visitor", "Lkotlin/Function2;", "Lorg/openrndr/svg/VisitStage;", "Lkotlin/ParameterName;", "name", "stage", "Lkotlin/ExtensionFunctionType;", "writeSVG", "composition", "Lorg/openrndr/shape/Composition;", "saveToFile", "file", "Ljava/io/File;", "openrndr-svg"})
public final class SVGWriterKt {
    public static final void saveToFile(@NotNull Composition $receiver, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file, "file");
        if (!Intrinsics.areEqual(FilesKt.getExtension(file), "svg")) {
            throw (Throwable)new IllegalArgumentException("can only write svg files, the extension '" + FilesKt.getExtension(file) + "' is not supported");
        }
        String svg = SVGWriterKt.writeSVG($receiver);
        FilesKt.writeText$default(file, svg, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String writeSVG(@NotNull Composition composition2) {
        void textPathID;
        Intrinsics.checkParameterIsNotNull(composition2, "composition");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1 Tiny//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd\">\n");
        sb.append("<svg version=\"1.1\" baseProfile=\"tiny\" id=\"Layer_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"  x=\"0px\" y=\"0px\"\n width=\"2676px\" height=\"2048px\">");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        SVGWriterKt.process(composition2.getRoot(), (Function2<? super CompositionNode, ? super VisitStage, Unit>)new Function2<CompositionNode, VisitStage, Unit>(sb, (Ref.IntRef)textPathID){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ Ref.IntRef $textPathID;

            public final void invoke(@NotNull CompositionNode $receiver, @NotNull VisitStage it) {
                block13: {
                    block11: {
                        Object object;
                        block23: {
                            block21: {
                                block22: {
                                    Object object2;
                                    CompositionColor strokeAttribute2;
                                    CompositionNode compositionNode;
                                    block14: {
                                        Object object3;
                                        Object it2;
                                        String fillAttribute;
                                        block20: {
                                            block18: {
                                                block19: {
                                                    Object it3;
                                                    Object object4;
                                                    CompositionColor it4;
                                                    block17: {
                                                        block15: {
                                                            block16: {
                                                                Object object5;
                                                                CompositionColor compositionColor;
                                                                block12: {
                                                                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                                                                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), "it");
                                                                    if (it != VisitStage.PRE) break block11;
                                                                    compositionNode = $receiver;
                                                                    if (!(compositionNode instanceof GroupNode)) break block12;
                                                                    if ($receiver.getTransform() != Matrix44.Companion.getIDENTITY()) {
                                                                        this.$sb.append("<g transform=\"" + SVGWriterKt.access$getSvg$p($receiver.getTransform()) + "\">\n");
                                                                    } else {
                                                                        this.$sb.append("<g>\n");
                                                                    }
                                                                    break block13;
                                                                }
                                                                if (!(compositionNode instanceof ShapeNode)) break block14;
                                                                it4 = compositionColor = $receiver.getFill();
                                                                boolean bl = false;
                                                                if (!(it4 instanceof Color)) break block15;
                                                                object4 = ((Color)it4).getColor();
                                                                if (object4 == null) break block16;
                                                                it3 = object5 = object4;
                                                                boolean bl2 = false;
                                                                object4 = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it3) + '\"';
                                                                if (object4 != null) break block17;
                                                            }
                                                            object4 = "fill=\"none\"";
                                                            break block17;
                                                        }
                                                        object4 = "";
                                                    }
                                                    fillAttribute = object4;
                                                    it4 = $receiver.getStroke();
                                                    it2 = it4;
                                                    boolean bl = false;
                                                    if (!(it2 instanceof Color)) break block18;
                                                    object3 = ((Color)it2).getColor();
                                                    if (object3 == null) break block19;
                                                    Object it5 = it3 = object3;
                                                    boolean bl3 = false;
                                                    object3 = "stroke=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it5) + '\"';
                                                    if (object3 != null) break block20;
                                                }
                                                object3 = "stroke=\"none\"";
                                                break block20;
                                            }
                                            object3 = "";
                                        }
                                        String strokeAttribute2 = object3;
                                        Object it6 = it2 = $receiver.getStrokeWeight();
                                        boolean bl = false;
                                        String strokeWidthAttribute = it6 instanceof StrokeWeight ? "stroke-width=\"" + ((StrokeWeight)it6).getWeight() + '\"' : "";
                                        String pathAttribute = "d=\"" + SVGWriterKt.access$getSvg$p(((ShapeNode)$receiver).getShape()) + '\"';
                                        this.$sb.append("<path " + fillAttribute + ' ' + strokeAttribute2 + ' ' + strokeWidthAttribute + ' ' + pathAttribute + "/>\n");
                                        break block13;
                                    }
                                    if (!(compositionNode instanceof TextNode)) break block13;
                                    CompositionColor it7 = strokeAttribute2 = $receiver.getFill();
                                    boolean bl = false;
                                    if (!(it7 instanceof Color)) break block21;
                                    object = ((Color)it7).getColor();
                                    if (object == null) break block22;
                                    Object it8 = object2 = object;
                                    boolean bl4 = false;
                                    object = "fill=\"" + SVGWriterKt.access$getSvg$p((ColorRGBa)it8) + '\"';
                                    if (object != null) break block23;
                                }
                                object = "fill=\"none\"";
                                break block23;
                            }
                            object = "";
                        }
                        String fillAttribute = object;
                        ShapeContour contour2 = ((TextNode)$receiver).getContour();
                        if (contour2 == null) {
                            this.$sb.append("<text " + fillAttribute + '>' + ((TextNode)$receiver).getText() + "</text>");
                        } else {
                            this.$sb.append("<defs>");
                            this.$sb.append("<path id=\"text" + this.$textPathID.element + "\" d=\"" + SVGWriterKt.access$getSvg$p(contour2) + "\"/>");
                            this.$sb.append("</defs>");
                            this.$sb.append("<text " + fillAttribute + "><textPath href=\"#text" + this.$textPathID.element + "\">" + ((TextNode)$receiver).getText() + "</textPath></text>");
                            int n = this.$textPathID.element;
                            this.$textPathID.element = n + 1;
                        }
                        break block13;
                    }
                    CompositionNode compositionNode = $receiver;
                    if (compositionNode instanceof GroupNode) {
                        this.$sb.append("</g>\n");
                    }
                }
            }
            {
                this.$sb = stringBuilder;
                this.$textPathID = intRef;
                super(2);
            }
        });
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private static final String getSvg(@NotNull ColorRGBa $receiver) {
        int ir = (int)(RangesKt.coerceIn($receiver.getR(), 0.0, 1.0) * 255.0);
        int ig = (int)(RangesKt.coerceIn($receiver.getG(), 0.0, 1.0) * 255.0);
        int ib = (int)(RangesKt.coerceIn($receiver.getB(), 0.0, 1.0) * 255.0);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "#%02X%02x%02x";
        Object[] objectArray = new Object[]{ir, ig, ib};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
        return string2;
    }

    private static final String getSvg(@NotNull Matrix44 $receiver) {
        return "matrix(" + $receiver.getC0r0() + ", " + $receiver.getC0r1() + ", " + $receiver.getC1r0() + ", " + $receiver.getC1r1() + ", " + $receiver.getC3r0() + ", " + $receiver.getC3r1() + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(@NotNull Shape $receiver) {
        StringBuilder sb = new StringBuilder();
        Iterable $receiver$iv = $receiver.getContours();
        for (Object element$iv : $receiver$iv) {
            ShapeContour it = (ShapeContour)element$iv;
            boolean bl = false;
            Iterable $receiver$iv2 = it.getSegments();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                String string;
                void segment;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                Segment segment2 = (Segment)item$iv;
                int index = n2;
                boolean bl2 = false;
                if (index == 0) {
                    sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
                }
                switch (segment.getControl().length) {
                    case 1: {
                        string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    case 2: {
                        string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                        break;
                    }
                    default: {
                        string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    }
                }
                sb.append(string);
            }
            if (!it.getClosed()) continue;
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvg(@NotNull ShapeContour $receiver) {
        StringBuilder sb = new StringBuilder();
        Iterable $receiver$iv = $receiver.getSegments();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            String string;
            void segment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Segment segment2 = (Segment)item$iv;
            int index = n2;
            boolean bl = false;
            if (index == 0) {
                sb.append("M " + segment.getStart().getX() + ", " + segment.getStart().getY());
            }
            switch (segment.getControl().length) {
                case 1: {
                    string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    break;
                }
                case 2: {
                    string = "" + 'C' + segment.getControl()[0].getX() + ", " + segment.getControl()[0].getY() + ", " + segment.getControl()[1].getX() + ", " + segment.getControl()[1].getY() + ", " + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                    break;
                }
                default: {
                    string = "" + 'L' + segment.getEnd().getX() + ", " + segment.getEnd().getY();
                }
            }
            sb.append(string);
        }
        if ($receiver.getClosed()) {
            sb.append("Z ");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private static final void process(CompositionNode compositionNode, Function2<? super CompositionNode, ? super VisitStage, Unit> visitor2) {
        visitor2.invoke(compositionNode, VisitStage.PRE);
        if (compositionNode instanceof GroupNode) {
            Iterable $receiver$iv = ((GroupNode)compositionNode).getChildren();
            for (Object element$iv : $receiver$iv) {
                CompositionNode it = (CompositionNode)element$iv;
                boolean bl = false;
                SVGWriterKt.process(it, visitor2);
            }
        }
        visitor2.invoke(compositionNode, VisitStage.POST);
    }

    public static final /* synthetic */ String access$getSvg$p(Matrix44 $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }

    public static final /* synthetic */ String access$getSvg$p(ColorRGBa $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }

    public static final /* synthetic */ String access$getSvg$p(Shape $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }

    public static final /* synthetic */ String access$getSvg$p(ShapeContour $receiver) {
        return SVGWriterKt.getSvg($receiver);
    }
}

