#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;
//layout(triangle_strip, max_vertices = 24) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in int inInst[3];

//in vec3 instVel[3];
//in float instAge[3];
//in float instRec[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out vec4 posInst;
out vec4 randG;
out vec3 mirrorG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texDepth;

//layout(binding=0, offset=0) uniform atomic_uint ac;
//layout(binding=0, rgba32f) uniform image2D voxPosComp;
//layout(binding=1, rgba32f) uniform image2D voxNorComp;


layout(binding=0, rgba32f) uniform image2D pardexPos;
layout(binding=1, r32i) uniform iimage2D pardexOfs;


uniform float g_instLayer = 0.0;

uniform float g_voxelAreaSize;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

vec3 rotAroundAxis(vec3 vec, vec3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  vec3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}

vec3 cross(vec3 a, vec3 b) {
  vec3 r;
  r.x = a.y*b.z - a.z*b.y;
  r.y = a.z*b.x - a.x*b.z;
  r.z = a.x*b.y - a.y*b.x;
  return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}



uniform float g_voxelDim;

uniform vec4 g_cen;
uniform vec4 g_rot;
uniform vec4 g_rotDel;

uniform vec4 g_rotSingle = vec4(45.0, 13.0, 0.0, 0.0);
uniform float g_centroOfs = 0.0;
uniform vec4 g_centroAmpFreq = vec4(8.5, 1.3, 0.24, 0.143);
uniform float g_radRotDel = 0.0;
uniform float g_radDel = 0.0;

uniform float g_delOfs = 0.0;

uniform vec4 g_pos; // model matrix contains instanced model transform so this overall pos comes separated


uniform vec4 g_uvRandom;
uniform vec4 g_uvOfsRand;


uniform vec4 g_globalRot = vec4(0.0, 0.0, 0.0, 0.0); // .x: rotX, .y: rotY, .z: rotZ
uniform vec4 g_globalScale = vec4(1.0, 1.0, 1.0, 1.0);

uniform vec4 g_mirrorX = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorX on/off, .y: mirrorXPos, .z: mirrorXClip
uniform vec4 g_mirrorY = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorY on/off, .y: mirrorYPos, .z: mirrorYClip
uniform vec4 g_mirrorZ = vec4(0.0, 0.0, 0.0, 0.0); // .x: mirrorZ on/off, .y: mirrorZPos, .z: mirrorZClip

uniform vec4 g_circularCen = vec4(0.0, 0.0, 0.0, 0.0);
uniform vec4 g_circularDist = vec4(0.0, 0.0, 0.0, 0.0);
uniform vec4 g_circularRot = vec4(0.0, 0.0, 0.0, 0.0);


uniform float g_mode = 1.0;
// modes
// 0.0 normal
// 1.0 point to target from breakin center


ivec2 getTrip(int idt) {
    ivec2 triBufSize = imageSize(pardexPos)/2;
    ivec2 trip;
    trip.y = idt/triBufSize.x;
    trip.x = idt-trip.y*triBufSize.x;
   // trip.y = 0;
    return trip;
}

uniform float skip = 10.0f;
uniform float skipOfs = 0.0f;

void main(void) {

        vec3 controlBase = vec3(0.0);

 ivec2 triBufSize = imageSize(pardexPos)/2;

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);

        float vd2 = g_voxelDim*g_voxelDim;
        int vd3 = int(vd2*g_voxelDim);

           uint counter = uint(inInst[0]);

           float cf = float(counter)+g_delOfs;



           uint cy = counter/(vd3);
           uint cx = counter-uint(cy*vd3);
           ivec2 listCoord = ivec2(cx,cy);
           vec3 myInstPos = vec3(0.0);



          int qi = int(counter);
          int qio = int(float(imageLoad(pardexOfs, getTrip(qi)).x)*max(1.0, 1.0+skip)+skipOfs);
         //int qio = int(float(imageLoad(pardexOfs, getTrip(qi)).x)+skipOfs);

           myInstPos.xyz = imageLoad(pardexPos, getTrip(qio)).xyz;

         vec3 myInstDir = imageLoad(pardexPos, getTrip(qio)+ivec2(0, triBufSize.y)).xyz;


        float a1 = atanSafe(myInstDir.y, sqrt(dot(myInstDir.xz, myInstDir.xz)));

//myInstPos.x = 32.0*sin(cf);
//myInstPos.y = 32.0*cos(cf);
// myInstPos.z = 0.0;

         //  instG = myInstPos.x*1.0;
        float pMul = 2.0*3.141592/360.0;

        vec3 rot = ((g_rot).xyz)*pMul;

        rot.x += a1;

        float mirrorSX = 1.0;
        float mirrorSY = 1.0;
        float mirrorSZ = 1.0;

        float mirrorsOn = clamp(g_mirrorX.x, 0.0, 1.0)+clamp(g_mirrorY.x, 0.0, 1.0)+clamp(g_mirrorZ.x, 0.0, 1.0);
        int mirrorCount = 1+int(mirrorsOn*mirrorsOn);

        for (int mi = 0; mi < mirrorCount; mi++) {
            float fmi = float(mi);
            if (g_mirrorX.x > 0.5) { // x on
                mirrorSX = 1.0-fract(fmi*0.5)*4.0;
                if (g_mirrorY.x > 0.5) { // at least x & y on
                     mirrorSY = 1.0-fract(floor(fmi*0.5)*0.5)*4.0;
                    if (g_mirrorZ.x > 0.5) { // all x, y & z on
                        mirrorSZ = 1.0-fract(floor(floor(fmi*0.5)*0.5)*0.5)*4.0;
                    }
                } else {
                    if (g_mirrorZ.x > 0.5) { // x & z mirror
                        mirrorSZ = 1.0-fract(floor(fmi*0.5)*0.5)*4.0;
                    }
                }
            } else { // x off
                if (g_mirrorY.x > 0.5) { // y on
                    mirrorSY = 1.0-fract(fmi*0.5)*4.0;
                    if (g_mirrorZ.x > 0.5) { // also z on?
                        mirrorSZ = 1.0-fract(floor(fmi*0.5)*0.5)*4.0;
                    }
                } else { // only z mirror on?
                    if (g_mirrorZ.x > 0.5) {
                        mirrorSZ = 1.0-fract(fmi*0.5)*4.0;
                    }
                }
            }
            for (int i = 0; i < gl_in.length(); ++i) {
                    gl_Position = gl_in[i].gl_Position;

                    posInst = gl_Position+vec4(myInstPos, 1.0);
                    gl_Position = modelMatrix*gl_Position;
                    normalG = normal[i];
                    normalG = normalize((modelMatrix*(vec4(normalG, 0.0))).xyz);

                    posW = vec4(myInstPos, 1.0);
                //    posW.xyz -= g_cen.xyz;
                 //   posW.xyz += g_cen.xyz;

                    vec3 posMod = gl_Position.xyz;

                    posMod.xyz = rotateXY3(posMod.xyz, rot.x);
                    posMod.zxy = rotateXY3(posMod.zxy, rot.y);
                    posMod.yzx = rotateXY3(posMod.yzx, rot.z);


                    posW.xyz += posMod;


                    normalG.xyz = rotateXY3(normalG.xyz, rot.x);
                    normalG.zxy = rotateXY3(normalG.zxy, rot.y);
                    normalG.yzx = rotateXY3(normalG.yzx, rot.z);

                    posW = rotateYZ(posW, g_globalRot.x);
                    posW = rotateXZ(posW, g_globalRot.y);
                    posW = rotateXY(posW, g_globalRot.z);

                    posW.xyz *= g_globalScale.x;


                    posW.xyz += g_pos.xyz;

                    posW.xyz -= vec3(g_mirrorX.y, g_mirrorY.y, g_mirrorZ.y);
                    posW.x *= mirrorSX;
                    posW.y *= mirrorSY;
                    posW.z *= mirrorSZ;
                    posW.xyz += vec3(g_mirrorX.y, g_mirrorY.y, g_mirrorZ.y);

                    mirrorG = vec3(mirrorSX, mirrorSY, mirrorSZ);

                    normalG = rotateYZ3(normalG, g_globalRot.x);
                    normalG = rotateXZ3(normalG, g_globalRot.y);
                    normalG = rotateXY3(normalG, g_globalRot.z);

                    gl_Position = viewMatrix*(posW);

                    colorG = vec3(1.0);

                    gl_Position.xyz -= normal[i]*0.0;

                    float depu = 0.0;
                    vec3 ssNormal = vec3(0.0);

                    normalWSG = (vec4(normalG, 0.0)).xyz;
                    normalG = (viewMatrix * vec4(normalG, 0.0)).xyz;

                    gl_Position = projectionMatrix*gl_Position;

                    posG = gl_Position;

                    faceNormal += normal[i];
                    uvG = uv[i];
                    tangentG = tangent[i];

                 //   float inste = inInst[0];
                 float inste = qio;
                    randG.x = g_uvRandom.x*rand(vec2(inste*0.73, 0.5+inste*0.216));
                    randG.y = g_uvOfsRand.x*rand(vec2(inste*0.123, 0.25+inste*1.216));
                    randG.z = g_uvOfsRand.y*rand(vec2(inste*0.543, 0.65+inste*0.332));
                    randG.w = inste;

                    EmitVertex();
            }
            EndPrimitive();
        }
}
