#version 430

layout(binding=0) uniform sampler2D texPotCenters;
layout(binding=1) uniform sampler2D texPot;
layout(binding=2) uniform sampler2D texSurfNormals;

in vec3 posV[];
in vec2 uvV[];

out vec4 posG;
out vec2 uvG;
out float perG;
out vec3 normG;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}
vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}
vec3 rotateYZ3(vec3 p, float a) {
  return rotateYZ(vec4(p, 0.0), a).xyz;
}
vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


layout(points) in;
layout(triangle_strip, max_vertices = 18) out;
//layout(line_strip, max_vertices = 15) out;


layout(binding=0, offset=0) uniform atomic_uint ac;

 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=2) uniform sampler2D texEmit;

uniform float g_pikselos = 0.0;

uniform float g_partSize = 0.15;


uniform float g_smooths = 1.0;
uniform float g_spikes = 0.0;

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

uniform float surfGridRes2D;

// 3D grid size which is the same for width, height & depth
uniform float surfGridDim3D;

// 1.0 scale puts the surfGrid to xyz coords varying from
// -surfGridDim3D*0.5 to surfGridDim3D*0.5
uniform float surfGridScale = 1.0;

// ivec2 ts = textureSize(s, 0);
// return texelFetch(s, ivec2(c.x*ts.x, c.y*ts.y), 0);


// gl_FragCoord.x

vec3 getPos3D(vec2 tp) {
    tp = floor(tp);
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000
    vec3 pos3D = vec3(0.0);
    vec2 osa = tp/surfGridDim3D;
    vec2 cellXY = fract(osa)*surfGridDim3D;
    vec2 cellZ = floor(osa);
    float indZ = cellZ.x+cellZ.y*kb;
    pos3D = vec3(cellXY, indZ);
    return pos3D;
}

vec2 getPos2D(vec3 pos3D) {
    vec2 res;
    //pos3D = floor(pos3D);
   // pos3D.x += surfGridDim3D*0.5;
   // pos3D = floor(pos3D);
    float kb = surfGridRes2D/(surfGridDim3D); // 10 for example when dim3d is 100 and res2d is 1000
    res.xy = fract(pos3D.xy/(surfGridDim3D))*(surfGridDim3D);
    float osa = floor(pos3D.z)/kb;
    res.x += fract(osa)*(surfGridRes2D);
    res.y += floor(osa)*(surfGridDim3D);
   // res = floor(res);
    return res;
}

vec4 texture2D_(sampler2D s, vec2 p) {
 // return texelFetch(s, ivec2(p.x+0.0, p.y+0.0), 0);
  return texture2D(s, p/surfGridRes2D);
}

mat4 mvp;

vec3 faceNormal;

uniform float g_exploAmp;
uniform float g_exploFreq;
uniform float g_exploPos;

uniform float g_scaleY;
uniform float g_twistY;
uniform float g_twistOfsY;

vec4 move(vec4 p, int type) {
    float s = g_twistOfsY;
    float k = g_twistY;
    p = rotateXZ(p, (p.y+sin(g_twistOfsY+p.y))*k);
    p.y *= g_scaleY;
    if (type == 0) {
        float mw = 0.35;
        float mak = pow((clamp(sin(p.y*g_exploFreq+g_exploPos), 1.0-mw, 1.0)-(1.0-mw))/mw, 2.0);
        p.xyz-=faceNormal*mak*g_exploAmp;
    }
    return p;
}
vec4 moveV(vec4 p) {
    return move(p, 0);
}
vec3 moveN(vec3 p) {
    return move(vec4(p, 0.0), 1).xyz;
}

// choose triangulation of the quad so that the triangle
// division is done along the shorter diagonal
void emitQuad(vec4 p1, vec3 n1, vec2 uv1,
              vec4 p2, vec3 n2, vec2 uv2,
              vec4 p3, vec3 n3, vec2 uv3,
              vec4 p4, vec3 n4, vec2 uv4) {

    faceNormal = normalize(n1+n2+n3+n4);
    n1 = moveN(n1);
    n2 = moveN(n2);
    n3 = moveN(n3);
    n4 = moveN(n4);

    p1 = moveV(p1);
    p2 = moveV(p2);
    p3 = moveV(p3);
    p4 = moveV(p4);

    vec4 diag1 = p2-p3;
    vec4 diag2 = p4-p1;

    float diagLen1 = dot(diag1, diag1);
    float diagLen2 = dot(diag2, diag2);

    if (diagLen1 < diagLen2) {
        posG =  mvp*p1; gl_Position = posG;
        normG = n1;
        uvG = uv1;
        EmitVertex();

        posG =  mvp*p2; gl_Position = posG;
        normG = n2;
        uvG = uv2;
        EmitVertex();

        posG =  mvp*p3; gl_Position = posG;
        normG = n3;
        uvG = uv3;
        EmitVertex();

        posG =  mvp*p4; gl_Position = posG;
        normG = n4;
        uvG = uv4;
        EmitVertex();
    } else {
        posG =  mvp*p2; gl_Position = posG;
        normG = n2;
        uvG = uv2;
        EmitVertex();

        posG =  mvp*p1; gl_Position = posG;
        normG = n1;
        uvG = uv1;
        EmitVertex();

        posG =  mvp*p4; gl_Position = posG;
        normG = n4;
        uvG = uv4;
        EmitVertex();

        posG =  mvp*p3; gl_Position = posG;
        normG = n3;
        uvG = uv3;
        EmitVertex();
    }
    EndPrimitive();
}

void emitTri(vec4 p1, vec3 n1, vec2 uv1,
             vec4 p2, vec3 n2, vec2 uv2,
             vec4 p3, vec3 n3, vec2 uv3) {

    posG =  mvp*p1; gl_Position = posG;
    normG = n1;
    uvG = uv1;
    EmitVertex();

    posG =  mvp*p2; gl_Position = posG;
    normG = n2;
    uvG = uv2;
    EmitVertex();

    posG =  mvp*p3; gl_Position = posG;
    normG = n3;
    uvG = uv3;
    EmitVertex();

    EndPrimitive();
}



// emit nothing, quad or a triangle based on the thr values
// emit vertices only if their thr is bigger or equal to 0.0
void emitPrim(vec4 p1, vec3 n1, vec2 uv1, float thr1,
              vec4 p2, vec3 n2, vec2 uv2, float thr2,
              vec4 p3, vec3 n3, vec2 uv3, float thr3,
              vec4 p4, vec3 n4, vec2 uv4, float thr4) {

    p1.xyz *= 1.0/surfGridDim3D;
    p2.xyz *= 1.0/surfGridDim3D;
    p3.xyz *= 1.0/surfGridDim3D;
    p4.xyz *= 1.0/surfGridDim3D;

    float m = thr1*thr2*thr3*thr4;

    if (m>=0.0) { // either none, two or four negative values
        if (thr1>=0.0 && thr2>=0.0 && thr3>=0.0 && thr4>=0.0) {
          emitQuad(p1, n1, uv1, p2, n2, uv2, p3, n3, uv3, p4, n4, uv4);
        }
    } else { // either one or three negative values
        if (thr4<0.0 && thr1>=0.0 && thr2>=0.0 && thr3>=0.0) {
       //   emitTri(p1, n1, uv1, p2, n2, uv2, p3, n3, uv3);
        } else if (thr3<0.0 && thr1>=0.0 && thr2>=0.0 && thr4>=0.0) {
       //   emitTri(p1, n1, uv1, p2, n2, uv2, p4, n4, uv4);
        } else if (thr2<0.0 && thr1>=0.0 && thr3>=0.0 && thr4>=0.0) {
       //   emitTri(p1, n1, uv1, p3, n3, uv3, p4, n4, uv4);
        } else if (thr1<0.0 && thr2>=0.0 && thr3>=0.0 && thr4>=0.0) {
       //   emitTri(p2, n2, uv2, p3, n3, uv3, p4, n4, uv4);
        }

        // with three negative values we don't draw anything
    }
}

float potSphere(vec3 pos, vec3 cen, float rad) {
    pos-=cen;
    float res = rad-sqrt(dot(pos, pos));
    return res;
}

// from http://iquilezles.org/www/articles/distfunctions/distfunctions.htm
// big thanks IQ!!
float udBox(vec3 p, vec3 b) {
  return length(max(abs(p)-b,0.0));
}

float potentialFract(vec3 pos, float time) {
        return 0.5+0.5*0.333*(2.0*sin(floor(pos.x*1.15)*2.6+time*2.0+cos(pos.y*0.1))+
                              (cos(floor(pos.y*1.17)*3.5+time*3.0+sin(pos.x*0.1)))+
                              cos(tan(pos.z*1.13)*1.1+sin(pos.x*0.2)+time*1.5));
        return 0.5+0.5*0.333*(sin((pos.x*1.15)*4.6+time*2.0+cos(pos.y*0.1))+
                              (cos((pos.y*1.17)*3.5+time*3.0+sin(pos.x*0.1)))+
                              cos((pos.z*1.13)*1.1+sin(pos.x*0.2)+time*1.5));
}

float potential(vec3 pos, float time) {
        return 0.5+0.5*0.333*(sin((pos.x*1.15)*4.6+time*2.0+cos(pos.y*0.1))+
                              (cos((pos.y*1.17)*3.5+time*3.0+sin(pos.x*0.1)))+
                              cos((pos.z*1.13)*1.1+sin(pos.x*0.2)+time*1.5));
}



//float potFunc(vec3 p3D, vec3 pCen3D) {
//    //float pot = potentialFract(pos3D*0.075, g_time*0.50)*3.30;
//    float pot = potential(p3D*0.145, g_time*0.50)*5.30;
//    pot += (-potSphere(p3D-pCen3D, vec3(0.0), 32.0)*1.0);
//   //pot *= (potSphere(pos3D-posCen3D, vec3(0.0), 30.0)*1.15+0.60*udBox(pos3D-posCen3D, vec3(25.0)));
//   //  pot *= (0.5+udBox(pos3D-posCen3D, vec3(13.0)));
//    pot -= 0.750;
//    return pot;
//}

vec3 calcNormal(vec3 p3D) {
   vec3 posCen3D = vec3(surfGridDim3D*0.5);
   p3D += posCen3D; // because originally the potentials are calculated in 0...x range

   // from the potentials grid texture
   vec3 tz1 = texture2D(texSurfNormals, (getPos2D(floor(p3D+vec3(0.0)))+fract(p3D.xy))/surfGridRes2D).rgb;
   vec3 tz2 = texture2D(texSurfNormals, (getPos2D(floor(p3D+vec3(0.0))+vec3(0.0, 0.0, 1.0))+fract(p3D.xy))/surfGridRes2D).rgb;
   float zf = fract(p3D.z);
   vec3 res = normalize((1.0-zf)*tz1+tz2*zf);
   return tz1;

//   // or by cheating if potential is directly available ;)
//   float pv = potFunc(p3D, posCen3D);
//   float d = 1.0;
//   float px = potFunc(p3D+vec3(d, 0.0, 0.0), posCen3D);
//   float py = potFunc(p3D+vec3(0.0, d, 0.0), posCen3D);
//   float pz = potFunc(p3D+vec3(0.0, 0.0, d), posCen3D);
//   return vec3(px, py, pz)-vec3(pv);
}



void main(void) {
    if (gl_in.length()<1) {
        return;
    }

    if (gl_in.length()>1) {
        return;
    }

    mvp = projectionMatrix * modelViewMatrix;

    if (posV[0].z > surfGridDim3D-1.0) {
        return;
    }

    vec3 posP = (posV[0]+vec3(0.50));

    vec2 pos2D = getPos2D(posP);

    vec3 posCen = vec3(surfGridDim3D)*0.5;

    vec4 pos = vec4(posV[0]-posCen, 1.0);
    // pos.xyz *= 0.5;

    vec2 munUv = uvV[0];
    int primID = gl_PrimitiveIDIn;

    gl_PrimitiveID = gl_PrimitiveIDIn;

    vec4 pot = texture2D_(texPotCenters, pos2D);

    if (pot.x < 0.0) {
      return;
    }

    perG = 1.0;

    normG = vec3(0.0);

//    vec4 pv = texture2D_(texPot, pos2D);

    // float dg = 0.1;

    float de = 1.0;

    float drawThr = -1.0;
    vec4 po = vec4(-drawThr);

    pot -= po;

    vec3 p3_x = posP+vec3(de, 0.0, 0.0);
    vec2 p_x = getPos2D(p3_x);
    vec4 pot_x = texture2D_(texPotCenters, p_x)-po;
  //  vec4 pv_x = texture2D_(texPot, p_x);

    vec3 p3_y = posP+vec3(0.0, de, 0.0);
    vec2 p_y = getPos2D(p3_y);
    vec4 pot_y = texture2D_(texPotCenters, p_y)-po;
   // vec4 pv_y = texture2D_(texPot, p_y);

    vec3 p3_z = posP+vec3(0.0, 0.0, de);
    vec2 p_z = getPos2D(p3_z);
    vec4 pot_z = texture2D_(texPotCenters, p_z)-po;
  //  vec4 pv_z = texture2D_(texPot, p_z);

    vec3 p3_xy = posP+vec3(de, de, 0.0);
    vec2 p_xy = getPos2D(p3_xy);
    vec4 pot_xy = texture2D_(texPotCenters, p_xy)-po;

    vec3 p3_yz = posP+vec3(0.0, de, de);
    vec2 p_yz = getPos2D(p3_yz);
    vec4 pot_yz = texture2D_(texPotCenters, p_yz)-po;

    vec3 p3_xz = posP+vec3(de, 0.0, de);
    vec2 p_xz = getPos2D(p3_xz);
    vec4 pot_xz = texture2D_(texPotCenters, p_xz)-po;

    float d = 0.0;
    float km = g_smooths;
    float bs = surfGridScale*1.0;


    float explo = 0.0;

    vec4 p1, p2, p3, p4;

    p1 = pos+km*vec4(pot.xyz, 0.0);
    p2 = pos+vec4(bs, 0.0, 0.0, 0.0)+km*vec4(pot_x.xyz, 0.0);
    p3 = pos+vec4(0.0, bs, 0.0, 0.0)+km*vec4(pot_y.xyz, 0.0);
    p4 = pos+vec4(bs, bs, 0.0, 0.0)+km*vec4(pot_xy.xyz, 0.0);
    emitPrim(p1, // vertex1
             calcNormal(p1.xyz),
             vec2(0.0, 0.0),
             pot.x-drawThr,
             p2, // vertex2
             calcNormal(p2.xyz),
             vec2(1.0, 0.0),
             pot_x.x-drawThr,
             p3, // vertex3
             calcNormal(p3.xyz),
             vec2(0.0, 1.0),
             pot_y.x-drawThr,
             p4, // vertex4
             calcNormal(p4.xyz),
             vec2(1.0, 1.0),
             pot_xy.x-drawThr);

    p1 = pos+km*vec4(pot.xyz, 0.0);
    p2 = pos+vec4(0.0, bs, 0.0, 0.0)+km*vec4(pot_y.xyz, 0.0);
    p3 = pos+vec4(0.0, 0.0, bs, 0.0)+km*vec4(pot_z.xyz, 0.0);
    p4 = pos+vec4(0.0, bs, bs, 0.0)+km*vec4(pot_yz.xyz, 0.0);
    emitPrim(p1, // vertex1
             calcNormal(p1.xyz),
             vec2(0.0, 0.0),
             pot.x-drawThr,
             p2, // vertex2
             calcNormal(p2.xyz),
             vec2(1.0, 0.0),
             pot_y.x-drawThr,
             p3, // vertex3
             calcNormal(p3.xyz),
             vec2(0.0, 1.0),
             pot_z.x-drawThr,
             p4, // vertex4
             calcNormal(p4.xyz),
             vec2(1.0, 1.0),
             pot_yz.x-drawThr);

    p1 = pos+km*vec4(pot.xyz, 0.0);
    p2 = pos+vec4(bs, 0.0, 0.0, 0.0)+km*vec4(pot_x.xyz, 0.0);
    p3 = pos+vec4(0.0, 0.0, bs, 0.0)+km*vec4(pot_z.xyz, 0.0);
    p4 = pos+vec4(bs, 0.0, bs, 0.0)+km*vec4(pot_xz.xyz, 0.0);
    emitPrim(p1, // vertex1
             calcNormal(p1.xyz),
             vec2(0.0, 0.0),
             pot.x-drawThr,
             p2, // vertex2
             calcNormal(p2.xyz),
             vec2(1.0, 0.0),
             pot_x.x-drawThr,
             p3, // vertex3
             calcNormal(p3.xyz),
             vec2(0.0, 1.0),
             pot_z.x-drawThr,
             p4, // vertex4
             calcNormal(p4.xyz),
             vec2(1.0, 1.0),
             pot_xz.x-drawThr);

}
