/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.opengl.PShader;

public class reklaami
extends PApplet {
    final float FPS = 60.0f;
    final float SPEED = 120.0f;
    final String[] prices = new String[]{"99mk", "499mk", "15mk", "39mk", "69mk"};
    final String[] itemTexts = new String[]{"DUCK - WITH GLSL SUPPORT", "M\u00c4TIPILLI DELUXE - WHY WOULD YOU EAT M\u00c4TI WITH SPOON?", "SIBS - FAVOURITES: PEA SOUP, BOOZE AND JOHANNES", "KAMPAVIINA - BETTER WAY TO QUENCH YOUR THIRST", "PIXELFILE - NOT FOR FULLING VECTORS "};
    final String[] itemObjs = new String[]{"ducky.obj", "matipilli.obj", "10874_Chips_v1_L3.obj", "14042_750_mL_Wine_Bottle_r_v1_L3.obj", "viila.obj"};
    final String[] greets = new String[]{"REKLAAMI", "BY", "EIMINK", "RELEASED AT", "SKROLLIPARTY", "2019", "GREETS", "FLY OUT TO", "SKROLLI", "TEKOTUOTANTO", "WIDE LOAD", "PARAGUAY", "BYTERAPERS", "ADAPT", "CNCD", "FAIRLIGHT", "ASD", "VANHA\nMEDIAKUNTA", "QUADTRIP", "DEKADENCE", "DAMONES", "JUMALAUTA", "SCENESAT", "AND YOU!"};
    float now = 0.0f;
    float CANVAS_WIDTH = 1920.0f;
    float CANVAS_HEIGHT = 1080.0f;
    Moonlander moonlander;
    PFont font;
    PImage bubble;
    PImage overlay1;
    PImage nekola;
    PImage weekly;
    PShape[] itemShapes = new PShape[this.itemObjs.length];
    PGraphics bg;
    PShader bgShader;
    int x;
    String msg = "";

    public void settings() {
        boolean fullscreen = true;
        if (fullscreen) {
            this.fullScreen("processing.opengl.PGraphics3D");
        } else {
            this.size((int)this.CANVAS_WIDTH, (int)this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        }
    }

    public void setup() {
        this.font = this.createFont("VictorMono-Regular.ttf", 100.0f);
        this.bubble = this.loadImage("kupla.png");
        this.nekola = this.loadImage("warejako.png");
        this.weekly = this.loadImage("weeklydeals.png");
        int i = 0;
        while (i < this.itemShapes.length) {
            this.itemShapes[i] = this.loadShape(this.itemObjs[i]);
            ++i;
        }
        this.bg = this.createGraphics((int)this.CANVAS_WIDTH, (int)this.CANVAS_HEIGHT);
        this.bgShader = this.loadShader("voro.glsl");
        this.bgShader.set("iResolution", this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
        this.noCursor();
        int bpm = 120;
        int rowsPerBeat = 4;
        this.shader(this.bgShader);
        this.resetShader();
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"reklaami.mp3", (int)bpm, (int)rowsPerBeat);
        this.moonlander.start();
        int fps = 60;
        this.frameRate(fps);
    }

    public void drawText() {
        this.pushMatrix();
        this.fill(255.0f, 255.0f, 255.0f);
        this.textFont(this.font);
        this.msg = this.itemTexts[(int)this.moonlander.getValue("bubble:price")];
        this.x = (int)this.moonlander.getValue("scene:textx");
        int i = 0;
        while (i < this.msg.length()) {
            this.text(this.msg.charAt(i), this.x, 200.0f + 30.0f * reklaami.sin((float)((float)this.x / (2.0f * this.textWidth(this.msg.charAt(i))))));
            this.x = (int)((float)this.x + this.textWidth(this.msg.charAt(i)));
            ++i;
        }
        this.popMatrix();
    }

    public void drawSolidColorBGWithAlpha() {
        this.bg.beginDraw();
        this.bg.background((float)this.moonlander.getValue("bg:r"), (float)this.moonlander.getValue("bg:g"), (float)this.moonlander.getValue("bg:b"), (float)this.moonlander.getValue("bg:a"));
        this.bg.endDraw();
        this.image((PImage)this.bg, -this.bg.width / 2, -this.bg.height / 2);
    }

    public void drawBubble(String price, int x, int y, float zrot, float alpha) {
        this.pushMatrix();
        this.translate(x, y);
        this.rotateZ(reklaami.radians((float)zrot));
        this.tint(255, alpha);
        this.image(this.bubble, -this.bubble.width / 2, -this.bubble.height / 2);
        this.scale(1.5f);
        this.rotateZ(reklaami.radians((float)-14.0f));
        this.textFont(this.font);
        this.textAlign(3, 3);
        this.fill(0.0f, 0.0f, 0.0f, alpha);
        this.text(price, 0.0f, -30.0f);
        this.popMatrix();
    }

    public void drawGreet(String text, int x, int y, float zrot, float alpha) {
        this.pushMatrix();
        this.translate(x, y);
        this.rotateZ(reklaami.radians((float)zrot));
        this.tint(255, alpha);
        this.image(this.bubble, -this.bubble.width / 2, -this.bubble.height / 2);
        this.scale(1.0f);
        this.rotateZ(reklaami.radians((float)-14.0f));
        this.textFont(this.font);
        this.textAlign(3, 3);
        this.fill(0.0f, 0.0f, 0.0f, alpha);
        this.text(text, 0.0f, -30.0f);
        this.popMatrix();
    }

    public void draw3dProduct(int i) {
        if ((float)this.moonlander.getValue("product:scale") <= 0.0f) {
            return;
        }
        this.pushMatrix();
        this.translate((float)this.moonlander.getValue("product:x"), (float)this.moonlander.getValue("product:y"), (float)this.moonlander.getValue("product:z"));
        this.rotateX((float)Math.PI * (float)this.moonlander.getValue("product:xrot") / 180.0f);
        this.rotateY((float)Math.PI * (float)this.moonlander.getValue("product:yrot") / 180.0f);
        this.rotateZ((float)Math.PI * (float)this.moonlander.getValue("product:zrot") / 180.0f);
        this.scale((float)this.moonlander.getValue("product:scale"));
        this.shape(this.itemShapes[i]);
        this.popMatrix();
    }

    public void drawNekola() {
        this.tint(255, (float)this.moonlander.getValue("intro:na"));
        this.image(this.nekola, -this.nekola.width / 2, -this.nekola.height / 2);
    }

    public void drawWeekly() {
        this.tint(255, (float)this.moonlander.getValue("intro:wa"));
        this.image(this.weekly, -this.weekly.width / 2, -this.weekly.height / 2);
    }

    public void draw() {
        this.moonlander.update();
        this.now = (float)this.moonlander.getCurrentTime();
        if (this.now > 99.0f) {
            this.exit();
        }
        switch ((int)this.moonlander.getValue("scene:scene")) {
            case 0: {
                this.hint(2);
                this.shader(this.bgShader);
                this.rect(0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
                this.resetShader();
                this.bgShader.set("iTime", (float)this.moonlander.getCurrentTime());
                this.translate(this.width / 2, this.height / 2, 0.0f);
                this.scale((float)this.width / this.CANVAS_WIDTH, (float)this.height / this.CANVAS_HEIGHT, (float)this.width / this.CANVAS_WIDTH);
                this.drawSolidColorBGWithAlpha();
                this.drawNekola();
                this.drawWeekly();
                break;
            }
            case 1: {
                this.lights();
                this.hint(2);
                this.shader(this.bgShader);
                this.rect(0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
                this.resetShader();
                this.hint(-2);
                this.bgShader.set("iTime", this.now);
                this.translate(this.width / 2, this.height / 2, 0.0f);
                this.scale((float)this.width / this.CANVAS_WIDTH, (float)this.height / this.CANVAS_HEIGHT, (float)this.width / this.CANVAS_WIDTH);
                this.draw3dProduct((int)this.moonlander.getValue("bubble:price"));
                this.noLights();
                this.hint(2);
                this.drawBubble(this.prices[(int)this.moonlander.getValue("bubble:price")], (int)this.moonlander.getValue("bubble:x"), (int)this.moonlander.getValue("bubble:y"), (float)this.moonlander.getValue("bubble:zrot"), (float)this.moonlander.getValue("bubble:alpha"));
                this.drawText();
                break;
            }
            case 2: {
                this.background(0.0f, 0.0f, 0.0f);
                this.shader(this.bgShader);
                this.rect(0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
                this.resetShader();
                this.bgShader.set("iTime", this.now);
                this.translate(this.width / 2, this.height / 2, 0.0f);
                this.scale((float)this.width / this.CANVAS_WIDTH, (float)this.height / this.CANVAS_HEIGHT, (float)this.width / this.CANVAS_WIDTH);
                this.noLights();
                int i = this.greets.length;
                while (i > 0) {
                    this.drawGreet(this.greets[(int)this.moonlander.getValue("greets:index")], (int)(200.0f * reklaami.cos((float)(this.now + (float)(i * 25)))), (int)(200.0f * reklaami.sin((float)(this.now + (float)(i * 25)))), 0.0f, 200.0f);
                    --i;
                }
                break;
            }
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"reklaami"};
        if (passedArgs != null) {
            PApplet.main((String[])reklaami.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

