class fxlogo {  
  
  constructor(size, bg)
  {
      this.size = size;
      this.bg = bg;
      this.img = loadImage('assets/new order2.png');
      this.backimg = loadImage('assets/background.png');
  }
  
  linear_step(v, start, end) {
  let r = (v - start) / (end - start);
  return max(0, min(1, r));
}

// Acceleration curve, start quickly and slow down toward the end.
  accel(v, A, B, power) {
  let iv = 1 - v;
  v = 1 - pow(iv, power);
  return lerp(A, B, v)
}
  draw(demoTime, bg)
  {
      
  background(bg);
    
  let timer = millis() / 5;
  let t = millis() / 1500;
  

  noStroke();
  translate(0, 0, -1000);
  
  // triangles dans le fond
  push()
  for (let i = 0; i <= 50; i++) {
    if (timer > 30 * i) {
      push();
      noStroke();
      fill(255, 96,0);
      rotateZ(millis() / 12000 * (i/5))
      translate(0, 0, -10 * i);
      torus(29 * i, 3, 3, 2)
      pop();
    }
  }
  pop()

  // logo
  if (t < 10)
  {
    push()
    noStroke()
    let scaleStartTime = 1
    let scaleEndTime = 10
    let scaleStart = 0
    let scaleEnd = 10
    let accelerationSpeed = 1 // 1 = linear acceleration, 2 = quick, 3 = quicker, 4 = fast, ...   
    let p = this.linear_step(t, scaleStartTime, scaleEndTime);
    scale(max(0, this.accel(p, scaleStart, scaleEnd, accelerationSpeed)));
    texture(this.img);
    blendMode(MULTIPLY);
    plane(100, 100)    
    pop()
  }
  else
  {
    push()
    noStroke()
    let scaleStartTime = 10
    let scaleEndTime = 15
    let scaleStart = 10
    let scaleEnd = 600
    let accelerationSpeed = 1 // 1 = linear acceleration, 2 = quick, 3 = quicker, 4 = fast, ...   
    let p = this.linear_step(t, scaleStartTime, scaleEndTime);
    scale(max(0, this.accel(p, scaleStart, scaleEnd, accelerationSpeed)));
    texture(this.img);
    blendMode(MULTIPLY);
    plane(100, 100)    
    pop()
    }

  }
}
