#version 150

uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform vec3 spectrum;

uniform sampler2D prevFrame;
uniform sampler2D prevPass;

in VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} inData;

out vec4 fragColor;

float sat(float x) { return clamp(x, 0., 1.); }
float demix(float a, float b, float t) { return (t - a) / (b - a); }

void main(void)
{
    vec2 uv = inData.v_texcoord;
    vec3 col = uv.x + uv.x * sin((vec3(.0,.33,.67) + uv.y) * 6.28);
    fragColor = vec4(col, 1.0);

    float fade = mix(1., 0., smoothstep(3., 3.5, time));
    fragColor *= fade;
}
