uniform float iTime;
uniform vec2 iResolution;
uniform sampler2D texture;

float rand () {
    return fract(sin(iTime)*1e7);
}

float hash12(vec2 p){
	return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}

void main(void)
{

	vec2 uv = gl_FragCoord.xy / iResolution.xy;

    vec2 uvR = uv;
    vec2 uvB = uv;

    uvR.x = uv.x * 1.0 - rand() * -0.03 * 0.8;
    uvB.y = uv.y * 1.0 + rand() * 0.04 * 0.6;
    
    if(uv.y < rand() && uv.y > rand() -0.1 && sin(iTime) < 0.0)
    {
    	uv.x = (uv + 0.05 * rand()).x;
    }
    
    vec4 c;
    c.r = texture(texture, uvR).r;
    c.g = texture(texture, uv).g;
    c.b = texture(texture, uvB).b;
	
    float scanline = sin( uv.y * 1200.0 * rand())/30.0;
    float v = float(1)*.152;
    vec2 n = (gl_FragCoord.xy * v + iTime * 1500. + 50.0);
	c *= 1 - scanline - 0.1*hash12(n); 
    
    float vegDist = length(( 0.5 , 0.5 ) - uv);
    c *= 0.9 - vegDist * 0.6;

    gl_FragColor = c;
}