;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
; neonsky (redux+reprise) (lil 256b intro for Xenium 2019)
; small tribute to Neonsky by Ephidrena :)
; original design: loaderror
; original music: frequent
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Kallithea, Valti, Cracow
; some stable undocumented opcodes used here (lax, alr)
; https://xxl.atari.pl/sally-6502c/
; kudos to my fellow Agenda coders - Koala for some optimization tips, and Gorgh for tests on real HW!

FRMCNT	equ $80 ; on ZP
NOTECNT	equ $82 ; which note we are currently in (cap at 16, 0-15)
FRMBIT	equ $84 ; flipflop flag
BACKCOL	equ $85 ; flashing background
PROGR	equ $86	; delayed visual progress

RASTPOS	equ $90 ; rasters positions
RASTCOL equ $a0 ; rasters colors
RASTSIZ equ $b0 ; rasters sizes
;FLIPFLO	equ $d0 ; %10101010 pattern for randomization
; rasters data to be rendered
RASTAB	equ $3c00 ; 
RASTBW	equ $4100; initial monochrome rastab

WSYNC	equ $D40a
; original/initial DLIst $BC20
; hires DLI is $8f

;MYBASE	equ $6000 ; 2K boundary
MYBASE	equ $5000 ; 1K boundary

AUDF1	equ $D200
AUDC1	equ $D201
AUDF2	equ $D202
AUDC2	equ $D203
AUDF3	equ $D204
AUDC3	equ $D205
AUDF4	equ $D206
AUDC4	equ $D207
AUDCTL 	equ $D208 ;
SKCTL	equ $D20f;
VCOUNT	equ $D40B


	opt h+
		
	org $2ffb		
		
	;lda #>mybase
	;sta $D407; set PMBASE, needs to be at 1K boundary for double resoultuon and 2K boundary for single resolution sprites (Every line)
	lda #(2+1)
	sta PROGR
	tay
setsize:	
	sta $D008-1,y ; setup pmg0 size to x4	
	dey
	bne setsize

	sta SKCTL ; sound init
	sta $D01D ; GRACTL -set both players and missles

	; can we really skip it?
	;lda #%00101000 ; join channels 3+4, clock 3rd with 1.79MHz
	;sta AUDCTL

	; now disable OS	
	;lda #0 ; reuse 0 in y	       
	sty $d40e ;NMI off for the time of vector swap
	lda #$fe ; also used later as PMG pattern for blackbox	  
	sta $d301 ; OS off 
	
	;ldy #%01100000
	;sty AUDCTL ; sound init
	;lsr
	;sta $D01b ; GPRIOR, proper PMG priorities	
 
	 	
; populate black rectangle
	ldy #80
	sty $D407 ; as PMBASE, ok as its 1K boundary for double lines
	;lda #$ff ; reuse $fa above, and just properly offset pmgs	
blackbox:	
	sta mybase+512+24+256,y ; pmg1 
	sta mybase+512+24+128,y	; pmg2
	dey
	bne blackbox	 	

 	lda #%00001000 ; just player DMA, no screen
	sta $D400; DMACTL - 62 - single line, normal playfield
		 		
	;lda #%10101010 ; no longer needed, used FLIPFLO/LDA above
	;sta FLIPFLO ; flipflo pattern for color swap
	 	
frame:
		; wait for first line
		lax VCOUNT ; to be used as 0 in x below, to clean background
		bne frame
	
; render rasters each frame (from raster buffer)
		;ldy #0 ; nice, looks like we have 0 already here :)	
renderloop:
		;lda rastab,y
		lda rastbw,y
		sta $D01a ; nice, end to end background color, no frames		 			 	
		sta WSYNC		
		;lda #0
		;txa ; use the X=0 from the above
		lda BACKCOL
		sta rastab,y ; we can clean it already, w/o the loop :)
		iny
		bne renderloop					    	

; update/move raster bars each frame
		ldx #6
moverasters:
		inc RASTPOS-1,x
		inc RASTPOS-1+4,x
		dec RASTPOS-1+10,x
		dex 
		bne moverasters
				
; cast rasters	(after moved, to raster buffer)	
		;ldy #16
		ldy #15
		sty $D012
castrasters:
		ldx RASTSIZ-1,y
		beq skiprast ; if raster of 0 size, no need to render it
		lda RASTPOS-1,y		
		sta castraster+3 ; set it up below properly
		lda RASTCOL-1,y					
castraster:
		sbc #1 ; to get some nice gradient-like colors!		
		sta rastab,x		
		dex
		bne castraster
skiprast:		
		dey 
		bne castrasters	
		sty BACKCOL
; play sound:		
		;dec NOTELEN ; no need for that, we just use FRMCNT	
		lax FRMCNT
		;tax	
		and #%00111111 ; take up to 32	 
		;and #%00111111 ; take up to 32
		bne skipnotecnt ; increase note count 	
		inc NOTECNT
		lda #$08
		sta BACKCOL
skipnotecnt	
		sta AUDC4 ; joined channels 3+4, so push to 4th, for a nice 'beat line'		
		lsr					 	
		ora #%10100100 ; good, interesting, less background, more foreward, more complex		
		sta AUDC2
		lda NOTECNT
		alr #%00001111 ; illegal replacement
		tay
		;lda melody,y
		;lda colortab+1,y
		;sta AUDF3
		lda colortab+1,y
		sta AUDF2 ; lead line

; move PMGs around:
		;lda frmcnt
		txa
		;cmp #128
		;bcs skipeor
		bmi skipeor ; instead of above :P
		eor #$7f	 
skipeor:
		;and #%01111111
		;lsr ; /2 (so 0-63 max), pattern like \/
		alr #%01111111 	; what a nice illegal, 1 byte shaved of the above 2 lines
		       		; and accu with byte and lsr	
	 	adc #155
 		sta $D001 ; bbox_left
 		adc #10
 		sta $D000 ; white pattern
 		;lda #170
		adc #10
 		sta $D002 ; bbox_right

		;lda #15
 		;sta $d012 ; set PMG0 (credits) to white

		; randomize lines in 1st section
		ldx $D20a		
		inc rastbw,x
		
; decrease frmcnt (to randomize every 4s or so)
		dec FRMCNT 					
		bne skiprandomize
		dec PROGR
		bpl skiprandomize
			
; every 4.5s randomize rasters, credits, etc.			
; randomize credits
		ldy #60
		sty renderloop+2	
credits:
		;tya	; pot1, but looks better with tya
		eor $D20a
		sta mybase+512+24+10,y
		dey
		sta mybase+512+24+10,y
		dey
		dey
		dey
		bne credits
		
		 			
		
; find the offset in colors table, swap the palette depending on frmbit
		lda frmbit ; loads frmbit to accu and x reg, to set the current bank
		eor #8 ; preps frmbit for next frame (0->1, 1->0)
		sta frmbit
			
; randomize 16 rasters, their initial position, color, size		
		ldx #16 ; as its only possible to STA ZP,x		
proprand:
		lda $D20a; randomize initial rast position
		sta RASTPOS-1,x
		and #%00000111; get size (0-7)
		sta RASTSIZ-1,x
		;lda $D20a ; use a different rand for the color (than the size)
		txa ; just use the x-reg, instead of randomizing, indistinguishible, and we always get all colors
		;and #%00001110
		and #%0000111			
		adc frmbit ; 0 or 8, so even (blueish) or odd (redish) colors
		tay ; use for the color
		lda colortab+1, y 
		sta RASTCOL-1,x
		dex 
		bne proprand		
skiprandomize:
colortab:
melody:		
		jmp frame

; predefined nice (Neonsky like) raster color sets
;colortab  
			
		;dta b($25,$30,$2b,$39,$30,$1f,$1c,$2b); redish, used primarily for sound
		dta b($2b,$39,$30,$1f,$1c,$2b); redish, used primarily for sound, 1st two melody bytes (and color values) taken from proper org (and jmp frame)
		dta b($82,$86,$8a,$94,$98,$9c,$74,$aa) ; blueish 
		;dta b($22,$24,$2a,$34,$36,$3c,$ee,$1c) ; redish/yellow
		;dta b($82,$22,$86,$24,$8a,$2a,$94,$34,$98,$36,$9c,$3c,$74,$ee,$aa,$1c) ; interleaved sets, used with frmbit :P
		;dta b($82,$25,$86,$30,$8a,$2b,$94,$39,$98,$30,$9c,$1f,$74,$1c,$aa,$2b) ; interleaved sets, with music!
		;dta b($25,$82,$30,$86,$2b,$8a,$39,$94,$30,$98,$1f,$9c,$1c,$74,$2b,$aa) ; interleaved sets, with music reverse order
; old melody tables 
;melody		;dta b($5f,$7a,$6b,$92,$7a,$4d,$47,$6b); +1 octaves (7-8), distortion 12b
;melback	;dta b($12,$17,$14,$1b,$17,$0f,$0d,$14); 1-2 octaves
		;dta b($25,$30,$2b,$39,$30,$1f,$1c,$2b); 2-3 octaves, 12a ; good combination with ora #%10100000 above 
		;dta b($74,$92,$83,$ad,$92,$62,$56,$83); 2-3 octaves, 12b
		;dta b($48,$5b,$51,$6c,$5b,$3c,$35,$51); 4-5 octaves, 10b 
		 		
		run $2ffb		
				
		    	


  	
					