import QtQuick 2.3
Item {
    id: cornerButton
    signal buttonPressedMinus()
    signal buttonPressedPlus()

    property string buttonText
    property color buttonColor: "grey"

    width: rekti.width
    height: rekti.height+5
    Rectangle {
        anchors.top: parent.top
        anchors.right: parent.right
        width: 60
        height: 40

        id: rekti
        color: buttonColor
        Text {
            //anchors.centerIn: parent
            anchors.fill: parent

            width: rekti.width
            height: rekti.height
            color: "white"
            text: cornerButton.buttonText
            wrapMode: Text.WordWrap

            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
        }
    }

    Rectangle {
        anchors.left: rekti.left
        anchors.bottom: rekti.bottom
        border.width: 0
        border.color: "black"
        radius: 2

        width: 15
        height: 15
        color: "lightgrey"
        Text {
            anchors.fill: parent
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            text: "-"
        }
        MouseArea {
            anchors.fill: parent
            onPressedChanged: {
                if (pressed) {
                    console.log("pressed on minus :"+cornerButton.buttonText)
                    buttonPressedMinus();
                }
            }
        }
    }

    Rectangle {
        anchors.right: rekti.right
        anchors.bottom: rekti.bottom
        border.width: 0
        border.color: "black"
        radius: 2
        width: 15
        height: 15
        color: "lightgrey"
        Text {
            anchors.fill: parent
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            text: "+"
        }
        MouseArea {
            anchors.fill: parent
            onPressedChanged: {
                if (pressed) {
                    console.log("pressed on minus :"+cornerButton.buttonText)
                    buttonPressedPlus();
                }
            }
        }
    }

}

