import QtQuick 2.3
import AdaptDemoSystem 1.0

MouseArea {
    anchors.fill: parent
    property bool bRootLevel: false
    onPressedChanged: {
        if (pressed) {
            console.log("mouse pressed on:"+model.modelData.rocketNameStack)
            if (bRootLevel) {
                rocket.rocketWindowToForeground(model.modelData.rocketNameStack);

                // open in qt creator
                rocket.openFile(model.modelData.name, "fx/"+model.modelData.skeneName+"/Skene.qml");
            } else {
                rocket.findTrack(model.modelData.rocketNameStack);
            }

            if (model.modelData.details !== "") {
                console.log("opening file from MouseAreaOpenFile:"+resolvedFileName);
                var resolvedFileName = effects.resolveFileName(model.modelData.details, model.modelData.skeneName);
                effects.doOpenFile(model.modelData.name, resolvedFileName)
            }
        }
    }
}
