import QtQuick 2.4
import AdaptDemoSystem 1.0
import "./"
import "./_SharedQML"

GridView {
  property var texList
  property string title
  property int baseIndex: 0

  property bool rtTextures: false

  header: Text {
    id: headerText
    text: title
    color: "white"
  }

  cellWidth: 88
  cellHeight: 100

  anchors.left: parent.left
  anchors.leftMargin: 5

  width: parent.width
  height: contentHeight
  model: texList.length
  interactive: false
  delegate: Item {
    id: texItem
    width: 80
    height: 80+14
    Rectangle {
      anchors.fill: parent
      color: "black"
      border.width: 1
      border.color: "white"
    }

    Rectangle {
      anchors.fill: indexText
      color: "#444444"
      border.width: 1
      border.color: "white"
    }
    Text {
      id: indexText
      anchors.top: parent.top
      anchors.left: parent.left
      anchors.right: parent.right
      height: 14
      text: index+baseIndex
      color: "white"
      horizontalAlignment: Text.AlignHCenter
    }

    Image {
      id: texItemImage
      anchors.fill: parent
      anchors.topMargin: 14
      //source: !rtTextures ? "../images/"+texList[index] : ""
      source: "../images/"+texList[index]
      asynchronous: true
      onStatusChanged: {
        if (status === Image.Error) {
          nameText.visible = true
        }
        updateTexImagePositions();
        rocket.markUpdateFrequent();
      }
    }

    function updateTexImagePositions() {
      var gc = texItemImage.mapToItem(null, 0, 0);
      if (nameText.visible) {
        var texName = texList[index];
        if (texName.indexOf(".") === -1) {
          if (texThumbs === undefined) {
            texThumbs = {};
          }
          texThumbs[index+baseIndex] = { x: gc.x, y: gc.y+texViewFlick.contentY, texInd: index+baseIndex };
          //log("Rt tex:"+texName+" "+gc.x+","+gc.y)
        }
      }
    }

    onXChanged: {
      updateTexImagePositions();
    }
    onYChanged: {
      updateTexImagePositions();
    }

    Connections {
      target: texViewFlick
      onContentYChanged: {
        updateTexImagePositions();
      }
    }

    Text {
      id: nameText
      visible: false
      anchors.fill: parent
      anchors.margins: 4
      text: texList[index]
      verticalAlignment: Text.AlignVCenter
      horizontalAlignment: Text.AlignHCenter
      color: "white"
      wrapMode: Text.Wrap
    }

    MouseArea {
      anchors.fill: parent
      onClicked: {
//        var gc = texItemImage.mapToItem(null, 0, 0)
//        log("clicked tex:"+texList[index]+" "+gc.x+","+gc.y)
        log("clicked tex:"+texList[index])

        applyTexPreview("texView.texInd", index+baseIndex)
      }
    }

//          DrawRT {
//            visible: bDebugTexts
//            enabled: bDebugTexts
//            textureItem: debugTexts
//            flip: false
//          }
  }
}
