import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: effect
    name: "blinders"

    Shader { file: "blinders" }
    TextureSel { textureUnit: 0; }
    TextureImage { textureUnit: 1;  file: "../../images/system/random16.png" }
    property real blinderSize: Math.max(1.0, s("size"))

    ShaderAtomicCounter { name: effect.name+".sac"; clear: true; bind: 0 }

    DrawVB {
        type: "emptyVBO"
        primType: "triangles"
        vboId: sceneName+effect.name+"triTest"
        depthTest: true; depthWrite: false
        blendMode: "off"

        drawNumPoints: 2*3*(1280.0*720.0/(blinderSize*blinderSize))

        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
        Pos { x: 0.0; y: 0.0; z: 0.0}
        Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }

        ShaderParam { paramName: "size"; paramValue: blinderSize }
        ShaderParam { paramName: "rot"; paramValue: s("rot") }
        ShaderParam { paramName: "rotPosX"; paramValue: s("rotPosX") }
        ShaderParam { paramName: "rotPosY"; paramValue: s("rotPosY") }
        ShaderParam { paramName: "rotNoise"; paramValue: s("rotNoise") }
        ShaderParam { paramName: "amp"; paramValue: s("amp") }

    }
}
