import QtQuick 2.4
import AdaptDemoSystem 1.0

Effect {
    id: box
    effectName: "FlatMesh"

    property bool depthTestActive: s("draw.depth.TestEnabled", 1.0) > 0.5
    property bool depthWriteActive: s("draw.depth.WriteEnabled", 1.0) > 0.5


    // RT>0: render effect to rendertarget with name "fxRT"+RT & "fxRTP"+RT
    property int effectRT: s("RT", 0)
    property string effectRTName: "fxRT"+(effectRT.toString())
    property string effectRTPrevName: "fxRTP"+(effectRT.toString())
    property bool clearRT: s("RT.clear", 1.0) > 0.5

    RenderTarget {
        enabled: effectRT>0 && clearRT
        RenderTargetLayer {
            textureRT: effectRTPrevName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
        DrawRT {
            textureRT: effectRTName
            drawBuffers: 1
        }
    }

    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                enabled: clearRT
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
            mode: 1 // mode 1 = start render to the effect RT
        }
    }



    Shader {
      enabled: setShader
      file: "smFlatMesh"
    }

    property real pcx: sf("trans.cen.x", 0.0)
    property real pcy: sf("trans.cen.y", 0.0)
    property real pcz: sf("trans.cen.z", 0.0)

    property bool origScale: s("draw.origScale", 0.0) < 0.5

    property real uvScale: syncIn(box.name+".mat.texAll.uvScale", 1.0);


    TextureSel { nameOverride: box.name+".mat.texLay1.texInd"; textureUnit: 0; }
    property int texLay1: s("mat.texLay1.texInd", 0.0)
    TextureSel { nameOverride: box.name+".mat.texLay2.texInd"; textureUnit: 2; }
    property int texLay2: s("mat.texLay2.texInd", 0.0)
    TextureSel { nameOverride: box.name+".mat.texLay3.texInd"; textureUnit: 7; }
    property int texLay3: s("mat.texLay3.texInd", 0.0)


    DrawMesh {
        id: meshi
        property string name: box.name
        file: meshSel(box.name+".draw")
    //    file2: meshSel2(box.name+".draw")
    //    depthTest: depthTestIn !== undefined ? depthTestIn : (s("draw.depthEnabled", 1.0) > 0.5)
    //    depthWrite: meshi.depthTest

        depthTest: depthTestActive
        depthWrite: depthWriteActive

        blendMode: blendSel(box.name+".draw")

        drawBuffers: 1

        cull: s("draw.cull", 0.0) > 0.5
        cullBack: true

        autoCenter: origScale; autoScale: origScale

        smoothNormals: true; normalSmoothAngle: 80;

        Pos { x: sf("trans.pos.x", 0.0); y: sf("trans.pos.y", 0.0); z: sf("trans.pos.z", 0.0)}
        Pos { x: -pcx; y: -pcy; z: -pcz}
        Rot { d: syncIn(box.name+".trans.rot.x", 0.0); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: syncFFTIn(box.name+".trans.rot.y", 0.0); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: syncIn(box.name+".trans.rot.z", 0.0); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: syncFFTIn(box.name+".trans.scale", 1.0); x: syncIn(box.name+".trans.scale.x", 1.0); y: syncIn(box.name+".trans.scale.y", 1.0); z: syncIn(box.name+".trans.scale.z", 1.0) }
        Pos { x: pcx; y: pcy; z: pcz}

        // ShaderParam { paramName: "g_alpha"; syncName: ns("mat.alpha"); syncDefault: 1.0 }


        // mat.texAll master settings
        ShaderParam { paramName: "g_texBrightness"; syncName: ns("mat.texAll.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_genUV"; syncName: ns("mat.texAll.genUV"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*s("mat.texAll.uvAspect", 1.0))+","+(uvScale+","+uvScale)}
        ShaderParam { paramName: "g_uvOfsX"; syncFFTName: ns("mat.texAll.uvOfsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_uvOfsY"; syncFFTName: ns("mat.texAll.uvOfsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repPow"; syncName: ns("mat.texAll.pow"); syncDefault: 1.0 }

        // mat.texLay1 settings
        ShaderParam { paramName: "g_repTex1"; paramValue: texLay1 }
        ShaderParam { paramName: "g_repUVBase1"; syncName: ns("mat.texLay1.base"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOp1"; syncName: ns("mat.texLay1.op"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVAmp1"; syncName: ns("mat.texLay1.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVSca1"; syncName: ns("mat.texLay1.sca"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOfsX1"; syncName: ns("mat.texLay1.ofsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOfsY1"; syncName: ns("mat.texLay1.ofsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVRot1"; syncName: ns("mat.texLay1.rot"); syncDefault: 0.0 }

        // mat.texLay2 settings
        ShaderParam { paramName: "g_repTex2"; paramValue: texLay2 }
        ShaderParam { paramName: "g_repUVBase2"; syncName: ns("mat.texLay2.base"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOp2"; syncName: ns("mat.texLay2.op"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVAmp2"; syncName: ns("mat.texLay2.amp"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVSca2"; syncName: ns("mat.texLay2.sca"); syncDefault: 1.0 }
        ShaderParam { paramName: "g_repUVOfsX2"; syncName: ns("mat.texLay2.ofsX"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVOfsY2"; syncName: ns("mat.texLay2.ofsY"); syncDefault: 0.0 }
        ShaderParam { paramName: "g_repUVRot2"; syncName: ns("mat.texLay2.rot"); syncDefault: 0.0 }


    }



    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            mode: 2 // mode 2 = end render to the effect RT
        }
    }


}
