import QtQuick 2.4
import AdaptDemoSystem 1.0

// pala flow fluidy sim
// assumes nothing else than the bg at "bgBlur" rt

Effect {
    // pala flow
    id: palaFlow
    name: "palaFlow"
    effectName: "PalaFlow"
 //   enabled: syncRoot(name+".ON", 0.0) > 0.5

  //  property bool useEmitBuf: sync(name+".useEmitBuf", 0.0) > 0.5

    property int effectWidth: 1280
    property int effectHeight: 720

    property bool reset: syncTrigger(name+".reset") > 0.5

    property bool useBreakinCenter: sync(name+".useBreakinCenter", 0.0) > 0.5

    property real cenX2D: useBreakinCenter ? demo.getSavePointX2D("breakin_SP") : sync(name+".zoomCenX", 0.0)
    property real cenY2D: useBreakinCenter ? demo.getSavePointY2D("breakin_SP") : sync(name+".zoomCenY", 0.0)

    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "palaFlowSim1"; format: "RGBA32F";
            width: effectWidth; height: effectHeight
            Clear {
                enabled: frameIndex<2 || palaFlow.reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "palaFlowSim2"; format: "RGBA32F";
            width: effectWidth; height: effectHeight
            Clear {
                enabled: frameIndex<2 || palaFlow.reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    VariClockTrigger {
        id: flowPhaseClock
        clockSpeed: sync(palaFlow.name+".noiseSpeed")*0.1*sync(palaFlow.name+".noiseFreq")
        reset: syncTrigger(palaFlow.name+".reset")
    }

    Shader { file: "palaFlow" }

    Blit { textureRT: "current" }

//    Texture { textureUnit: 0; textureRT: "current" }
    Texture { textureUnit: 0; textureRT: "current" }
    Texture { textureUnit: 1; textureWrap: "clamp"; textureRT: ((frameIndex&1)===0) ? "palaFlowSim1" : "palaFlowSim2" }
    Texture { textureUnit: 2; textureRT: "emitBuf" }
    Texture { textureUnit: 4; textureRT: "mainDepth" }

    RenderTarget {
        RenderTargetLayer {
            textureRT: ((frameIndex&1)===0) ? "palaFlowSim2" : "palaFlowSim1"
            format: "RGBA32F";
            width: effectWidth; height: effectHeight
        }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1
            ShaderParam { paramName: "g_prevAmount"; paramValue: 1.0 }

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            ShaderParam { paramName: "cenX2D"; paramValue: cenX2D }
            ShaderParam { paramName: "cenY2D"; paramValue: cenY2D }

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            // .useEmitBuf

            ShaderParam { paramName: "useEmitBuf"; syncName: ns("useEmitBuf"); }

            ShaderParam { paramName: "freq"; paramValue: sync(palaFlow.name+".noiseFreq", 0.1) }
            ShaderParam { paramName: "amp"; paramValue: sync(palaFlow.name+".noiseAmp", 1.0) }
            ShaderParam { paramName: "prev"; paramValue: sync(palaFlow.name+".flowPrev", 0.99) }
            ShaderParam { paramName: "dirX"; paramValue: sync(palaFlow.name+".flowDirX", 0.0) }
            ShaderParam { paramName: "dirY"; paramValue: sync(palaFlow.name+".flowDirY", 0.0) }
            ShaderParam { paramName: "g_feedThr"; paramValue: sync(palaFlow.name+".feedThr", 0.0) }
            ShaderParam { paramName: "g_feedPow"; paramValue: sync(palaFlow.name+".feedPow", 1.0) }
            ShaderParam { paramName: "g_feedAmp"; paramValue: sync(palaFlow.name+".feedAmp", 1.0) }
            ShaderParam { paramName: "g_feedZoom"; paramValue: syncFFT(palaFlow.name+".feedZoom", 1.0) }
            ShaderParam { paramName: "g_feedColor"; paramValueVec4: sync(palaFlow.name+".feedColR", 1.0)+","+sync(palaFlow.name+".feedColG", 1.0)+","+sync(palaFlow.name+".feedColB", 1.0) }
            ShaderParam { paramName: "phase"; paramValue: flowPhaseClock.time }

            //            float freq = 3.0;
            //            float amp = 5.0;
            //            float prev = 0.95;
            //            float dirX = 0.0;
            //            float dirY = -0.25;
            //            float phase = 0.0; // = g_time*freq;
        }
    }
    Shader { file: "mixFlow" }
    Texture { textureUnit: 0; textureRT: "current" }
    Texture { textureUnit: 1; textureRT: ((frameIndex&1)===0) ? "palaFlowSim2" : "palaFlowSim1" }
    Texture { textureUnit: 2; textureRT: "bgBlur" }

    Texture { textureUnit: 3; textureRT: "currentAlpha" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "g_currentAmount"; paramValue: sync(palaFlow.name+".currentAmount", 1.0) }
        ShaderParam { paramName: "g_prevAmount"; paramValue: syncFFT(palaFlow.name+".flowAmount", 1.0) }
        ShaderParam { paramName: "g_darkenAmp"; paramValue: sync(palaFlow.name+".darkenAmp", 0.50) }
        ShaderParam { paramName: "g_darkenPow"; paramValue: sync(palaFlow.name+".darkenPow", 0.50) }
    }
}
