import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property alias simShaderParams: simPar.delegate
    property string drawShader: "partWater"
    property alias drawShaderParams: drawPar.delegate
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true

    property real syncDepthEnabled: sync(partSim.name+".draw.depthEnabled", 1.0)

    property bool drawDepthEnabled: (syncDepthEnabled > 0.5) && (syncDepthEnabled < 1.5)
    property bool drawDepthWrite: (syncDepthEnabled > 1.5)
    property bool drawDepthTest: (syncDepthEnabled < 2.5)

    property real partSize: 0.50
    property int particleCount: advanceSim.particleCount

    onParticleCountChanged: {
        root.setCustomText(name, name+": particle count", "Particle count:"+particleCount);
    }

    signal particleCountTo(int pc)

    Blit { textureRT: "screenBuffer" }

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;"


    property real partSimReset: syncTrigger(spaceVortex.name+".sim.reset")


    VariClockTrigger {
        id: simNoiseMoveX
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.x")
        reset: partSimReset
    }
    VariClockTrigger {
        id: simNoiseMoveY
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.y")
        reset: partSimReset
    }
    VariClockTrigger {
        id: simNoiseMoveZ
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.z")
        reset: partSimReset
    }

    // ----------------------------------------
    // PARTICLES TO MESH stuff, used if enabled
    // this is implemented so that a selected mesh
    // is rendered to 3D grid as linked list, and then
    // in particle simulation this data-structure is consulted
    // for nearby triangles
    // ----------------------------------------

    property bool particleToMeshEnabled: sync(partSim.name+".p2m.ON")

    function isMeshTexUpdating() {
        return true;
    }

    property int gWidth: 500

    Group {
        id: transMesh
        enabled: particleToMeshEnabled
        property string shaderVaryings: "
            vec3 posG;
            vec3 normalG;
            vec2 uvG;
            vec3 tangentG;"

        property int triangleTexDim: 512

        Shader {
            file: "smTexSpaceTrans"; tfVaryings: transMesh.shaderVaryings;
            ShaderParam { paramName: "g_emit"; paramValue: 0.0}
            //            ShaderParam { paramName: "g_zoomAmount"; paramValue: 1.0+zoomPercent}
        }

        // start drawing (with transform feedback) triangles to sceneName+"trans" named vertex buffer object (vbo)
        // all Draw* after this and before "drawStop" has the render to the screen disabled (goes only to the vertex buffer)
        DrawVB {
            type: "drawStart"; primType: "triangles"; vboId: partSim.name+".transMesh"; tfVaryings: transMesh.shaderVaryings;
            enabled: true
            gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false
            ShaderParam { paramName: "g_emit"; paramValue: 0.0}
        }
        DrawMesh {
            property string meshFile: meshSel(partSim.name+".p2m")
            file: meshFile
//            onMeshFileChanged: {
//                mesh.triggerMeshTexUpdate();
//            }
            enabled: true; smoothNormals: true; normalSmoothAngle: 80;
            depthTest: true; depthWrite: true;

            property real meshScale: sync(partSim.name+".p2m.meshScale")
          //  onMeshScaleChanged: mesh.triggerMeshTransUpdate();

            property real meshX: sync(partSim.name+".p2m.meshX")
            property real meshY: sync(partSim.name+".p2m.meshY")
            property real meshZ: sync(partSim.name+".p2m.meshZ")

//            onMeshXChanged: mesh.triggerMeshTransUpdate();
//            onMeshYChanged: mesh.triggerMeshTransUpdate();
//            onMeshZChanged: mesh.triggerMeshTransUpdate();

            property real recLimit: sync(partSim.name+".p2m.subdiv")

          //  onRecLimitChanged: mesh.triggerMeshTexUpdate()

            cull: false; cullBack: false
            Pos { x: parent.meshX; y: parent.meshY; z: parent.meshZ}
            Rot { d: sync(partSim.name+".p2m.rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: sync(partSim.name+".p2m.rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: sync(partSim.name+".p2m.rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
            Sca { s: parent.meshScale; x: 1.0; y: 1.0; z: 1.0 }

            ShaderParam { paramName: "g_emit"; paramValue: 1.0}
            ShaderParam { paramName: "recLimit"; paramValue: parent.recLimit}
        }
        // stop drawing to the vertex buffer (with transform feedback)
        DrawVB {
            enabled: true
            type: "drawStop";  primType: "triangles"; vboId: partSim.name+".transMesh"; tfVaryings: transMesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
        }


        RenderTarget {
            RenderTargetLayer {
                id: triangleInfo
                textureRT: "triangleInfo"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: dim*3
                height: dim
                Clear {
                    enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }
        RenderTarget {
            RenderTargetLayer {
                id: triangleIds
                textureRT: "triangleIds"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: 3*dim
                height: dim
                Clear {
                    enabled: isMeshTexUpdating()
                    cR: -1.0; cG: -1.0; cB: -1.0; cA: 1.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: edgeGridHeadPointers
                textureRT: "edgeGridHeadPointers"
                format: "R32F"
                property int baseDim: 12
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
                Clear {
                    enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: edgeDataCenter
                textureRT: "edgeDataCenter"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: 2*dim
                height: dim
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: edgeDataIds
                textureRT: "edgeDataIds"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: 2*dim
                height: dim
            }
        }

        ShaderAtomicCounter { name: partSim.name+".sacP2M"; clear: true }

        Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
        Shader { file: "smGenTriangleTex" }
        DrawVB {
            id: genTriangleTex
            enabled: true
            type: "pointGridDraw"
            primType: "triangles"
            vboId: partSim.name+".transMesh"
            tfVaryings: transMesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000
            drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_texW"; paramValue: triangleInfo.width }
            ShaderParam { paramName: "g_texH"; paramValue: triangleInfo.height }
            ShaderParam { paramName: "g_triangleTexDim"; paramValue: transMesh.triangleTexDim }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            blendMode: "off"
        }

    } // END OF Mesh to linked list 3d GRID



    // BEGIN SPH
    property bool sphEnabled: sync(partSim.name+".sph.ON")

    Group {
        id: sphParticleGrid

        enabled: sphEnabled

        // one edge dimension is baseDim*baseDim
        // for example for baseDim=12 -> 12*12=144 units grid, so 144^3=2985984 = about 3 million grid points
        // for example for baseDim=10 -> 10*10=100 units grid, so 100^3=1000000 = about 1 million grid points
        property int baseDim: 10

        // max particles is particleInfoTexDim*particleInfoTexDim
        property int particleInfoTexDim: 2048




        RenderTarget {
            RenderTargetLayer {
                id: particleGridCounts
                textureRT: "particleGridCounts"
                format: "R32F"
                property int baseDim: sphParticleGrid.baseDim
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: particleGridOfs
                textureRT: "particleGridOfs"
                format: "R32F"
                property int baseDim: sphParticleGrid.baseDim
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: particleGridWriteOfs
                textureRT: "particleGridWriteOfs"
                format: "R32F"
                property int baseDim: sphParticleGrid.baseDim
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: particleArrPos
                textureRT: "particleArrPos"
                format: "RGBA32F"
                width: partSim.gridDimension
                height: partSim.gridDimension
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: particleArrVel
                textureRT: "particleArrVel"
                format: "RGBA32F"
                width: partSim.gridDimension
                height: partSim.gridDimension
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: particleArrDensity
                textureRT: "particleArrDensity"
                format: "RGBA32F"
                width: partSim.gridDimension
                height: partSim.gridDimension
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        Texture { textureUnit: 0; imageUnit: 0; textureRT: "particleGridCounts"; }
//        Texture { textureUnit: 1; imageUnit: 1; textureRT: "particleGridHeadPointers"; }
//        Texture { textureUnit: 2; imageUnit: 2; textureRT: "particleIds"; }


        property real gridCellSize: Math.max(0.01, sync(partSim.name+".sph.cellSize"))

        // step 1. generate particle grid counts (how many particles in each cell)
        Shader { file: "smGenParticleGrid" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            name: partSim.name
            vboId: sceneName+partSim.name

            blendMode: drawBlendMode

            depthTest: drawDepthTest
            depthWrite: drawDepthWrite

            tfVaryings: shaderVaryings
            gridWidth: partSim.gridDimension
            gridHeight: partSim.gridDimension
            drawNumPoints: partSim.drawNumPoints

          //  depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: sphParticleGrid.baseDim }
            ShaderParam { paramName: "g_gridCellSize"; paramValue: sphParticleGrid.gridCellSize }
            ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale", 1.0) }
            drawBuffers: 3
        }


        // step 2. Calculate particle grid => array offsets (each cell has unique offset for global array)
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "particleGridCounts"; }
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "particleGridOfs"; }
      //  ShaderAtomicCounter { name: partSim.name+".sphArrayIndex"; clear: true; bind: 0 }
      //  Shader { file: "smGenParticleOfs" }
        RenderTarget {
            RenderTargetLayer {
                textureRT: "tempParticleGrid" // does not render here, instead to the above texture image buffer "particleGridOfs"
                format: "R32F"
                property int baseDim: sphParticleGrid.baseDim
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
            }
            Shader { file: "smGenParticleOfs" }
            DrawVB {
                type: "quad"
                depthTest: false; depthWrite: false
                ShaderParam { paramName: "flip"; paramValue: 1.0 }
                blendMode: "off"
                drawBuffers: 0
            }
        }

        // step 3. Put particle positions & velocities into global array using "particleGridOfs" & "particleGridCounts" created in steps 1. & 2.
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "particleGridCounts"; }
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "particleGridOfs"; }
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "particleGridWriteOfs"; }
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "particleArrPos"; }
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "particleArrVel"; }
        Shader { file: "smGenParticleArr" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            name: partSim.name
            vboId: sceneName+partSim.name

            blendMode: drawBlendMode

            depthTest: drawDepthTest
            depthWrite: drawDepthWrite

            tfVaryings: shaderVaryings
            gridWidth: partSim.gridDimension
            gridHeight: partSim.gridDimension
            drawNumPoints: partSim.drawNumPoints

          //  depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: sphParticleGrid.baseDim }
            ShaderParam { paramName: "g_gridCellSize"; paramValue: sphParticleGrid.gridCellSize }
            ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale", 1.0) }
            drawBuffers: 0
        }

        // second time so it gets cleared
        RenderTarget {
            RenderTargetLayer {
                textureRT: "particleGridWriteOfs"
                format: "R32F"
                property int baseDim: sphParticleGrid.baseDim
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
                Clear {
                    //enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        // step 4. generate particle density
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "particleGridCounts"; }
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "particleGridOfs"; }
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "particleGridWriteOfs"; }
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "particleArrPos"; }
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "particleArrVel"; }
        Texture { textureUnit: 5; imageUnit: 5; textureRT: "particleArrDensity"; }
        Shader { file: "smGenParticleDensity" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            name: partSim.name
            vboId: sceneName+partSim.name

            blendMode: drawBlendMode

            depthTest: drawDepthTest
            depthWrite: drawDepthWrite

            tfVaryings: shaderVaryings
            gridWidth: partSim.gridDimension
            gridHeight: partSim.gridDimension
            drawNumPoints: partSim.drawNumPoints

          //  depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: sphParticleGrid.baseDim }
            ShaderParam { paramName: "g_gridCellSize"; paramValue: sphParticleGrid.gridCellSize }
            ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale", 1.0) }
            drawBuffers: 0
        }
    }

    // END OF SPH stuff...





    ShaderAtomicCounter { name: spaceVortex.name+"sacVortex1"; clear: false }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: partSim.name+"emitVortexPartPos" }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: partSim.name+"emitVortexPartVel" }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: partSim.name+"emitVortexPartCol" }

    // TBD fix make dependant of sim shader!
  //  Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeGridHeadPointers"; }
  //  Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataCenter"; }
  //  Texture { textureUnit: 6; imageUnit: 6; textureRT: "edgeDataIds"; }

    Texture { textureUnit: 3; imageUnit: 3; textureRT: "particleGridCounts"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "particleGridOfs"; }
    Texture { textureUnit: 5; imageUnit: 5; textureRT: "particleArrPos"; }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "particleArrVel"; }
    Texture { textureUnit: 7; imageUnit: 7; textureRT: "particleArrDensity"; }

    property alias tex0: t0.delegate
    Repeater { id: t0; model: 1 }
    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/system/random16.png"
        }
    }
    property alias tex2: t2.delegate
    Repeater { id: t2; model: 1 }

    Texture { textureUnit: 3; textureRT: "depth" } // world space normal in rgb components
    Texture { textureUnit: 4; textureRT: "mainDepth" }
    Texture { textureUnit: 5; textureRT: "prevBlur" }

    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------
    Shader {
        file: simShader
        tfVaryings: shaderVaryings
    }
    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+partSim.name

        property real resetOn: partSimReset

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
                // console.log("particles reset now");
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            particleCountTo(particleCount);
        }

        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
        ShaderParam { paramName: "g_velDamping"; paramValue: sync(partSim.name+".sim.velDamping", 1.0) }
        property real noiseScaleAll: sync(partSim.forceName+".simNoiseScale.all", 1.0);
        property real nsx: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.x")
        property real nsy: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.y")
        property real nsz: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.z")

        ShaderParam { paramName: "g_noiseScale"; paramValueVec4: parent.nsx+","+parent.nsy+","+parent.nsz }
        ShaderParam { paramName: "g_noiseMove"; paramValueVec4: simNoiseMoveX.time+","+simNoiseMoveY.time+","+simNoiseMoveZ.time }
        ShaderParam { paramName: "g_noiseOfs"; paramValueVec4: sync(partSim.name+".simDirForce.x")+","+sync(partSim.name+".simDirForce.y")+","+syncFFT(partSim.name+".simDirForce.z") }
        ShaderParam { paramName: "g_force"; paramValue: sync(partSim.forceName+".sim.force", 2.0) }
        ShaderParam { paramName: "g_noiseFreq"; paramValue: sync(partSim.forceName+".sim.noiseFreq", 1.0) }
        ShaderParam { paramName: "g_speed"; paramValue: sync(partSim.forceName+".sim.speed", 1.0) }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge", 10.0) }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".sim.elasticity", 0.5) }
        ShaderParam { paramName: "g_frict"; paramValue: sync(partSim.name+".sim.frict", 0.5) }
        ShaderParam { paramName: "g_splitThr"; paramValue: sync(partSim.name+".sim.splitThr", 0.0) }
        ShaderParam { paramName: "g_splitAmpRand"; paramValue: sync(partSim.name+".sim.splitAmpRand", 1.0) }
        ShaderParam { paramName: "g_splitAmpNorm"; paramValue: sync(partSim.name+".sim.splitAmpNorm", 1.0) }
        ShaderParam { paramName: "g_noiseSpeed"; paramValue: sync(partSim.name+".sim.noiseSpeed", 1.0) }
        ShaderParam { paramName: "g_noiseRec"; paramValue: sync(partSim.name+".sim.noiseRec", 0.0) }

        ShaderParam { paramName: "g_triangleTexDim"; paramValue: transMesh.triangleTexDim }
        ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: simShader === "partSim" ? edgeGridHeadPointers.baseDim : sphParticleGrid.baseDim }
        ShaderParam { paramName: "g_gridCellSize"; paramValue: sphParticleGrid.gridCellSize }

        ShaderParam { paramName: "g_sphEnabled"; paramValue: partSim.sphEnabled }
        ShaderParam { paramName: "g_sph_delayRelax"; paramValue: sync(partSim.name+".sph.delayRelax", 1.0) }
        ShaderParam { paramName: "g_sph_force"; paramValue: sync(partSim.name+".sph.force", 0.25) }
        ShaderParam { paramName: "g_sph_p0"; paramValue: sync(partSim.name+".sph.p0", 0.01) }
        ShaderParam { paramName: "g_sph_visc"; paramValue: sync(partSim.name+".sph.visc", 0.10) }
        ShaderParam { paramName: "g_sph_damp"; paramValue: sync(partSim.name+".sph.damp", 2.0) }
        ShaderParam { paramName: "g_sph_surfTension"; paramValue: sync(partSim.name+".sph.surfTens", 500.0) }
        ShaderParam { paramName: "g_leapFrog"; paramValue: sync(partSim.name+".sph.leapFrog", 0.0) }

        ShaderParam { paramName: "g_reset"; paramValue: partSimReset }


//        uniform float g_sph_delayRelax = 1.0;
//        uniform float g_sph_force = 0.25;
//        uniform float g_sph_p0 = 0.01;
//        uniform float g_sph_visc = 0.1;
//        uniform float g_sph_damp = 2.0;
//        uniform float g_sph_surfTension = 500.0;

        ShaderParam { paramName: "g_partToMeshForce"; paramValue: sync(partSim.name+".p2m.force", 0.0) }
        ShaderParam { paramName: "g_partToMeshVelDamp"; paramValue: sync(partSim.name+".p2m.velDamp", 0.05) }



        // inject custom shader params
        Repeater { id: simPar; model: 1 }
    }

    // ----------------------------------------
    // PARTICLES TO MESH stuff, used if enabled
    // ----------------------------------------
//    property bool particleToMeshEnabled: sync(partSim.name+".p2m.ON")
//    function isParticleToMeshUpdating() {
//        return true;
//    }
//    Group {
//        id: particleToMeshPost
//        enabled: particleToMeshEnabled
//    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "particleGridCounts"; }
    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: drawDepthTest
        depthWrite: drawDepthWrite

        // blendMode: "normal"
        blendMode: drawBlendMode
        // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        ShaderParam { paramName: "g_partSize"; paramValue: partSize }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge") }
        ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale", 1.0) }


        ShaderParam { paramName: "g_palaEmitFadeZ"; paramValue: sync(partSim.name+".draw.palaEmitFadeZ", 0.0) }
        ShaderParam { paramName: "g_palaEmitGainZ"; paramValue: sync(partSim.name+".draw.palaEmitGainZ", -9999.0) }
        ShaderParam { paramName: "g_palaEmit"; paramValue: sync(partSim.name+".draw.palaEmit", 0.0) }
        ShaderParam { paramName: "g_palaEmitThr"; paramValue: sync(partSim.name+".draw.palaEmitThr", 0.0) }

        // inject custom shader params
        Repeater { id: drawPar; model: 1 }

        drawBuffers: 3
    }

//    Shader {
//        file: sceneDir+"partDepthOnly"
//    }
    DrawVB { // depth only draw
        enabled: drawDepthEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: true

        // blendMode: "normal"
        blendMode: "add"
        // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        drawBuffers: 1
    }






}
