import QtQuick 2.3
import AdaptDemoSystem 1.0
import QtGraphicalEffects 1.0
import "../"
import "../_SharedQML"

Effect {
    id: fx
    name: "partor"
    effectName: "Partor"
    enabled: syncRootOn(effect.name, effectName)

    property int sWidth: s("fx.width", 0)
    property int sHeight: s("fx.height", 0)

    property int effectWidth: sWidth!==0 ? sWidth : demo.windowWidth
    property int effectHeight: sHeight!==0 ? sHeight : demo.windowHeight

    property bool reset: syncTrigger(name+".reset") > 0.5

    property int srcRT: s("srcRT", 1)
    property string srcRTName: "fxRT"+(srcRT.toString())
    property string srcRTPrevName: "fxRTP"+(srcRT.toString())

    Blit {
        enabled: srcRT===0
        textureRT: srcRTName
    }


    property int srcRTDist: s("srcRT.dist", 0)
    property string srcRTDistName: "fxRT"+(srcRTDist.toString())

    ShaderAtomicCounter { name: fx.name+".nextFreeParticle"; clear: reset; bind: 0 }

    Texture { textureUnit: 0; textureRT: srcRTName }
    Texture { textureUnit: 1; textureRT: srcRTPrevName }
    //Texture { textureUnit: 2; textureWrap: "clamp"; textureRT: ((frameIndex&1)===0) ? fx.name+"Parts1" : fx.name+"Parts2" }
    //Texture { textureUnit: 3; textureWrap: "clamp"; textureRT: ((frameIndex&1)===1) ? fx.name+"Parts1" : fx.name+"Parts2" }

    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;
        }
    }

      property int ptw: 2048
      property int pth: 2048

    property int partNumMode: Math.min(Math.max(0, s("numMode", 0)), 12) // 0: 4096x4096, 1: 2048x2048, 2: 1024x1024, 3: 512x512, 4: 256x256, 5: 128x128, 6: 64x64, 7: 32x32, 8: 16x16

    //property int ptw: frameIndex<10 ? 4096 : 4096/Math.pow(2, partNumMode)
    //property int pth: ptw

    property string ptName: ptw.toString()+"x"+pth.toString()

    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"Particles"+ptName; format: "RGBA32F";
            width: fx.ptw; height: fx.pth
            Clear {
                enabled: frameIndex<2 || reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"ParticlesSUV"+ptName; format: "RGBA32F";
            width: fx.ptw; height: fx.pth
            Clear {
                enabled: frameIndex<2 || reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

//    RenderTarget {
//        RenderTargetLayer {
//            textureRT: fx.name+"ParticlesCol"; format: "RGBA32F";
//            width: fx.ptw; height: fx.pth
//            Clear {
//                enabled: frameIndex<2 || reset
//                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//            }
//        }
//    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"ParticlesVel"+ptName; format: "RGBA32F";
            width: fx.ptw; height: fx.pth
            Clear {
                enabled: frameIndex<2 || reset
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }


    Shader { file: "spartorEmit" }
    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"temp"
            format: "RGBA32F";
            width: effectWidth; height: effectHeight
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: fx.name+"Particles"+ptName } // write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: fx.name+"ParticlesSUV"+ptName } // write
        Texture { textureUnit: 2; imageUnit: 2; textureRT: fx.name+"ParticlesVel"+ptName } // write
        //Texture { textureUnit: 3; imageUnit: 3; textureRT: fx.name+"ParticlesCol" } // write
        Texture { textureUnit: 0; textureRT: srcRTName }
        Texture { textureUnit: 1; textureRT: srcRTPrevName }

        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1

            ShaderParam { paramName: "approachOrigSize"; paramValue: s("approach.origSize", 1.0) }
            ShaderParam { paramName: "approachRandSize"; paramValue: s("approach.randSize", 0.10) }

            ShaderParam { paramName: "emitsNum"; paramValue: s("emits.num", 1.0) }
            ShaderParam { paramName: "emitsSpread"; paramValue: s("emits.spread", 1.0) }
            ShaderParam { paramName: "emitsSpreadAmp"; paramValue: s("emits.spreadAmp", 1.0) }
            ShaderParam { paramName: "emitsSpreadFade"; paramValue: s("emits.spreadFade", 0.20) }
            ShaderParam { paramName: "emitsSpreadUV"; paramValue: s("emits.spreadUV", 0.50) }
            ShaderParam { paramName: "emitsLimit"; paramValue: s("emits.limit", 0.02) }
            ShaderParam { paramName: "emitsLimitPrev"; paramValue: s("emits.limitPrev", 0.01) }

            ShaderParam { paramName: "emitsAmount"; paramValue: s("emits.amount", 1.0) }
            ShaderParam { paramName: "emitsFollowersNum"; paramValue: s("followers.num", 0.0) }

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            ShaderParam { paramName: "ptw"; paramValue: ptw }
            ShaderParam { paramName: "pth"; paramValue: pth }


        }
    }

    //    Texture { textureUnit: 2; textureRT: fx.name+"Particles" } // read & write
    //    Texture { textureUnit: 3; textureRT: fx.name+"ParticlesSUV" } // read & write
    Texture { textureUnit: 2; textureRT: srcRTDistName }

    Shader { file: "spartorSim" }
    RenderTarget {
        RenderTargetLayer {
            textureRT: fx.name+"temp2"
            format: "RGBA32F";
            width: fx.ptw; height: fx.pth
        }

        Texture { textureUnit: 0; imageUnit: 0; textureRT: fx.name+"Particles"+ptName } // read & write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: fx.name+"ParticlesSUV"+ptName } // read & write
        Texture { textureUnit: 2; imageUnit: 2; textureRT: fx.name+"ParticlesVel"+ptName } // read & write
        Texture { textureUnit: 0; textureRT: srcRTName }
        Texture { textureUnit: 1; textureRT: srcRTPrevName }
        Texture { textureUnit: 2; textureRT: srcRTDistName }

        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            ShaderParam { paramName: "approachOrigSize"; paramValue: s("approach.origSize", 1.0) }
            ShaderParam { paramName: "approachRandSize"; paramValue: s("approach.randSize", 0.10) }
            ShaderParam { paramName: "approachSpeed"; paramValue: s("approach.speed", 0.50) }
            ShaderParam { paramName: "approachNoiseFreq"; paramValue: s("approach.noise.freq", 2.0) }
            ShaderParam { paramName: "approachNoiseDist"; paramValue: s("approach.noise.dist", 0.50) }
            ShaderParam { paramName: "approachNoiseDistOfs"; paramValue: s("approach.noise.distOfs", 1.0) }
            ShaderParam { paramName: "approachNoiseAmp"; paramValue: s("approach.noise.amp", 1.0) }
            ShaderParam { paramName: "approachNoiseSpeed"; paramValue: s("approach.noise.speed", 0.50) }
            ShaderParam { paramName: "approachLimit"; paramValue: s("approach.limit", 0.02) }

            ShaderParam { paramName: "vaporizeOrigShape"; paramValue: s("vaporize.origShape", 1.0) }
            ShaderParam { paramName: "vaporizeSpeed"; paramValue: s("vaporize.speed", 1.0) }
            ShaderParam { paramName: "vaporizeNoiseAmp"; paramValue: s("vaporize.noise.amp", 2.0) }
            ShaderParam { paramName: "vaporizeNoiseDist"; paramValue: s("vaporize.noise.dist", 2.0) }
            ShaderParam { paramName: "vaporizeNoiseFreq"; paramValue: s("vaporize.noise.freq", 1.50) }
            ShaderParam { paramName: "vaporizeNoiseDistOfs"; paramValue: s("vaporize.noise.distOfs", 2.0) }
            ShaderParam { paramName: "vaporizeNoiseSpeed"; paramValue: s("vaporize.noise.speed", 0.20) }

            ShaderParam { paramName: "vaporizeTime"; paramValue: s("vaporize.time", 1.0) }

            ShaderParam { paramName: "velocityAmount"; paramValue: s("velocity.amount", 0.0) }

            ShaderParam { paramName: "distEnabled"; paramValue: srcRTDist > 0 ? 1.0 : 0.0 }

            ShaderParam { paramName: "distAttractAmount"; paramValue: s("dist.attract.amount", 1.0) }
            ShaderParam { paramName: "distAttractExp"; paramValue: s("dist.attract.exp", 1.0) }
            ShaderParam { paramName: "distAttractLim"; paramValue: s("dist.attract.lim", 0.50) }

            ShaderParam { paramName: "distAttract2Amount"; paramValue: s("dist.attract2.amount", 0.0) }
            ShaderParam { paramName: "distAttract2Exp"; paramValue: s("dist.attract2.exp", 1.0) }
            ShaderParam { paramName: "distAttract2Lim"; paramValue: s("dist.attract2.lim", 0.50) }

            ShaderParam { paramName: "distParallelAmount"; paramValue: s("dist.parallel.amount", 0.0) }
            ShaderParam { paramName: "distParallelExp"; paramValue: s("dist.parallel.exp", 1.0) }
            ShaderParam { paramName: "distParallelLim"; paramValue: s("dist.parallel.lim", 0.50) }

            ShaderParam { paramName: "distGradWidth"; paramValue: s("dist.grad.width", 20.0) }

            ShaderParam { paramName: "followerSpeed"; paramValue: s("followers.speed", 0.50) }
            ShaderParam { paramName: "followerDist"; paramValue: s("followers.dist", 0.0) }
            ShaderParam { paramName: "followerDistFade"; paramValue: s("followers.distFade", 0.0) }

            ShaderParam { paramName: "noiseAspect"; paramValue: s("noise.aspect", 1.0) }
            ShaderParam { paramName: "noiseStartAngle"; paramValue: s("noise.angle.start", 0.0) }
            ShaderParam { paramName: "noiseOctAngle"; paramValue: s("noise.angle.oct", 0.0) }

        }
    }




    Blit {
        textureRT: "colorBuffer"
    }

    //    ClearRT {
    //    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "partsColors"; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "partsMask"; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    property int partsNum: ptw*pth

    Shader { file: "spartorDrawG" }
    Texture { textureUnit: 0; textureWrap: "clamp"; textureRT: fx.name+"Particles"+ptName }
    Texture { textureUnit: 1; textureRT: srcRTName }
    TextureSel { nameOverride: effect.name+".palette.texInd"; textureUnit: 2; }
    Texture { textureUnit: 3; textureRT: fx.name+"ParticlesSUV"+ptName }

    Repeater {
        model: 8
        delegate: DrawVB {
            type: "emptyVBO"
            primType: "points"
            vboId: sceneName+effect.name+".parts"
            depthTest: false; depthWrite: false
            blendMode: "add"
            drawNumPoints: (partsNum/8)

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }

            ShaderParam { paramName: "layer"; paramValue: index }

            ShaderParam { paramName: "ptw"; paramValue: ptw }
            ShaderParam { paramName: "pth"; paramValue: pth }

            ShaderParam { paramName: "effectWidth"; paramValue: effectWidth }
            ShaderParam { paramName: "effectHeight"; paramValue: effectHeight }

            ShaderParam { paramName: "bright"; paramValue: s("draw.bright", 1.0) }
            ShaderParam { paramName: "maskBright"; paramValue: s("draw.maskBright", 1.0) }

            ShaderParam { paramName: "approachFade"; paramValue: s("approach.fade", 1.0) }
            ShaderParam { paramName: "paletteFreq"; paramValue: s("palette.freq", 1.0) }
            ShaderParam { paramName: "paletteOfs"; paramValue: s("palette.ofs", 0.0) }

            ShaderParam { paramName: "drawSize"; paramValue: s("draw.size", 1.0) }

            ShaderParam { paramName: "colorMode"; paramValue: s("draw.colorMode", 0.0) }

            ShaderParam { paramName: "zoom"; paramValue: s("draw.zoom", 1.0) }


            drawBuffers: 2
            drawBufferRT: "partsColors"
            drawBufferRT2: "partsMask"
        }

    }



    //    Blit {
    //        textureRT: "partsBuffer"
    //    }

    //    Blit {
    //        textureRT: "partsMask"
    //        blitRT: 1
    //    }

    Shader { file: "mixMask" }
    Texture { textureUnit: 0; textureRT: "colorBuffer" }
    Texture { textureUnit: 1; textureRT: "partsColors" }
    Texture { textureUnit: 2; textureRT: "partsMask" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }


}

